/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.lazy.layout;

import androidx.compose.foundation.lazy.layout.IntervalList;
import androidx.compose.foundation.lazy.layout.IntervalListKt;
import androidx.compose.runtime.collection.MutableVector;
import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nIntervalList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntervalList.kt\nandroidx/compose/foundation/lazy/layout/MutableIntervalList\n+ 2 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVectorKt\n+ 3 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector\n*L\n1#1,222:1\n1208#2:223\n1187#2,2:224\n523#3:226\n523#3:227\n523#3:228\n*S KotlinDebug\n*F\n+ 1 IntervalList.kt\nandroidx/compose/foundation/lazy/layout/MutableIntervalList\n*L\n104#1:223\n104#1:224,2\n156#1:226\n158#1:227\n175#1:228\n*E\n"})
public final class MutableIntervalList<T>
implements IntervalList<T> {
    private final MutableVector<IntervalList.Interval<T>> intervals = new MutableVector((Object[])new IntervalList.Interval[16], 0);
    private int size;
    private IntervalList.Interval<? extends T> lastInterval;
    public static final int $stable = 8;

    @Override
    public final int getSize() {
        return this.size;
    }

    /*
     * WARNING - void declaration
     */
    public final void addInterval$1ef468a(int size22, T value) {
        void var2_3;
        void var1_1;
        int size22;
        if (!(size22 >= 0)) {
            String size22 = "size should be >=0, but was " + size22;
            throw new IllegalArgumentException(size22.toString());
        }
        if (size22 == 0) {
            return;
        }
        MutableIntervalList mutableIntervalList = this;
        IntervalList.Interval<T> interval = new IntervalList.Interval<T>(mutableIntervalList.size, size22, value);
        mutableIntervalList = this;
        mutableIntervalList.size += var1_1;
        this.intervals.add((Object)var2_3);
    }

    @Override
    public final void forEach(int fromIndex, int toIndex, Function1<? super IntervalList.Interval<? extends T>, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.checkIndexBounds(fromIndex);
        this.checkIndexBounds(toIndex);
        if (!(toIndex >= fromIndex)) {
            String string = "toIndex (" + toIndex + ") should be not smaller than fromIndex (" + fromIndex + ')';
            throw new IllegalArgumentException(string.toString());
        }
        int intervalIndex = IntervalListKt.access$binarySearch(this.intervals, fromIndex);
        MutableVector<IntervalList.Interval<T>> mutableVector = this.intervals;
        int itemIndex = ((IntervalList.Interval)mutableVector.getContent()[intervalIndex]).getStartIndex();
        while (itemIndex <= toIndex) {
            mutableVector = this.intervals;
            IntervalList.Interval interval = (IntervalList.Interval)mutableVector.getContent()[intervalIndex];
            block.invoke((Object)interval);
            itemIndex += interval.getSize();
            ++intervalIndex;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final IntervalList.Interval<T> get(int index) {
        IntervalList.Interval interval;
        void var1_1;
        this.checkIndexBounds(index);
        int n = var1_1;
        MutableIntervalList mutableIntervalList = this;
        Object object = mutableIntervalList.lastInterval;
        if (object != null) {
            void var5_6 = n;
            IntervalList.Interval<? extends T> interval2 = object;
            int n2 = interval2.getStartIndex();
            boolean bl = var5_6 < interval2.getStartIndex() + interval2.getSize() ? n2 <= var5_6 : false;
            if (bl) {
                return object;
            }
        }
        object = mutableIntervalList.intervals;
        n = IntervalListKt.access$binarySearch(mutableIntervalList.intervals, n);
        object = object.getContent()[n];
        mutableIntervalList.lastInterval = interval = (IntervalList.Interval)object;
        return (IntervalList.Interval)object;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkIndexBounds(int index) {
        boolean bl;
        MutableIntervalList mutableIntervalList;
        if (index >= 0) {
            mutableIntervalList = this;
            bl = index < mutableIntervalList.size;
        } else {
            bl = false;
        }
        if (!bl) {
            void var1_1;
            mutableIntervalList = this;
            throw new IndexOutOfBoundsException("Index " + (int)var1_1 + ", size " + mutableIntervalList.size);
        }
    }
}

