/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.lazy.layout;

import androidx.compose.foundation.gestures.Orientation;
import androidx.compose.foundation.lazy.layout.LazyLayoutItemProvider;
import androidx.compose.foundation.lazy.layout.LazyLayoutSemanticState;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.node.SemanticsModifierNode;
import androidx.compose.ui.node.SemanticsModifierNodeKt;
import androidx.compose.ui.semantics.CollectionInfo;
import androidx.compose.ui.semantics.ScrollAxisRange;
import androidx.compose.ui.semantics.SemanticsPropertiesKt;
import androidx.compose.ui.semantics.SemanticsPropertyReceiver;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;

final class LazyLayoutSemanticsModifierNode
extends Modifier.Node
implements SemanticsModifierNode {
    private Function0<? extends LazyLayoutItemProvider> itemProviderLambda;
    private LazyLayoutSemanticState state;
    private Orientation orientation;
    private boolean userScrollEnabled;
    private boolean reverseScrolling;
    private ScrollAxisRange scrollAxisRange;
    private final Function1<Object, Integer> indexForKeyMapping;
    private Function1<? super Integer, Boolean> scrollToIndexAction;

    /*
     * WARNING - void declaration
     */
    public LazyLayoutSemanticsModifierNode(Function0<? extends LazyLayoutItemProvider> itemProviderLambda, LazyLayoutSemanticState state, Orientation orientation, boolean userScrollEnabled, boolean reverseScrolling) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(itemProviderLambda, (String)"itemProviderLambda");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        this.itemProviderLambda = var1_1;
        this.state = var2_2;
        this.orientation = var3_3;
        this.userScrollEnabled = userScrollEnabled;
        this.reverseScrolling = reverseScrolling;
        this.indexForKeyMapping = (Function1)new Function1<Object, Integer>(this){
            final /* synthetic */ LazyLayoutSemanticsModifierNode this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final Integer invoke(Object needle) {
                void var3_3;
                Intrinsics.checkNotNullParameter((Object)needle, (String)"needle");
                LazyLayoutItemProvider itemProvider = (LazyLayoutItemProvider)LazyLayoutSemanticsModifierNode.access$getItemProviderLambda$p(this.this$0).invoke();
                int result2 = -1;
                int n = itemProvider.getItemCount();
                for (int index = 0; index < n; ++index) {
                    if (!Intrinsics.areEqual((Object)itemProvider.getKey(index), (Object)needle)) continue;
                    result2 = index;
                    break;
                }
                return (int)var3_3;
            }
        };
        this.updateCachedSemanticsValues();
    }

    public final boolean getShouldAutoInvalidate() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final void update(Function0<? extends LazyLayoutItemProvider> itemProviderLambda, LazyLayoutSemanticState state, Orientation orientation, boolean userScrollEnabled, boolean reverseScrolling) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(itemProviderLambda, (String)"itemProviderLambda");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        this.itemProviderLambda = var1_1;
        this.state = var2_2;
        if (this.orientation != orientation) {
            void var3_3;
            this.orientation = var3_3;
            SemanticsModifierNodeKt.invalidateSemantics((SemanticsModifierNode)this);
        }
        if (this.userScrollEnabled != userScrollEnabled || this.reverseScrolling != reverseScrolling) {
            this.userScrollEnabled = userScrollEnabled;
            this.reverseScrolling = reverseScrolling;
            this.updateCachedSemanticsValues();
            SemanticsModifierNodeKt.invalidateSemantics((SemanticsModifierNode)this);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void applySemantics(SemanticsPropertyReceiver $this$applySemantics) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)$this$applySemantics, (String)"<this>");
        SemanticsPropertiesKt.setTraversalGroup((SemanticsPropertyReceiver)$this$applySemantics, (boolean)true);
        SemanticsPropertiesKt.indexForKey((SemanticsPropertyReceiver)$this$applySemantics, this.indexForKeyMapping);
        LazyLayoutSemanticsModifierNode lazyLayoutSemanticsModifierNode = this;
        if (lazyLayoutSemanticsModifierNode.orientation == Orientation.Vertical) {
            ScrollAxisRange scrollAxisRange = this.scrollAxisRange;
            if (scrollAxisRange == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"scrollAxisRange");
                scrollAxisRange = null;
            }
            SemanticsPropertiesKt.setVerticalScrollAxisRange((SemanticsPropertyReceiver)$this$applySemantics, (ScrollAxisRange)scrollAxisRange);
        } else {
            ScrollAxisRange scrollAxisRange = this.scrollAxisRange;
            if (scrollAxisRange == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"scrollAxisRange");
                scrollAxisRange = null;
            }
            SemanticsPropertiesKt.setHorizontalScrollAxisRange((SemanticsPropertyReceiver)$this$applySemantics, (ScrollAxisRange)scrollAxisRange);
        }
        Function1<? super Integer, Boolean> function1 = this.scrollToIndexAction;
        if (function1 != null) {
            Function1<? super Integer, Boolean> it = function1;
            SemanticsPropertiesKt.scrollToIndex$default$73cde05a((SemanticsPropertyReceiver)$this$applySemantics, null, (Function1)lazyLayoutSemanticsModifierNode, (int)1);
        }
        SemanticsPropertiesKt.getScrollViewportLength$default$299c4719((SemanticsPropertyReceiver)$this$applySemantics, null, (Function0)((Function0)new Function0<Float>(this){
            final /* synthetic */ LazyLayoutSemanticsModifierNode this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                super(0);
            }

            public final Float invoke() {
                return Float.valueOf(LazyLayoutSemanticsModifierNode.access$getState$p(this.this$0).getViewport() - LazyLayoutSemanticsModifierNode.access$getState$p(this.this$0).getContentPadding());
            }
        }), (int)1);
        lazyLayoutSemanticsModifierNode = this;
        SemanticsPropertiesKt.setCollectionInfo((SemanticsPropertyReceiver)var1_1, (CollectionInfo)lazyLayoutSemanticsModifierNode.state.collectionInfo());
    }

    private final void updateCachedSemanticsValues() {
        this.scrollAxisRange = new ScrollAxisRange((Function0)new Function0<Float>(this){
            final /* synthetic */ LazyLayoutSemanticsModifierNode this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                super(0);
            }

            public final Float invoke() {
                return Float.valueOf(LazyLayoutSemanticsModifierNode.access$getState$p(this.this$0).getScrollOffset());
            }
        }, (Function0)new Function0<Float>(this){
            final /* synthetic */ LazyLayoutSemanticsModifierNode this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                super(0);
            }

            public final Float invoke() {
                return Float.valueOf(LazyLayoutSemanticsModifierNode.access$getState$p(this.this$0).getMaxScrollOffset());
            }
        }, this.reverseScrolling);
        this.scrollToIndexAction = this.userScrollEnabled ? (Function1)new Function1<Integer, Boolean>(this){
            final /* synthetic */ LazyLayoutSemanticsModifierNode this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final Boolean invoke(int index2) {
                void var1_1;
                LazyLayoutItemProvider itemProvider = (LazyLayoutItemProvider)LazyLayoutSemanticsModifierNode.access$getItemProviderLambda$p(this.this$0).invoke();
                if (!(index2 >= 0 && index2 < itemProvider.getItemCount())) {
                    void var2_3;
                    String index2 = "Can't scroll to index " + index2 + ", it is out of bounds [0, " + var2_3.getItemCount() + ')';
                    throw new IllegalArgumentException(index2.toString());
                }
                BuildersKt.launch$default((CoroutineScope)this.this$0.getCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, (int)var1_1, null){
                    int label;
                    final /* synthetic */ LazyLayoutSemanticsModifierNode this$0;
                    final /* synthetic */ int $index;
                    {
                        void var3_3;
                        void var2_2;
                        void var1_1;
                        this.this$0 = var1_1;
                        this.$index = var2_2;
                        super(2, (Continuation)var3_3);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                if (LazyLayoutSemanticsModifierNode.access$getState$p(this.this$0).scrollToItem(this.$index, (Continuation<? super Unit>)((Continuation)this)) != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)object);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        void var2_2;
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }
                }), (int)3, null);
                return Boolean.TRUE;
            }
        } : null;
    }

    public static final /* synthetic */ LazyLayoutSemanticState access$getState$p(LazyLayoutSemanticsModifierNode $this) {
        return $this.state;
    }

    public static final /* synthetic */ Function0 access$getItemProviderLambda$p(LazyLayoutSemanticsModifierNode $this) {
        return $this.itemProviderLambda;
    }
}

