/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.internal;

import java.util.List;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.reflect.KType;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.internal.ClassValueCache;
import kotlinx.serialization.internal.ClassValueParametrizedCache;
import kotlinx.serialization.internal.ConcurrentHashMapCache;
import kotlinx.serialization.internal.ConcurrentHashMapParametrizedCache;
import kotlinx.serialization.internal.ParametrizedSerializerCache;
import kotlinx.serialization.internal.SerializerCache;

public final class CachingKt {
    private static final boolean useClassValue;

    public static final <T> SerializerCache<T> createCache(Function1<? super KClass<?>, ? extends KSerializer<T>> factory) {
        Function1<? super KClass<?>, ? extends KSerializer<T>> function1;
        Intrinsics.checkNotNullParameter(factory, (String)"factory");
        if (useClassValue) {
            return new ClassValueCache(factory);
        }
        return new ConcurrentHashMapCache(function1);
    }

    public static final <T> ParametrizedSerializerCache<T> createParametrizedCache(Function2<? super KClass<Object>, ? super List<? extends KType>, ? extends KSerializer<T>> factory) {
        Function2<? super KClass<Object>, ? super List<? extends KType>, ? extends KSerializer<T>> function2;
        Intrinsics.checkNotNullParameter(factory, (String)"factory");
        if (useClassValue) {
            return new ClassValueParametrizedCache(factory);
        }
        return new ConcurrentHashMapParametrizedCache(function2);
    }

    static {
        boolean bl;
        try {
            Class.forName("java.lang.ClassValue");
            bl = true;
        }
        catch (Throwable throwable) {
            bl = false;
        }
        useClassValue = bl;
    }
}

