/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.zip.Inflater;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.BufferedSource;
import okio.FileHandle;
import okio.FileMetadata;
import okio.FileSystem;
import okio.InflaterSource;
import okio.Okio;
import okio.Path;
import okio.Sink;
import okio.Source;
import okio.internal.FixedLengthSource;
import okio.internal.ZipEntry;
import okio.internal.ZipFilesKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0001\u0018\u0000 62\u00020\u0001:\u00016B7\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001f\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u0019J\u001f\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u001f\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u001f\u0010\u0016J\u001f\u0010 \u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b \u0010\u001eJ\u001d\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020!2\u0006\u0010\u001b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\"\u0010#J'\u0010\"\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010!2\u0006\u0010\u001b\u001a\u00020\u00022\u0006\u0010$\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\"\u0010%J\u001f\u0010&\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010!2\u0006\u0010\u001b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b&\u0010#J\u0019\u0010(\u001a\u0004\u0018\u00010'2\u0006\u0010\u0017\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b(\u0010)J\u0017\u0010+\u001a\u00020*2\u0006\u0010\f\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b+\u0010,J'\u0010-\u001a\u00020*2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b-\u0010.J\u001f\u0010/\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b/\u0010\u0011J\u0017\u0010\u0012\u001a\u0002002\u0006\u0010\f\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0012\u00101R\u0016\u0010\t\u001a\u0004\u0018\u00010\b8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\t\u00102R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00060\u00058\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u00103R\u0014\u0010\u0004\u001a\u00020\u00018\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u00104R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u00105"}, d2={"Lokio/ZipFileSystem;", "Lokio/FileSystem;", "Lokio/Path;", "zipPath", "fileSystem", "", "Lokio/internal/ZipEntry;", "entries", "", "comment", "<init>", "(Lokio/Path;Lokio/FileSystem;Ljava/util/Map;Ljava/lang/String;)V", "file", "", "mustExist", "Lokio/Sink;", "appendingSink", "(Lokio/Path;Z)Lokio/Sink;", "source", "target", "", "atomicMove", "(Lokio/Path;Lokio/Path;)V", "path", "canonicalize", "(Lokio/Path;)Lokio/Path;", "canonicalizeInternal", "dir", "mustCreate", "createDirectory", "(Lokio/Path;Z)V", "createSymlink", "delete", "", "list", "(Lokio/Path;)Ljava/util/List;", "throwOnFailure", "(Lokio/Path;Z)Ljava/util/List;", "listOrNull", "Lokio/FileMetadata;", "metadataOrNull", "(Lokio/Path;)Lokio/FileMetadata;", "Lokio/FileHandle;", "openReadOnly", "(Lokio/Path;)Lokio/FileHandle;", "openReadWrite", "(Lokio/Path;ZZ)Lokio/FileHandle;", "sink", "Lokio/Source;", "(Lokio/Path;)Lokio/Source;", "Ljava/lang/String;", "Ljava/util/Map;", "Lokio/FileSystem;", "Lokio/Path;", "Companion"})
@SourceDebugExtension(value={"SMAP\nZipFileSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZipFileSystem.kt\nokio/ZipFileSystem\n+ 2 Okio.kt\nokio/Okio__OkioKt\n*L\n1#1,142:1\n52#2,4:143\n52#2,22:147\n60#2,10:169\n56#2,3:179\n71#2,3:182\n52#2,22:185\n*S KotlinDebug\n*F\n+ 1 ZipFileSystem.kt\nokio/ZipFileSystem\n*L\n55#1:143,4\n56#1:147,22\n55#1:169,10\n55#1:179,3\n55#1:182,3\n99#1:185,22\n*E\n"})
public final class ZipFileSystem
extends FileSystem {
    private static final Companion Companion = new Companion(null);
    private final Path zipPath;
    private final FileSystem fileSystem;
    private final Map<Path, ZipEntry> entries;
    private final String comment;
    private static final Path ROOT = Path.Companion.get$default(Path.Companion, "/", false, 1, null);

    /*
     * WARNING - void declaration
     */
    public ZipFileSystem(Path zipPath, FileSystem fileSystem, Map<Path, ZipEntry> entries, String comment) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)zipPath, (String)"zipPath");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        this.zipPath = var1_1;
        this.fileSystem = var2_2;
        this.entries = var3_3;
        this.comment = comment;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Path canonicalize(Path path) {
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path canonical = this.canonicalizeInternal(path);
        if (!this.entries.containsKey(canonical)) {
            void var1_1;
            throw new FileNotFoundException(String.valueOf(var1_1));
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private final Path canonicalizeInternal(Path path) {
        void var1_1;
        return ROOT.resolve((Path)var1_1, true);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final FileMetadata metadataOrNull(Path path) {
        void var1_1;
        Long l;
        void fullEntry;
        ZipEntry zipEntry;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path canonicalPath = this.canonicalizeInternal(path);
        ZipEntry zipEntry2 = this.entries.get(canonicalPath);
        if (zipEntry2 == null) {
            return null;
        }
        ZipEntry centralDirectoryEntry = zipEntry2;
        if (zipEntry2.getOffset() != -1L) {
            void var3_3;
            block29: {
                Object $this$use$iv;
                Closeable $this$use$iv2 = this.fileSystem.openReadOnly(this.zipPath);
                Throwable thrown$iv2 = null;
                try {
                    Throwable thrown$iv;
                    block28: {
                        Object object;
                        FileHandle fileHandle = (FileHandle)$this$use$iv2;
                        $this$use$iv = Okio.buffer(fileHandle.source(centralDirectoryEntry.getOffset()));
                        thrown$iv = null;
                        try {
                            object = (BufferedSource)$this$use$iv;
                            centralDirectoryEntry = ZipFilesKt.readLocalHeader((BufferedSource)object, centralDirectoryEntry);
                        }
                        catch (Throwable throwable) {
                            object = throwable;
                            thrown$iv = throwable;
                            centralDirectoryEntry = null;
                            try {
                                Object object2 = $this$use$iv;
                                if (object2 != null) {
                                    object2.close();
                                }
                                break block28;
                            }
                            catch (Throwable t$iv) {
                                ExceptionsKt.addSuppressed((Throwable)thrown$iv, (Throwable)t$iv);
                            }
                            break block28;
                        }
                        catch (Throwable t$iv) {
                            try {
                                Object object3 = $this$use$iv;
                                if (object3 == null) throw t$iv;
                                object3.close();
                                throw t$iv;
                            }
                            catch (Throwable throwable) {}
                            throw t$iv;
                        }
                        try {
                            Object object4 = $this$use$iv;
                            if (object4 != null) {
                                object4.close();
                            }
                        }
                        catch (Throwable throwable) {
                            object = throwable;
                            thrown$iv = throwable;
                        }
                    }
                    ZipEntry result$iv = centralDirectoryEntry;
                    Throwable throwable = thrown$iv;
                    if (throwable != null) {
                        throw throwable;
                    }
                    centralDirectoryEntry = (ZipEntry)((Object)result$iv);
                }
                catch (Throwable throwable) {
                    $this$use$iv = throwable;
                    thrown$iv2 = throwable;
                    centralDirectoryEntry = null;
                    try {
                        Closeable closeable = $this$use$iv2;
                        if (closeable != null) {
                            closeable.close();
                        }
                        break block29;
                    }
                    catch (Throwable t$iv) {
                        ExceptionsKt.addSuppressed((Throwable)thrown$iv2, (Throwable)t$iv);
                    }
                    break block29;
                }
                catch (Throwable t$iv) {
                    try {
                        void var2_2;
                        void v10 = var2_2;
                        if (v10 == null) throw t$iv;
                        v10.close();
                        throw t$iv;
                    }
                    catch (Throwable throwable) {}
                    throw t$iv;
                }
                try {
                    Closeable closeable = $this$use$iv2;
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (Throwable throwable) {
                    $this$use$iv = throwable;
                    thrown$iv2 = throwable;
                }
            }
            ZipEntry result$iv = centralDirectoryEntry;
            void v14 = var3_3;
            if (v14 != null) {
                throw v14;
            }
            zipEntry = (ZipEntry)((Object)result$iv);
        } else {
            zipEntry = fullEntry;
        }
        fullEntry = zipEntry;
        boolean bl = !fullEntry.isDirectory();
        boolean bl2 = fullEntry.isDirectory();
        if (fullEntry.isDirectory()) {
            l = null;
            return new FileMetadata(bl, bl2, null, l, fullEntry.getCreatedAtMillis$okio(), fullEntry.getLastModifiedAtMillis$okio(), var1_1.getLastAccessedAtMillis$okio(), null, 128, null);
        }
        l = fullEntry.getSize();
        return new FileMetadata(bl, bl2, null, l, fullEntry.getCreatedAtMillis$okio(), fullEntry.getLastModifiedAtMillis$okio(), var1_1.getLastAccessedAtMillis$okio(), null, 128, null);
    }

    @Override
    public final FileHandle openReadOnly(Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        throw new UnsupportedOperationException("not implemented yet!");
    }

    @Override
    public final FileHandle openReadWrite(Path file, boolean mustCreate, boolean mustExist) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        throw new IOException("zip entries are not writable");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final List<Path> list(Path dir) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        List<Path> list = this.list((Path)var1_1, true);
        Intrinsics.checkNotNull(list);
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final List<Path> listOrNull(Path dir) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        return this.list((Path)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Path> list(Path dir, boolean throwOnFailure) {
        ZipEntry zipEntry;
        void var3_3;
        Path canonicalDir = this.canonicalizeInternal(dir);
        ZipEntry zipEntry2 = this.entries.get(var3_3);
        if (zipEntry2 == null) {
            void var2_2;
            if (var2_2 != false) {
                throw new IOException("not a directory: " + zipEntry);
            }
            return null;
        }
        zipEntry = zipEntry2;
        return CollectionsKt.toList((Iterable)zipEntry2.getChildren());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final Source source(Path file) throws IOException {
        void var1_1;
        void var2_2;
        void var3_3;
        Closeable closeable;
        ZipEntry entry;
        block14: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Path canonicalPath = this.canonicalizeInternal(file);
            ZipEntry zipEntry = this.entries.get(canonicalPath);
            if (zipEntry == null) {
                throw new FileNotFoundException("no such file: " + file);
            }
            entry = zipEntry;
            Closeable $this$use$iv = this.fileSystem.openReadOnly(this.zipPath);
            Throwable thrown$iv = null;
            try {
                closeable = (FileHandle)$this$use$iv;
                closeable = Okio.buffer(closeable.source(entry.getOffset()));
            }
            catch (Throwable throwable) {
                Throwable throwable3 = throwable;
                thrown$iv = throwable;
                closeable = null;
                try {
                    Closeable closeable2 = $this$use$iv;
                    if (closeable2 != null) {
                        closeable2.close();
                    }
                    break block14;
                }
                catch (Throwable t$iv) {
                    ExceptionsKt.addSuppressed((Throwable)thrown$iv, (Throwable)t$iv);
                }
                break block14;
            }
            catch (Throwable throwable) {
                try {
                    Closeable closeable3 = $this$use$iv;
                    if (closeable3 == null) throw throwable;
                    closeable3.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {}
                throw throwable;
            }
            try {
                Closeable closeable4 = $this$use$iv;
                if (closeable4 != null) {
                    closeable4.close();
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                thrown$iv = throwable;
            }
        }
        Closeable result$iv = closeable;
        void v7 = var3_3;
        if (v7 != null) {
            throw v7;
        }
        BufferedSource source2 = (BufferedSource)result$iv;
        ZipFilesKt.skipLocalHeader(source2);
        if (entry.getCompressionMethod() == 0) {
            return new FixedLengthSource(source2, entry.getSize(), true);
        }
        InflaterSource inflaterSource = new InflaterSource(new FixedLengthSource(source2, entry.getCompressedSize(), true), new Inflater(true));
        return new FixedLengthSource((Source)var2_2, var1_1.getSize(), false);
    }

    @Override
    public final Sink sink(Path file, boolean mustCreate) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        throw new IOException("zip file systems are read-only");
    }

    @Override
    public final Sink appendingSink(Path file, boolean mustExist) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        throw new IOException("zip file systems are read-only");
    }

    @Override
    public final void createDirectory(Path dir, boolean mustCreate) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        throw new IOException("zip file systems are read-only");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void atomicMove(Path source2, Path target) {
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"target");
        throw new IOException("zip file systems are read-only");
    }

    @Override
    public final void delete(Path path, boolean mustExist) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        throw new IOException("zip file systems are read-only");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void createSymlink(Path source2, Path target) {
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"target");
        throw new IOException("zip file systems are read-only");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b"}, d2={"Lokio/ZipFileSystem$Companion;", "", "<init>", "()V", "Lokio/Path;", "ROOT", "Lokio/Path;", "getROOT", "()Lokio/Path;"})
    private static final class Companion {
        private Companion() {
        }

        public final Path getROOT() {
            return ROOT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

