/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.SegmentPool;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0015\b\u0001\u0018\u0000 \"2\u00020\u0001:\u0001\"B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B1\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0004\b\u0002\u0010\fJ\r\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u0003J\u000f\u0010\u000f\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0012\u0010\u0013J\r\u0010\u0014\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0014\u0010\u0010J\u0015\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0016\u0010\u0017J\r\u0010\u0018\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0018\u0010\u0010J\u001d\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0006\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001cR\u0016\u0010\b\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b\b\u0010\u001dR\u0018\u0010\u001e\u001a\u0004\u0018\u00010\u00008\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u0016\u0010\u000b\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b\u000b\u0010 R\u0016\u0010\u0007\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u001dR\u0018\u0010!\u001a\u0004\u0018\u00010\u00008\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b!\u0010\u001fR\u0016\u0010\n\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b\n\u0010 "}, d2={"Lokio/Segment;", "", "<init>", "()V", "", "data", "", "pos", "limit", "", "shared", "owner", "([BIIZZ)V", "", "compact", "pop", "()Lokio/Segment;", "segment", "push", "(Lokio/Segment;)Lokio/Segment;", "sharedCopy", "byteCount", "split", "(I)Lokio/Segment;", "unsharedCopy", "sink", "writeTo", "(Lokio/Segment;I)V", "[B", "I", "next", "Lokio/Segment;", "Z", "prev", "Companion"})
@SourceDebugExtension(value={"SMAP\nSegment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Segment.kt\nokio/Segment\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,187:1\n1#2:188\n*E\n"})
public final class Segment {
    public static final Companion Companion = new Companion(null);
    @JvmField
    public final byte[] data;
    @JvmField
    public int pos;
    @JvmField
    public int limit;
    @JvmField
    public boolean shared;
    @JvmField
    public boolean owner;
    @JvmField
    public Segment next;
    @JvmField
    public Segment prev;
    public static final int SIZE = 8192;
    public static final int SHARE_MINIMUM = 1024;

    public Segment() {
        this.data = new byte[8192];
        this.owner = true;
        this.shared = false;
    }

    /*
     * WARNING - void declaration
     */
    public Segment(byte[] data, int pos, int limit, boolean shared, boolean owner) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.data = var1_1;
        this.pos = var2_2;
        this.limit = var3_3;
        this.shared = shared;
        this.owner = owner;
    }

    public final Segment sharedCopy() {
        this.shared = true;
        return new Segment(this.data, this.pos, this.limit, true, false);
    }

    public final Segment unsharedCopy() {
        byte[] byArray = Arrays.copyOf(this.data, this.data.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
        return new Segment(byArray, this.pos, this.limit, false, true);
    }

    /*
     * WARNING - void declaration
     */
    public final Segment pop() {
        void var1_1;
        Segment result = this.next != this ? this.next : null;
        Intrinsics.checkNotNull((Object)this.prev);
        this.prev.next = this.next;
        Intrinsics.checkNotNull((Object)this.next);
        this.next.prev = this.prev;
        this.next = null;
        this.prev = null;
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final Segment push(Segment segment) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
        segment.prev = this;
        segment.next = this.next;
        Intrinsics.checkNotNull((Object)this.next);
        this.next.prev = segment;
        this.next = segment;
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final Segment split(int byteCount22) {
        void var2_3;
        void var1_1;
        Segment prefix;
        int byteCount22;
        if (!(byteCount22 > 0 && byteCount22 <= this.limit - this.pos)) {
            String byteCount22 = "byteCount out of range";
            throw new IllegalArgumentException(byteCount22.toString());
        }
        if (byteCount22 >= 1024) {
            prefix = this.sharedCopy();
        } else {
            prefix = SegmentPool.take();
            ArraysKt.copyInto$default((byte[])this.data, (byte[])prefix.data, (int)0, (int)this.pos, (int)(this.pos + byteCount22), (int)2, null);
        }
        prefix.limit = prefix.pos + byteCount22;
        this.pos += var1_1;
        Segment segment = this.prev;
        Intrinsics.checkNotNull((Object)segment);
        segment.push(prefix);
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public final void compact() {
        void var1_3;
        void var2_2;
        int n;
        if (!(this.prev != this)) {
            String string = "cannot compact";
            throw new IllegalStateException(string.toString());
        }
        Segment segment = this.prev;
        Intrinsics.checkNotNull((Object)segment);
        if (!segment.owner) {
            return;
        }
        int byteCount = this.limit - this.pos;
        Segment segment2 = this.prev;
        Intrinsics.checkNotNull((Object)segment2);
        int n2 = 8192 - segment2.limit;
        Segment segment3 = this.prev;
        Intrinsics.checkNotNull((Object)segment3);
        if (segment3.shared) {
            n = 0;
        } else {
            Segment segment4 = this.prev;
            Intrinsics.checkNotNull((Object)segment4);
            n = segment4.pos;
        }
        int availableByteCount = n2 + n;
        if (byteCount > var2_2) {
            return;
        }
        Segment segment5 = this;
        Segment segment6 = segment5.prev;
        Intrinsics.checkNotNull((Object)segment6);
        segment5.writeTo(segment6, (int)var1_3);
        this.pop();
        SegmentPool.recycle(this);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeTo(Segment sink2, int byteCount) {
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
        if (!((Segment)sink2).owner) {
            sink2 = "only owner can write";
            throw new IllegalStateException(sink2.toString());
        }
        if (((Segment)sink2).limit + byteCount > 8192) {
            if (((Segment)sink2).shared) {
                throw new IllegalArgumentException();
            }
            if (((Segment)sink2).limit + byteCount - ((Segment)sink2).pos > 8192) {
                throw new IllegalArgumentException();
            }
            ArraysKt.copyInto$default((byte[])((Segment)sink2).data, (byte[])((Segment)sink2).data, (int)0, (int)((Segment)sink2).pos, (int)((Segment)sink2).limit, (int)2, null);
            ((Segment)sink2).limit -= ((Segment)sink2).pos;
            ((Segment)sink2).pos = 0;
        }
        ArraysKt.copyInto((byte[])this.data, (byte[])((Segment)sink2).data, (int)((Segment)sink2).limit, (int)this.pos, (int)(this.pos + byteCount));
        var1_1.limit += byteCount;
        this.pos += var2_2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006"}, d2={"Lokio/Segment$Companion;", "", "<init>", "()V", "", "SHARE_MINIMUM", "I", "SIZE"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

