/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okio.FileHandle;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\f\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0014\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\bH\u0014\u00a2\u0006\u0004\b\u000b\u0010\nJ/\u0010\u0013\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0014\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\fH\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0018\u001a\u00020\fH\u0014\u00a2\u0006\u0004\b\u0018\u0010\u0019J/\u0010\u001a\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0014\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001c"}, d2={"Lokio/NioFileSystemFileHandle;", "Lokio/FileHandle;", "", "readWrite", "Ljava/nio/channels/FileChannel;", "fileChannel", "<init>", "(ZLjava/nio/channels/FileChannel;)V", "", "protectedClose", "()V", "protectedFlush", "", "fileOffset", "", "array", "", "arrayOffset", "byteCount", "protectedRead", "(J[BII)I", "size", "protectedResize", "(J)V", "protectedSize", "()J", "protectedWrite", "(J[BII)V", "Ljava/nio/channels/FileChannel;"})
public final class NioFileSystemFileHandle
extends FileHandle {
    private final FileChannel fileChannel;

    /*
     * WARNING - void declaration
     */
    public NioFileSystemFileHandle(boolean readWrite, FileChannel fileChannel) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)fileChannel, (String)"fileChannel");
        super((boolean)var1_1);
        this.fileChannel = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final synchronized void protectedResize(long size) {
        void var1_1;
        long currentSize = this.size();
        long delta = size - currentSize;
        if (delta > 0L) {
            void var3_2;
            this.protectedWrite((long)var3_2, new byte[(int)delta], 0, (int)delta);
            return;
        }
        this.fileChannel.truncate((long)var1_1);
    }

    @Override
    protected final synchronized long protectedSize() {
        return this.fileChannel.size();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final synchronized int protectedRead(long fileOffset, byte[] array, int arrayOffset, int byteCount) {
        void var2_7;
        void var3_4;
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        this.fileChannel.position(fileOffset);
        ByteBuffer byteBuffer = ByteBuffer.wrap(array, arrayOffset, byteCount);
        for (int bytesRead = 0; bytesRead < byteCount; bytesRead += var3_4) {
            int readResult = this.fileChannel.read(byteBuffer);
            if (readResult != -1) continue;
            if (bytesRead != 0) break;
            return -1;
        }
        return (int)var2_7;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final synchronized void protectedWrite(long fileOffset, byte[] array, int arrayOffset, int byteCount) {
        void var1_2;
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        this.fileChannel.position(fileOffset);
        ByteBuffer byteBuffer = ByteBuffer.wrap((byte[])var3_3, arrayOffset, byteCount);
        this.fileChannel.write((ByteBuffer)var1_2);
    }

    @Override
    protected final synchronized void protectedFlush() {
        this.fileChannel.force(true);
    }

    @Override
    protected final synchronized void protectedClose() {
        this.fileChannel.close();
    }
}

