/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.ByteString;
import okio.ForwardingSource;
import okio.Segment;
import okio.Source;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\u0018\u0000 \u001d2\u00020\u00012\u00020\u0002:\u0001\u001dB\u0019\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u0006\u0010\nB\u0019\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0006\u0010\rB!\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u0006\u0010\u0010J\u000f\u0010\u0013\u001a\u00020\u000eH\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001f\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0013\u001a\u00020\u000e8G\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0012R\u0016\u0010\f\u001a\u0004\u0018\u00010\u000b8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\u001aR\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001c"}, d2={"Lokio/HashingSource;", "Lokio/ForwardingSource;", "Lokio/Source;", "source", "Ljava/security/MessageDigest;", "digest", "<init>", "(Lokio/Source;Ljava/security/MessageDigest;)V", "", "algorithm", "(Lokio/Source;Ljava/lang/String;)V", "Ljavax/crypto/Mac;", "mac", "(Lokio/Source;Ljavax/crypto/Mac;)V", "Lokio/ByteString;", "key", "(Lokio/Source;Lokio/ByteString;Ljava/lang/String;)V", "-deprecated_hash", "()Lokio/ByteString;", "hash", "Lokio/Buffer;", "sink", "", "byteCount", "read", "(Lokio/Buffer;J)J", "Ljavax/crypto/Mac;", "messageDigest", "Ljava/security/MessageDigest;", "Companion"})
public final class HashingSource
extends ForwardingSource
implements Source {
    public static final Companion Companion = new Companion(null);
    private final MessageDigest messageDigest;
    private final Mac mac;

    /*
     * WARNING - void declaration
     */
    public HashingSource(Source source2, MessageDigest digest) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
        super((Source)var1_1);
        this.messageDigest = var2_2;
        this.mac = null;
    }

    /*
     * WARNING - void declaration
     */
    public HashingSource(Source source2, String algorithm) {
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        MessageDigest messageDigest = MessageDigest.getInstance((String)var2_2);
        Intrinsics.checkNotNullExpressionValue((Object)messageDigest, (String)"getInstance(...)");
        this((Source)var1_1, messageDigest);
    }

    /*
     * WARNING - void declaration
     */
    public HashingSource(Source source2, Mac mac) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)mac, (String)"mac");
        super((Source)var1_1);
        this.mac = var2_2;
        this.messageDigest = null;
    }

    /*
     * WARNING - void declaration
     */
    public HashingSource(Source source2, ByteString key, String algorithm) {
        void v3;
        HashingSource hashingSource;
        Object object;
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Mac mac = object;
        object = this;
        try {
            void var3_3;
            void var2_2;
            void $this$_init__u24lambda_u240;
            HashingSource hashingSource2 = object;
            void v1 = mac;
            object = Mac.getInstance(algorithm);
            mac = object;
            void var6_6 = v1;
            HashingSource hashingSource3 = hashingSource2;
            $this$_init__u24lambda_u240.init(new SecretKeySpec(var2_2.toByteArray(), (String)var3_3));
            hashingSource = hashingSource3;
            v3 = var6_6;
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException(e);
        }
        Intrinsics.checkNotNull((Object)object);
        hashingSource((Source)v3, (Mac)object);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long read(Buffer sink2, long byteCount) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
        long result = super.read(sink2, byteCount);
        if (result != -1L) {
            long offset;
            long start = sink2.size() - result;
            Segment segment = sink2.head;
            Intrinsics.checkNotNull((Object)segment);
            Segment s = segment;
            for (offset = sink2.size(); offset > start; offset -= (long)(s.limit - s.pos)) {
                Intrinsics.checkNotNull((Object)s.prev);
            }
            while (offset < sink2.size()) {
                int pos = (int)((long)s.pos + start - offset);
                if (this.messageDigest != null) {
                    this.messageDigest.update(s.data, pos, s.limit - pos);
                } else {
                    void var3_7;
                    Mac mac = this.mac;
                    Intrinsics.checkNotNull((Object)mac);
                    mac.update(s.data, pos, s.limit - var3_7);
                }
                start = offset += (long)(s.limit - s.pos);
                Intrinsics.checkNotNull((Object)s.next);
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="hash")
    public final ByteString hash() {
        void var1_1;
        byte[] byArray;
        if (this.messageDigest != null) {
            byArray = this.messageDigest.digest();
        } else {
            Mac mac = this.mac;
            Intrinsics.checkNotNull((Object)mac);
            byArray = mac.doFinal();
        }
        byte[] result = byArray;
        Intrinsics.checkNotNull((Object)result);
        return new ByteString((byte[])var1_1);
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="hash", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_hash")
    public final ByteString -deprecated_hash() {
        return this.hash();
    }

    @JvmStatic
    public static final HashingSource md5(Source source2) {
        Source source3;
        return Companion.md5(source3);
    }

    @JvmStatic
    public static final HashingSource sha1(Source source2) {
        Source source3;
        return Companion.sha1(source3);
    }

    @JvmStatic
    public static final HashingSource sha256(Source source2) {
        Source source3;
        return Companion.sha256(source3);
    }

    @JvmStatic
    public static final HashingSource sha512(Source source2) {
        Source source3;
        return Companion.sha512(source3);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final HashingSource hmacSha1(Source source2, ByteString key) {
        void var1_1;
        Source source3;
        return Companion.hmacSha1(source3, (ByteString)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final HashingSource hmacSha256(Source source2, ByteString key) {
        void var1_1;
        Source source3;
        return Companion.hmacSha256(source3, (ByteString)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final HashingSource hmacSha512(Source source2, ByteString key) {
        void var1_1;
        Source source3;
        return Companion.hmacSha512(source3, (ByteString)var1_1);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u000b\u0010\nJ\u001f\u0010\f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\f\u0010\nJ\u0017\u0010\r\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0010\u0010\u000eJ\u0017\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0011\u0010\u000e"}, d2={"Lokio/HashingSource$Companion;", "", "<init>", "()V", "Lokio/Source;", "source", "Lokio/ByteString;", "key", "Lokio/HashingSource;", "hmacSha1", "(Lokio/Source;Lokio/ByteString;)Lokio/HashingSource;", "hmacSha256", "hmacSha512", "md5", "(Lokio/Source;)Lokio/HashingSource;", "sha1", "sha256", "sha512"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final HashingSource md5(Source source2) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
            return new HashingSource((Source)var1_1, "MD5");
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final HashingSource sha1(Source source2) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
            return new HashingSource((Source)var1_1, "SHA-1");
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final HashingSource sha256(Source source2) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
            return new HashingSource((Source)var1_1, "SHA-256");
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final HashingSource sha512(Source source2) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
            return new HashingSource((Source)var1_1, "SHA-512");
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final HashingSource hmacSha1(Source source2, ByteString key) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return new HashingSource((Source)var1_1, (ByteString)var2_2, "HmacSHA1");
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final HashingSource hmacSha256(Source source2, ByteString key) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return new HashingSource((Source)var1_1, (ByteString)var2_2, "HmacSHA256");
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final HashingSource hmacSha512(Source source2, ByteString key) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return new HashingSource((Source)var1_1, (ByteString)var2_2, "HmacSHA512");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

