/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.-SegmentedByteString;
import okio.Buffer;
import okio.RealBufferedSink;
import okio.RealBufferedSource;
import okio.Segment;
import okio.SegmentPool;
import okio.Sink;
import okio.Source;
import okio.Timeout;
import okio._JvmPlatformKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b'\u0018\u00002\u00060\u0001j\u0002`\u0002:\u0002?@B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\r\u0010\r\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\fJ\u0015\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0010\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\nH$\u00a2\u0006\u0004\b\u0015\u0010\fJ\u000f\u0010\u0016\u001a\u00020\nH$\u00a2\u0006\u0004\b\u0016\u0010\fJ/\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001aH$\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010 \u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u000fH$\u00a2\u0006\u0004\b \u0010!J\u000f\u0010\"\u001a\u00020\u000fH$\u00a2\u0006\u0004\b\"\u0010#J/\u0010$\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001aH$\u00a2\u0006\u0004\b$\u0010%J-\u0010&\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001a\u00a2\u0006\u0004\b&\u0010\u001eJ%\u0010&\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020'2\u0006\u0010\u001c\u001a\u00020\u000f\u00a2\u0006\u0004\b&\u0010(J'\u0010)\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020'2\u0006\u0010\u001c\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b)\u0010(J\u001d\u0010*\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b*\u0010+J\u001d\u0010*\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b*\u0010,J\u0015\u0010-\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u000f\u00a2\u0006\u0004\b-\u0010!J\u0017\u0010\u000e\u001a\u00020\u00072\b\b\u0002\u0010\u0017\u001a\u00020\u000f\u00a2\u0006\u0004\b\u000e\u0010.J\r\u0010\u001f\u001a\u00020\u000f\u00a2\u0006\u0004\b\u001f\u0010#J\u0017\u0010\u0013\u001a\u00020\u00122\b\b\u0002\u0010\u0017\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0013\u0010/J-\u00100\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001a\u00a2\u0006\u0004\b0\u0010%J%\u00100\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020'2\u0006\u0010\u001c\u001a\u00020\u000f\u00a2\u0006\u0004\b0\u00101J'\u00102\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020'2\u0006\u0010\u001c\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b2\u00101R\u0016\u00103\u001a\u00020\u00038\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b3\u00104R\u001e\u00107\u001a\u000605j\u0002`68\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b7\u00108\u001a\u0004\b9\u0010:R\u0016\u0010;\u001a\u00020\u001a8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b;\u0010<R\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u00104\u001a\u0004\b=\u0010>"}, d2={"Lokio/FileHandle;", "Ljava/io/Closeable;", "Lokio/Closeable;", "", "readWrite", "<init>", "(Z)V", "Lokio/Sink;", "appendingSink", "()Lokio/Sink;", "", "close", "()V", "flush", "sink", "", "position", "(Lokio/Sink;)J", "Lokio/Source;", "source", "(Lokio/Source;)J", "protectedClose", "protectedFlush", "fileOffset", "", "array", "", "arrayOffset", "byteCount", "protectedRead", "(J[BII)I", "size", "protectedResize", "(J)V", "protectedSize", "()J", "protectedWrite", "(J[BII)V", "read", "Lokio/Buffer;", "(JLokio/Buffer;J)J", "readNoCloseCheck", "reposition", "(Lokio/Sink;J)V", "(Lokio/Source;J)V", "resize", "(J)Lokio/Sink;", "(J)Lokio/Source;", "write", "(JLokio/Buffer;J)V", "writeNoCloseCheck", "closed", "Z", "Ljava/util/concurrent/locks/ReentrantLock;", "Lokio/Lock;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "getLock", "()Ljava/util/concurrent/locks/ReentrantLock;", "openStreamCount", "I", "getReadWrite", "()Z", "FileHandleSink", "FileHandleSource"})
@SourceDebugExtension(value={"SMAP\nFileHandle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileHandle.kt\nokio/FileHandle\n+ 2 -JvmPlatform.kt\nokio/_JvmPlatformKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 RealBufferedSource.kt\nokio/RealBufferedSource\n+ 5 RealBufferedSink.kt\nokio/RealBufferedSink\n+ 6 Util.kt\nokio/-SegmentedByteString\n*L\n1#1,444:1\n33#2:445\n33#2:447\n33#2:448\n33#2:449\n33#2:450\n33#2:451\n33#2:452\n33#2:453\n33#2:457\n33#2:459\n1#3:446\n62#4:454\n62#4:455\n62#4:456\n51#5:458\n86#6:460\n86#6:461\n*S KotlinDebug\n*F\n+ 1 FileHandle.kt\nokio/FileHandle\n*L\n69#1:445\n81#1:447\n92#1:448\n105#1:449\n119#1:450\n129#1:451\n139#1:452\n151#1:453\n221#1:457\n287#1:459\n169#1:454\n195#1:455\n202#1:456\n248#1:458\n345#1:460\n374#1:461\n*E\n"})
public abstract class FileHandle
implements Closeable {
    private final boolean readWrite;
    private boolean closed;
    private int openStreamCount;
    private final ReentrantLock lock;

    /*
     * WARNING - void declaration
     */
    public FileHandle(boolean readWrite) {
        void var1_1;
        this.readWrite = var1_1;
        this.lock = _JvmPlatformKt.newLock();
    }

    public final boolean getReadWrite() {
        return this.readWrite;
    }

    public final ReentrantLock getLock() {
        return this.lock;
    }

    /*
     * WARNING - void declaration
     */
    public final int read(long fileOffset2, byte[] array, int arrayOffset, int byteCount) throws IOException {
        void var3_4;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        Lock lock = this.lock;
        lock = lock;
        lock.lock();
        try {
            if (!(!this.closed)) {
                String fileOffset2 = "closed";
                throw new IllegalStateException(fileOffset2.toString());
            }
        }
        finally {
            lock.unlock();
        }
        return this.protectedRead((long)var1_1, (byte[])var3_4, arrayOffset, byteCount);
    }

    /*
     * WARNING - void declaration
     */
    public final long read(long fileOffset2, Buffer sink2, long byteCount) throws IOException {
        void var3_4;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
        Lock lock = this.lock;
        lock = lock;
        lock.lock();
        try {
            if (!(!this.closed)) {
                String fileOffset2 = "closed";
                throw new IllegalStateException(fileOffset2.toString());
            }
        }
        finally {
            lock.unlock();
        }
        return this.readNoCloseCheck((long)var1_1, (Buffer)var3_4, byteCount);
    }

    public final long size() throws IOException {
        Lock lock = this.lock;
        lock = lock;
        lock.lock();
        try {
            if (!(!this.closed)) {
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
        }
        finally {
            lock.unlock();
        }
        return this.protectedSize();
    }

    /*
     * WARNING - void declaration
     */
    public final void resize(long size2) throws IOException {
        void var1_1;
        if (!this.readWrite) {
            String size2 = "file handle is read-only";
            throw new IllegalStateException(size2.toString());
        }
        Lock lock = this.lock;
        lock = lock;
        lock.lock();
        try {
            if (!(!this.closed)) {
                String size2 = "closed";
                throw new IllegalStateException(size2.toString());
            }
        }
        finally {
            lock.unlock();
        }
        this.protectedResize((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void write(long fileOffset2, byte[] array, int arrayOffset, int byteCount) {
        void var3_5;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        if (!this.readWrite) {
            String fileOffset2 = "file handle is read-only";
            throw new IllegalStateException(fileOffset2.toString());
        }
        Lock lock = this.lock;
        lock = lock;
        lock.lock();
        try {
            if (!(!this.closed)) {
                String fileOffset2 = "closed";
                throw new IllegalStateException(fileOffset2.toString());
            }
        }
        finally {
            lock.unlock();
        }
        this.protectedWrite((long)var1_1, (byte[])var3_5, arrayOffset, byteCount);
    }

    /*
     * WARNING - void declaration
     */
    public final void write(long fileOffset2, Buffer source2, long byteCount) throws IOException {
        void var3_5;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        if (!this.readWrite) {
            String fileOffset2 = "file handle is read-only";
            throw new IllegalStateException(fileOffset2.toString());
        }
        Lock lock = this.lock;
        lock = lock;
        lock.lock();
        try {
            if (!(!this.closed)) {
                String fileOffset2 = "closed";
                throw new IllegalStateException(fileOffset2.toString());
            }
        }
        finally {
            lock.unlock();
        }
        this.writeNoCloseCheck((long)var1_1, (Buffer)var3_5, byteCount);
    }

    public final void flush() throws IOException {
        if (!this.readWrite) {
            String string = "file handle is read-only";
            throw new IllegalStateException(string.toString());
        }
        Lock lock = this.lock;
        lock = lock;
        lock.lock();
        try {
            if (!(!this.closed)) {
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
        }
        finally {
            lock.unlock();
        }
        this.protectedFlush();
    }

    /*
     * WARNING - void declaration
     */
    public final Source source(long fileOffset2) throws IOException {
        void var1_1;
        Lock lock = this.lock;
        lock = lock;
        lock.lock();
        try {
            if (!(!this.closed)) {
                String fileOffset2 = "closed";
                throw new IllegalStateException(fileOffset2.toString());
            }
            int n = this.openStreamCount;
            this.openStreamCount = n + 1;
        }
        finally {
            lock.unlock();
        }
        return new FileHandleSource(this, (long)var1_1);
    }

    public static /* synthetic */ Source source$default(FileHandle fileHandle, long l, int n, Object object) throws IOException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: source");
        }
        if ((n & 1) != 0) {
            l = 0L;
        }
        return fileHandle.source(l);
    }

    /*
     * WARNING - void declaration
     */
    public final long position(Source source2) throws IOException {
        void var3_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        long bufferSize = 0L;
        if (source2 instanceof RealBufferedSource) {
            RealBufferedSource realBufferedSource = (RealBufferedSource)source2;
            bufferSize = realBufferedSource.bufferField.size();
            source2 = ((RealBufferedSource)source2).source;
        }
        if (!(source2 instanceof FileHandleSource && ((FileHandleSource)source2).getFileHandle() == this)) {
            source2 = "source was not created by this FileHandle";
            throw new IllegalArgumentException(source2.toString());
        }
        if (!(!((FileHandleSource)source2).getClosed())) {
            source2 = "closed";
            throw new IllegalStateException(source2.toString());
        }
        return ((FileHandleSource)var1_1).getPosition() - var3_2;
    }

    /*
     * WARNING - void declaration
     */
    public final void reposition(Source source2, long position) throws IOException {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        if (source2 instanceof RealBufferedSource) {
            Source fileHandleSource = ((RealBufferedSource)source2).source;
            if (!(fileHandleSource instanceof FileHandleSource && ((FileHandleSource)fileHandleSource).getFileHandle() == this)) {
                String string = "source was not created by this FileHandle";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(!((FileHandleSource)fileHandleSource).getClosed())) {
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
            RealBufferedSource realBufferedSource = (RealBufferedSource)source2;
            long bufferSize = realBufferedSource.bufferField.size();
            long toSkip = position - (((FileHandleSource)fileHandleSource).getPosition() - bufferSize);
            boolean bl = 0L <= toSkip ? toSkip < bufferSize : false;
            if (bl) {
                ((RealBufferedSource)source2).skip(toSkip);
                return;
            }
            source2 = (RealBufferedSource)source2;
            ((RealBufferedSource)source2).bufferField.clear();
            ((FileHandleSource)fileHandleSource).setPosition(position);
            return;
        }
        if (!(source2 instanceof FileHandleSource && ((FileHandleSource)source2).getFileHandle() == this)) {
            String string = "source was not created by this FileHandle";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(!((FileHandleSource)source2).getClosed())) {
            String string = "closed";
            throw new IllegalStateException(string.toString());
        }
        ((FileHandleSource)var1_1).setPosition((long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final Sink sink(long fileOffset2) throws IOException {
        void var1_1;
        if (!this.readWrite) {
            String fileOffset2 = "file handle is read-only";
            throw new IllegalStateException(fileOffset2.toString());
        }
        Lock lock = this.lock;
        lock = lock;
        lock.lock();
        try {
            if (!(!this.closed)) {
                String fileOffset2 = "closed";
                throw new IllegalStateException(fileOffset2.toString());
            }
            int n = this.openStreamCount;
            this.openStreamCount = n + 1;
        }
        finally {
            lock.unlock();
        }
        return new FileHandleSink(this, (long)var1_1);
    }

    public static /* synthetic */ Sink sink$default(FileHandle fileHandle, long l, int n, Object object) throws IOException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: sink");
        }
        if ((n & 1) != 0) {
            l = 0L;
        }
        return fileHandle.sink(l);
    }

    public final Sink appendingSink() throws IOException {
        FileHandle fileHandle = this;
        return fileHandle.sink(fileHandle.size());
    }

    /*
     * WARNING - void declaration
     */
    public final long position(Sink sink2) throws IOException {
        void var3_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
        long bufferSize = 0L;
        if (sink2 instanceof RealBufferedSink) {
            RealBufferedSink realBufferedSink = (RealBufferedSink)sink2;
            bufferSize = realBufferedSink.bufferField.size();
            sink2 = ((RealBufferedSink)sink2).sink;
        }
        if (!(sink2 instanceof FileHandleSink && ((FileHandleSink)sink2).getFileHandle() == this)) {
            sink2 = "sink was not created by this FileHandle";
            throw new IllegalArgumentException(sink2.toString());
        }
        if (!(!((FileHandleSink)sink2).getClosed())) {
            sink2 = "closed";
            throw new IllegalStateException(sink2.toString());
        }
        return ((FileHandleSink)var1_1).getPosition() + var3_2;
    }

    /*
     * WARNING - void declaration
     */
    public final void reposition(Sink sink2, long position) throws IOException {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
        if (sink2 instanceof RealBufferedSink) {
            Sink fileHandleSink = ((RealBufferedSink)sink2).sink;
            if (!(fileHandleSink instanceof FileHandleSink && ((FileHandleSink)fileHandleSink).getFileHandle() == this)) {
                sink2 = "sink was not created by this FileHandle";
                throw new IllegalArgumentException(sink2.toString());
            }
            if (!(!((FileHandleSink)fileHandleSink).getClosed())) {
                sink2 = "closed";
                throw new IllegalStateException(sink2.toString());
            }
            ((RealBufferedSink)sink2).emit();
            ((FileHandleSink)fileHandleSink).setPosition(position);
            return;
        }
        if (!(sink2 instanceof FileHandleSink && ((FileHandleSink)sink2).getFileHandle() == this)) {
            sink2 = "sink was not created by this FileHandle";
            throw new IllegalArgumentException(sink2.toString());
        }
        if (!(!((FileHandleSink)sink2).getClosed())) {
            sink2 = "closed";
            throw new IllegalStateException(sink2.toString());
        }
        ((FileHandleSink)var1_1).setPosition((long)var2_2);
    }

    @Override
    public final void close() throws IOException {
        Lock lock = this.lock;
        lock = lock;
        lock.lock();
        try {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.openStreamCount != 0) {
                return;
            }
        }
        finally {
            lock.unlock();
        }
        this.protectedClose();
    }

    protected abstract int protectedRead(long var1, byte[] var3, int var4, int var5) throws IOException;

    protected abstract void protectedWrite(long var1, byte[] var3, int var4, int var5) throws IOException;

    protected abstract void protectedFlush() throws IOException;

    protected abstract void protectedResize(long var1) throws IOException;

    protected abstract long protectedSize() throws IOException;

    protected abstract void protectedClose() throws IOException;

    /*
     * WARNING - void declaration
     */
    private final long readNoCloseCheck(long fileOffset, Buffer sink2, long byteCount) {
        void var1_1;
        long currentOffset;
        int readByteCount;
        if (!(byteCount >= 0L)) {
            String string = "byteCount < 0: " + byteCount;
            throw new IllegalArgumentException(string.toString());
        }
        long targetOffset = fileOffset + byteCount;
        for (currentOffset = fileOffset; currentOffset < targetOffset; currentOffset += (long)readByteCount) {
            void a$iv;
            Segment tail = sink2.writableSegment$okio(1);
            long l = targetOffset - currentOffset;
            int b$iv = 8192 - tail.limit;
            readByteCount = this.protectedRead(currentOffset, tail.data, tail.limit, (int)Math.min((long)a$iv, (long)b$iv));
            if (readByteCount == -1) {
                if (tail.pos == tail.limit) {
                    sink2.head = tail.pop();
                    SegmentPool.recycle(tail);
                }
                if (fileOffset != currentOffset) break;
                return -1L;
            }
            tail.limit += readByteCount;
            Buffer buffer = sink2;
            buffer.setSize$okio(buffer.size() + (long)readByteCount);
        }
        return currentOffset - var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private final void writeNoCloseCheck(long fileOffset, Buffer source2, long byteCount) {
        int toCopy;
        -SegmentedByteString.checkOffsetAndCount(source2.size(), 0L, byteCount);
        long targetOffset = fileOffset + byteCount;
        for (long currentOffset = fileOffset; currentOffset < targetOffset; currentOffset += (long)toCopy) {
            void var1_2;
            void var2_7;
            void a$iv;
            Segment head;
            Intrinsics.checkNotNull((Object)source2.head);
            long l = targetOffset - currentOffset;
            int b$iv = head.limit - head.pos;
            toCopy = (int)Math.min((long)a$iv, (long)b$iv);
            this.protectedWrite(currentOffset, head.data, head.pos, toCopy);
            head.pos += toCopy;
            Buffer buffer = source2;
            buffer.setSize$okio(buffer.size() - (long)var2_7);
            if (head.pos != head.limit) continue;
            source2.head = head.pop();
            SegmentPool.recycle((Segment)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$writeNoCloseCheck(FileHandle $this, long fileOffset, Buffer source2, long byteCount) {
        void var3_2;
        void var1_1;
        $this.writeNoCloseCheck((long)var1_1, (Buffer)var3_2, byteCount);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setOpenStreamCount$p(FileHandle $this, int n) {
        void var1_1;
        $this.openStreamCount = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ long access$readNoCloseCheck(FileHandle $this, long fileOffset, Buffer sink2, long byteCount) {
        void var3_2;
        void var1_1;
        return $this.readNoCloseCheck((long)var1_1, (Buffer)var3_2, byteCount);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u000e\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\nJ\u000f\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013R\"\u0010\u0015\u001a\u00020\u00148\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR\"\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\u001e\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\""}, d2={"Lokio/FileHandle$FileHandleSink;", "Lokio/Sink;", "Lokio/FileHandle;", "fileHandle", "", "position", "<init>", "(Lokio/FileHandle;J)V", "", "close", "()V", "flush", "Lokio/Timeout;", "timeout", "()Lokio/Timeout;", "Lokio/Buffer;", "source", "byteCount", "write", "(Lokio/Buffer;J)V", "", "closed", "Z", "getClosed", "()Z", "setClosed", "(Z)V", "Lokio/FileHandle;", "getFileHandle", "()Lokio/FileHandle;", "J", "getPosition", "()J", "setPosition", "(J)V"})
    @SourceDebugExtension(value={"SMAP\nFileHandle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileHandle.kt\nokio/FileHandle$FileHandleSink\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 -JvmPlatform.kt\nokio/_JvmPlatformKt\n*L\n1#1,444:1\n1#2:445\n33#3:446\n*S KotlinDebug\n*F\n+ 1 FileHandle.kt\nokio/FileHandle$FileHandleSink\n*L\n410#1:446\n*E\n"})
    private static final class FileHandleSink
    implements Sink {
        private final FileHandle fileHandle;
        private long position;
        private boolean closed;

        /*
         * WARNING - void declaration
         */
        public FileHandleSink(FileHandle fileHandle, long position) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)fileHandle, (String)"fileHandle");
            this.fileHandle = var1_1;
            this.position = var2_2;
        }

        public final FileHandle getFileHandle() {
            return this.fileHandle;
        }

        public final long getPosition() {
            return this.position;
        }

        /*
         * WARNING - void declaration
         */
        public final void setPosition(long l) {
            void var1_1;
            this.position = var1_1;
        }

        public final boolean getClosed() {
            return this.closed;
        }

        /*
         * WARNING - void declaration
         */
        public final void setClosed(boolean bl) {
            void var1_1;
            this.closed = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void write(Buffer source2, long byteCount) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
            if (!(!this.closed)) {
                source2 = "closed";
                throw new IllegalStateException(source2.toString());
            }
            FileHandle.access$writeNoCloseCheck(this.fileHandle, this.position, (Buffer)var1_1, byteCount);
            this.position += var2_2;
        }

        @Override
        public final void flush() {
            if (!(!this.closed)) {
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
            this.fileHandle.protectedFlush();
        }

        @Override
        public final Timeout timeout() {
            return Timeout.NONE;
        }

        @Override
        public final void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            Lock lock = this.fileHandle.getLock();
            lock = lock;
            lock.lock();
            try {
                FileHandle fileHandle = this.fileHandle;
                int n = fileHandle.openStreamCount;
                FileHandle.access$setOpenStreamCount$p(fileHandle, n + -1);
                if (this.fileHandle.openStreamCount != 0 || !this.fileHandle.closed) {
                    return;
                }
            }
            finally {
                lock.unlock();
            }
            this.fileHandle.protectedClose();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000e\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\u000e\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012R\"\u0010\u0014\u001a\u00020\u00138\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\"\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!"}, d2={"Lokio/FileHandle$FileHandleSource;", "Lokio/Source;", "Lokio/FileHandle;", "fileHandle", "", "position", "<init>", "(Lokio/FileHandle;J)V", "", "close", "()V", "Lokio/Buffer;", "sink", "byteCount", "read", "(Lokio/Buffer;J)J", "Lokio/Timeout;", "timeout", "()Lokio/Timeout;", "", "closed", "Z", "getClosed", "()Z", "setClosed", "(Z)V", "Lokio/FileHandle;", "getFileHandle", "()Lokio/FileHandle;", "J", "getPosition", "()J", "setPosition", "(J)V"})
    @SourceDebugExtension(value={"SMAP\nFileHandle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileHandle.kt\nokio/FileHandle$FileHandleSource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 -JvmPlatform.kt\nokio/_JvmPlatformKt\n*L\n1#1,444:1\n1#2:445\n33#3:446\n*S KotlinDebug\n*F\n+ 1 FileHandle.kt\nokio/FileHandle$FileHandleSource\n*L\n436#1:446\n*E\n"})
    private static final class FileHandleSource
    implements Source {
        private final FileHandle fileHandle;
        private long position;
        private boolean closed;

        /*
         * WARNING - void declaration
         */
        public FileHandleSource(FileHandle fileHandle, long position) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)fileHandle, (String)"fileHandle");
            this.fileHandle = var1_1;
            this.position = var2_2;
        }

        public final FileHandle getFileHandle() {
            return this.fileHandle;
        }

        public final long getPosition() {
            return this.position;
        }

        /*
         * WARNING - void declaration
         */
        public final void setPosition(long l) {
            void var1_1;
            this.position = var1_1;
        }

        public final boolean getClosed() {
            return this.closed;
        }

        /*
         * WARNING - void declaration
         */
        public final void setClosed(boolean bl) {
            void var1_1;
            this.closed = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final long read(Buffer sink2, long byteCount) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
            if (!(!this.closed)) {
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
            long result = FileHandle.access$readNoCloseCheck(this.fileHandle, this.position, (Buffer)var1_1, (long)var2_2);
            if (result != -1L) {
                this.position += result;
            }
            return result;
        }

        @Override
        public final Timeout timeout() {
            return Timeout.NONE;
        }

        @Override
        public final void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            Lock lock = this.fileHandle.getLock();
            lock = lock;
            lock.lock();
            try {
                FileHandle fileHandle = this.fileHandle;
                int n = fileHandle.openStreamCount;
                FileHandle.access$setOpenStreamCount$p(fileHandle, n + -1);
                if (this.fileHandle.openStreamCount != 0 || !this.fileHandle.closed) {
                    return;
                }
            }
            finally {
                lock.unlock();
            }
            this.fileHandle.protectedClose();
        }
    }
}

