/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.twoslices.impl;

import com.sshtools.twoslices.AbstractToaster;
import com.sshtools.twoslices.Capability;
import com.sshtools.twoslices.Slice;
import com.sshtools.twoslices.ToastActionListener;
import com.sshtools.twoslices.ToastBuilder;
import com.sshtools.twoslices.ToastType;
import com.sshtools.twoslices.ToasterException;
import com.sshtools.twoslices.ToasterService;
import com.sshtools.twoslices.ToasterSettings;
import java.awt.AWTException;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.imageio.ImageIO;

public class AWTToaster
extends AbstractToaster
implements ActionListener {
    private Thread timer;
    private TrayIcon trayIcon;

    /*
     * WARNING - void declaration
     */
    public AWTToaster(ToasterSettings configuration) {
        super((ToasterSettings)var1_1);
        void var1_1;
        this.capabilities.addAll(Arrays.asList(Capability.IMAGES));
        try {
            Class.forName("java.awt.SystemTray");
            if (!SystemTray.isSupported()) {
                throw new UnsupportedOperationException();
            }
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Slice toast(ToastBuilder builder) {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(() -> {
                void var1_1;
                this.toast((ToastBuilder)var1_1);
            });
            return Slice.defaultSlice$484829f2();
        }
        SystemTray tray = SystemTray.getSystemTray();
        String icon = builder.icon();
        ToastType type = builder.type();
        String title = builder.title();
        String content = builder.content();
        ToastActionListener closed = builder.closed();
        try {
            void var2_4;
            if (this.trayIcon == null) {
                if (this.configuration.getParent() != null) {
                    this.trayIcon = (TrayIcon)this.configuration.getParent();
                } else if (icon == null || icon.length() == 0) {
                    this.trayIcon = new TrayIcon(AWTToaster.getPlatformImage(this.getTypeImage(type)), title);
                    tray.add(this.trayIcon);
                } else {
                    this.trayIcon = new TrayIcon(AWTToaster.getPlatformImage(ImageIO.read(new File(icon))), title);
                    tray.add(this.trayIcon);
                }
                this.trayIcon.addActionListener(this);
            } else {
                if (icon == null || icon.length() == 0) {
                    this.trayIcon.setImage(AWTToaster.getPlatformImage(this.getTypeImage(type)));
                } else {
                    void var3_5;
                    this.trayIcon.setImage(AWTToaster.getPlatformImage(ImageIO.read(new File((String)var3_5))));
                }
                this.trayIcon.setToolTip(title);
                if (this.timer != null) {
                    this.timer.interrupt();
                }
            }
            this.trayIcon.displayMessage(title, content, TrayIcon.MessageType.valueOf(type.name()));
            this.timer = new Thread(this, "AWTNotifierWait", closed, (SystemTray)var2_4){
                final /* synthetic */ ToastActionListener val$closed;
                final /* synthetic */ SystemTray val$tray;
                final /* synthetic */ AWTToaster this$0;
                {
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$closed = toastActionListener;
                    this.val$tray = systemTray;
                    super((String)var2_2);
                }

                @Override
                public void run() {
                    try {
                        Thread.sleep(this.this$0.configuration.getTimeout() * 1000);
                        if (this.val$closed != null) {
                        }
                        this.this$0.timer = null;
                        if (this.this$0.configuration.getSystemTrayIconMode() != ToasterSettings.SystemTrayIconMode.SHOW_DEFAULT_ALWAYS) {
                            if (this.this$0.configuration.getParent() == null) {
                                this.val$tray.remove(this.this$0.trayIcon);
                            }
                            this.this$0.trayIcon = null;
                        }
                        return;
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
            };
            this.timer.start();
        }
        catch (IOException ioe) {
            throw new ToasterException(String.format("Failed to show toast for %s: %s", new Object[]{type, title}), ioe);
        }
        catch (AWTException e) {
            void var1_3;
            throw new ToasterException(String.format("Failed to show toast for %s: %s", new Object[]{type, title}), (Throwable)var1_3);
        }
        return Slice.defaultSlice$484829f2();
    }

    /*
     * WARNING - void declaration
     */
    private static Image getPlatformImage(Image image) throws IOException {
        Image image2;
        void var2_2;
        void var1_1;
        String osname = System.getProperty("os.name");
        int sz = 48;
        if (osname.toLowerCase().indexOf("windows") != -1) {
            sz = 16;
        } else if (var1_1.toLowerCase().indexOf("linux") != -1) {
            sz = 24;
        }
        void v0 = var2_2;
        return image2.getScaledInstance((int)v0, (int)v0, 4);
    }

    /*
     * WARNING - void declaration
     */
    private Image getTypeImage(ToastType type) throws IOException {
        void var1_1;
        if (this.configuration.getSystemTrayIconMode() == ToasterSettings.SystemTrayIconMode.HIDDEN) {
            type = System.getProperty("os.name");
            if (((String)type).toLowerCase().indexOf("windows") != -1) {
                return ImageIO.read(this.getClass().getResource("/images/blank-48.gif"));
            }
            return ImageIO.read(this.getClass().getResource("/images/blank-48.png"));
        }
        if ((this.configuration.getSystemTrayIconMode() == ToasterSettings.SystemTrayIconMode.SHOW_DEFAULT_WHEN_ACTIVE || this.configuration.getSystemTrayIconMode() == ToasterSettings.SystemTrayIconMode.SHOW_DEFAULT_ALWAYS) && this.configuration.getDefaultImage() != null) {
            return ImageIO.read(this.configuration.getDefaultImage());
        }
        return ImageIO.read(this.getClass().getResource("/images/dialog-" + ((Enum)(((Enum)type).equals((Object)ToastType.NONE) ? ToastType.INFO : var1_1)).name().toLowerCase() + "-48.png"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public static class Service
    implements ToasterService {
        /*
         * WARNING - void declaration
         */
        @Override
        public final AWTToaster create$24925e4(ToasterSettings settings) {
            void var1_1;
            return new AWTToaster((ToasterSettings)var1_1);
        }
    }
}

