/*
 * Decompiled with CFR 0.152.
 */
package kotlin.time;

import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.SinceKotlin;
import kotlin.WasExperimental;
import kotlin.comparisons.ComparisonsKt;
import kotlin.internal.InlineOnly;
import kotlin.jvm.JvmInline;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.LongRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlin.time.DurationJvmKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlin.time.DurationUnitKt;
import kotlin.time.ExperimentalTime;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@JvmInline
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b+\b\u0087@\u0018\u0000 \u008c\u00012\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0002\u008c\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\t\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\u000b\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\n\u0010\bJ\u0010\u0010\r\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b\f\u0010\u0005J\u0018\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0018\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0010J\u0018\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0019H\u0086\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0018\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001eH\u0086\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001fJ\u0018\u0010!\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0019H\u0086\u0002\u00a2\u0006\u0004\b \u0010\u001cJ\u0018\u0010!\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001eH\u0086\u0002\u00a2\u0006\u0004\b \u0010\u001fJ\u0018\u0010!\u001a\u00020\u001e2\u0006\u0010\u000e\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b\"\u0010#J\u0017\u0010(\u001a\u00020\u00002\u0006\u0010%\u001a\u00020$H\u0000\u00a2\u0006\u0004\b&\u0010'J\r\u0010*\u001a\u00020\u0006\u00a2\u0006\u0004\b)\u0010\bJ\r\u0010,\u001a\u00020\u0006\u00a2\u0006\u0004\b+\u0010\bJ\r\u0010.\u001a\u00020\u0006\u00a2\u0006\u0004\b-\u0010\bJ\r\u00100\u001a\u00020\u0006\u00a2\u0006\u0004\b/\u0010\bJ\u0018\u00103\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u0000H\u0096\u0002\u00a2\u0006\u0004\b1\u00102J\u009d\u0001\u0010@\u001a\u00028\u0000\"\u0004\b\u0000\u001042u\u0010=\u001aq\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b6\u0012\b\b7\u0012\u0004\b\b(8\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b6\u0012\b\b7\u0012\u0004\b\b(9\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b6\u0012\b\b7\u0012\u0004\b\b(:\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b6\u0012\b\b7\u0012\u0004\b\b(;\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b6\u0012\b\b7\u0012\u0004\b\b(<\u0012\u0004\u0012\u00028\u000005H\u0086\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0001 \u0001\u00a2\u0006\u0004\b>\u0010?J\u0088\u0001\u0010@\u001a\u00028\u0000\"\u0004\b\u0000\u001042`\u0010=\u001a\\\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b6\u0012\b\b7\u0012\u0004\b\b(9\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b6\u0012\b\b7\u0012\u0004\b\b(:\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b6\u0012\b\b7\u0012\u0004\b\b(;\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b6\u0012\b\b7\u0012\u0004\b\b(<\u0012\u0004\u0012\u00028\u00000AH\u0086\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0001 \u0001\u00a2\u0006\u0004\b>\u0010BJs\u0010@\u001a\u00028\u0000\"\u0004\b\u0000\u001042K\u0010=\u001aG\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b6\u0012\b\b7\u0012\u0004\b\b(:\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b6\u0012\b\b7\u0012\u0004\b\b(;\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b6\u0012\b\b7\u0012\u0004\b\b(<\u0012\u0004\u0012\u00028\u00000CH\u0086\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0001 \u0001\u00a2\u0006\u0004\b>\u0010DJ^\u0010@\u001a\u00028\u0000\"\u0004\b\u0000\u0010426\u0010=\u001a2\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b6\u0012\b\b7\u0012\u0004\b\b(;\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b6\u0012\b\b7\u0012\u0004\b\b(<\u0012\u0004\u0012\u00028\u00000EH\u0086\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0001 \u0001\u00a2\u0006\u0004\b>\u0010FJ\u0015\u0010I\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020$\u00a2\u0006\u0004\bG\u0010HJ\u0015\u0010K\u001a\u00020\u00022\u0006\u0010%\u001a\u00020$\u00a2\u0006\u0004\bJ\u0010'J\u0015\u0010N\u001a\u00020\u00192\u0006\u0010%\u001a\u00020$\u00a2\u0006\u0004\bL\u0010MJ\u000f\u0010R\u001a\u00020OH\u0016\u00a2\u0006\u0004\bP\u0010QJ?\u0010\\\u001a\u00020Y*\u00060Sj\u0002`T2\u0006\u0010U\u001a\u00020\u00192\u0006\u0010V\u001a\u00020\u00192\u0006\u0010W\u001a\u00020\u00192\u0006\u0010%\u001a\u00020O2\u0006\u0010X\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\bZ\u0010[J\u001f\u0010R\u001a\u00020O2\u0006\u0010%\u001a\u00020$2\b\b\u0002\u0010]\u001a\u00020\u0019\u00a2\u0006\u0004\bP\u0010^J\r\u0010`\u001a\u00020O\u00a2\u0006\u0004\b_\u0010QJ\u001a\u0010b\u001a\u00020\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010aH\u00d6\u0003\u00a2\u0006\u0004\bb\u0010cJ\u0010\u0010d\u001a\u00020\u0019H\u00d6\u0001\u00a2\u0006\u0004\bd\u0010eR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010fR\u0014\u0010h\u001a\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bg\u0010\u0005R\u0015\u0010k\u001a\u00020\u00198\u00c2\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bi\u0010jR\u0014\u0010n\u001a\u00020$8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bl\u0010mR\u0011\u0010p\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\bo\u0010\u0005R\u001a\u0010t\u001a\u00020\u00198@X\u0081\u0004\u00a2\u0006\f\u0012\u0004\br\u0010s\u001a\u0004\bq\u0010jR\u001a\u0010w\u001a\u00020\u00198@X\u0081\u0004\u00a2\u0006\f\u0012\u0004\bv\u0010s\u001a\u0004\bu\u0010jR\u001a\u0010z\u001a\u00020\u00198@X\u0081\u0004\u00a2\u0006\f\u0012\u0004\by\u0010s\u001a\u0004\bx\u0010jR\u001a\u0010}\u001a\u00020\u00198@X\u0081\u0004\u00a2\u0006\f\u0012\u0004\b|\u0010s\u001a\u0004\b{\u0010jR\u0011\u0010\u007f\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b~\u0010\u0005R\u0013\u0010\u0081\u0001\u001a\u00020\u00028F\u00a2\u0006\u0007\u001a\u0005\b\u0080\u0001\u0010\u0005R\u0013\u0010\u0083\u0001\u001a\u00020\u00028F\u00a2\u0006\u0007\u001a\u0005\b\u0082\u0001\u0010\u0005R\u0013\u0010\u0085\u0001\u001a\u00020\u00028F\u00a2\u0006\u0007\u001a\u0005\b\u0084\u0001\u0010\u0005R\u0013\u0010\u0087\u0001\u001a\u00020\u00028F\u00a2\u0006\u0007\u001a\u0005\b\u0086\u0001\u0010\u0005R\u0013\u0010\u0089\u0001\u001a\u00020\u00028F\u00a2\u0006\u0007\u001a\u0005\b\u0088\u0001\u0010\u0005R\u0013\u0010\u008b\u0001\u001a\u00020\u00028F\u00a2\u0006\u0007\u001a\u0005\b\u008a\u0001\u0010\u0005\u0088\u0001\u0003\u0092\u0001\u00020\u0002\u0082\u0002\u0007\n\u0005\b\u009920\u0001"}, d2={"Lkotlin/time/Duration;", "", "", "rawValue", "constructor-impl", "(J)J", "", "isInNanos-impl", "(J)Z", "isInNanos", "isInMillis-impl", "isInMillis", "unaryMinus-UwyO8pc", "unaryMinus", "other", "plus-LRDsOJo", "(JJ)J", "plus", "thisMillis", "otherNanos", "addValuesMixedRanges-UwyO8pc", "(JJJ)J", "addValuesMixedRanges", "minus-LRDsOJo", "minus", "", "scale", "times-UwyO8pc", "(JI)J", "times", "", "(JD)J", "div-UwyO8pc", "div", "div-LRDsOJo", "(JJ)D", "Lkotlin/time/DurationUnit;", "unit", "truncateTo-UwyO8pc$kotlin_stdlib", "(JLkotlin/time/DurationUnit;)J", "truncateTo", "isNegative-impl", "isNegative", "isPositive-impl", "isPositive", "isInfinite-impl", "isInfinite", "isFinite-impl", "isFinite", "compareTo-LRDsOJo", "(JJ)I", "compareTo", "T", "Lkotlin/Function5;", "Lkotlin/ParameterName;", "name", "days", "hours", "minutes", "seconds", "nanoseconds", "action", "toComponents-impl", "(JLkotlin/jvm/functions/Function5;)Ljava/lang/Object;", "toComponents", "Lkotlin/Function4;", "(JLkotlin/jvm/functions/Function4;)Ljava/lang/Object;", "Lkotlin/Function3;", "(JLkotlin/jvm/functions/Function3;)Ljava/lang/Object;", "Lkotlin/Function2;", "(JLkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "toDouble-impl", "(JLkotlin/time/DurationUnit;)D", "toDouble", "toLong-impl", "toLong", "toInt-impl", "(JLkotlin/time/DurationUnit;)I", "toInt", "", "toString-impl", "(J)Ljava/lang/String;", "toString", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "whole", "fractional", "fractionalSize", "isoZeroes", "", "appendFractional-impl", "(JLjava/lang/StringBuilder;IIILjava/lang/String;Z)V", "appendFractional", "decimals", "(JLkotlin/time/DurationUnit;I)Ljava/lang/String;", "toIsoString-impl", "toIsoString", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "J", "getValue-impl", "value", "getUnitDiscriminator-impl", "(J)I", "unitDiscriminator", "getStorageUnit-impl", "(J)Lkotlin/time/DurationUnit;", "storageUnit", "getAbsoluteValue-UwyO8pc", "absoluteValue", "getHoursComponent-impl", "getHoursComponent$annotations", "()V", "hoursComponent", "getMinutesComponent-impl", "getMinutesComponent$annotations", "minutesComponent", "getSecondsComponent-impl", "getSecondsComponent$annotations", "secondsComponent", "getNanosecondsComponent-impl", "getNanosecondsComponent$annotations", "nanosecondsComponent", "getInWholeDays-impl", "inWholeDays", "getInWholeHours-impl", "inWholeHours", "getInWholeMinutes-impl", "inWholeMinutes", "getInWholeSeconds-impl", "inWholeSeconds", "getInWholeMilliseconds-impl", "inWholeMilliseconds", "getInWholeMicroseconds-impl", "inWholeMicroseconds", "getInWholeNanoseconds-impl", "inWholeNanoseconds", "Companion"})
@SinceKotlin(version="1.6")
@WasExperimental(markerClass={ExperimentalTime.class})
@SourceDebugExtension(value={"SMAP\nDuration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Duration.kt\nkotlin/time/Duration\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1059:1\n38#1:1060\n38#1:1061\n38#1:1062\n38#1:1063\n38#1:1064\n501#1:1065\n518#1:1073\n170#2,6:1066\n1#3:1072\n*S KotlinDebug\n*F\n+ 1 Duration.kt\nkotlin/time/Duration\n*L\n39#1:1060\n40#1:1061\n275#1:1062\n295#1:1063\n479#1:1064\n728#1:1065\n819#1:1073\n770#1:1066,6\n*E\n"})
public final class Duration
implements Comparable<Duration> {
    public static final Companion Companion = new Companion(null);
    private final long rawValue;
    private static final long ZERO = Duration.constructor-impl(0L);
    private static final long INFINITE = DurationKt.access$durationOfMillis(0x3FFFFFFFFFFFFFFFL);
    private static final long NEG_INFINITE = DurationKt.access$durationOfMillis(-4611686018427387903L);

    private static final long getValue-impl(long arg0) {
        return arg0 >> 1;
    }

    private static final int getUnitDiscriminator-impl(long arg0) {
        return (int)arg0 & 1;
    }

    private static final boolean isInNanos-impl(long arg0) {
        return ((int)arg0 & 1) == 0;
    }

    private static final boolean isInMillis-impl(long arg0) {
        return ((int)arg0 & 1) == 1;
    }

    private static final DurationUnit getStorageUnit-impl(long arg0) {
        if (Duration.isInNanos-impl(arg0)) {
            return DurationUnit.NANOSECONDS;
        }
        return DurationUnit.MILLISECONDS;
    }

    public static final long unaryMinus-UwyO8pc(long arg0) {
        long l;
        return DurationKt.access$durationOf(-Duration.getValue-impl(arg0), (int)l & 1);
    }

    /*
     * WARNING - void declaration
     */
    public static final long plus-LRDsOJo(long arg0, long other) {
        long l;
        void var2_1;
        if (Duration.isInfinite-impl(arg0)) {
            if (Duration.isFinite-impl(other) || (arg0 ^ other) >= 0L) {
                return arg0;
            }
            throw new IllegalArgumentException("Summing infinite durations of different signs yields an undefined result.");
        }
        if (Duration.isInfinite-impl(other)) {
            return other;
        }
        if (((int)arg0 & 1) == ((int)other & 1)) {
            long result = Duration.getValue-impl(arg0) + Duration.getValue-impl(other);
            if (Duration.isInNanos-impl(arg0)) {
                return DurationKt.access$durationOfNanosNormalized(result);
            }
            return DurationKt.access$durationOfMillisNormalized(result);
        }
        if (Duration.isInMillis-impl(arg0)) {
            long l2 = arg0;
            return Duration.addValuesMixedRanges-UwyO8pc(l2, Duration.getValue-impl(l2), Duration.getValue-impl(other));
        }
        return Duration.addValuesMixedRanges-UwyO8pc(arg0, Duration.getValue-impl((long)var2_1), Duration.getValue-impl(l));
    }

    /*
     * WARNING - void declaration
     */
    private static final long addValuesMixedRanges-UwyO8pc(long arg0, long thisMillis, long otherNanos) {
        void var2_2;
        long otherMillis = DurationKt.access$nanosToMillis(otherNanos);
        void resultMillis = var2_2 + otherMillis;
        boolean bl = -4611686018426L <= resultMillis ? resultMillis < 4611686018427L : false;
        if (bl) {
            long otherNanoRemainder = otherNanos - DurationKt.access$millisToNanos(otherMillis);
            return DurationKt.access$durationOfNanos(DurationKt.access$millisToNanos((long)resultMillis) + otherNanoRemainder);
        }
        return DurationKt.access$durationOfMillis(RangesKt.coerceIn((long)resultMillis, -4611686018427387903L, 0x3FFFFFFFFFFFFFFFL));
    }

    /*
     * WARNING - void declaration
     */
    public static final long minus-LRDsOJo(long arg0, long other) {
        void var2_1;
        return Duration.plus-LRDsOJo(arg0, Duration.unaryMinus-UwyO8pc((long)var2_1));
    }

    /*
     * WARNING - void declaration
     */
    public static final long times-UwyO8pc(long arg0, int scale) {
        void var2_1;
        void var3_2;
        long l;
        if (Duration.isInfinite-impl(arg0)) {
            if (scale == 0) {
                throw new IllegalArgumentException("Multiplying infinite duration by zero yields an undefined result.");
            }
            if (scale > 0) {
                return arg0;
            }
            return Duration.unaryMinus-UwyO8pc(arg0);
        }
        if (scale == 0) {
            return ZERO;
        }
        long value = Duration.getValue-impl(arg0);
        long result = value * (long)scale;
        if (Duration.isInNanos-impl(l)) {
            boolean bl = -2147483647L <= value ? value < 0x80000000L : false;
            if (bl) {
                return DurationKt.access$durationOfNanos(result);
            }
            if (result / (long)scale == value) {
                return DurationKt.access$durationOfNanosNormalized(result);
            }
            long millis = DurationKt.access$nanosToMillis(value);
            long remNanos = value - DurationKt.access$millisToNanos(millis);
            long resultMillis = millis * (long)scale;
            long totalMillis = resultMillis + DurationKt.access$nanosToMillis(remNanos * (long)scale);
            if (resultMillis / (long)scale == millis && (totalMillis ^ resultMillis) >= 0L) {
                return DurationKt.access$durationOfMillis(RangesKt.coerceIn(totalMillis, new LongRange(-4611686018427387903L, 0x3FFFFFFFFFFFFFFFL)));
            }
            if (MathKt.getSign(value) * MathKt.getSign(scale) > 0) {
                return INFINITE;
            }
            return NEG_INFINITE;
        }
        if (result / (long)scale == value) {
            return DurationKt.access$durationOfMillis(RangesKt.coerceIn(result, new LongRange(-4611686018427387903L, 0x3FFFFFFFFFFFFFFFL)));
        }
        if (MathKt.getSign((long)var3_2) * MathKt.getSign((int)var2_1) > 0) {
            return INFINITE;
        }
        return NEG_INFINITE;
    }

    /*
     * WARNING - void declaration
     */
    public static final long times-UwyO8pc(long arg0, double scale) {
        void var2_1;
        long l;
        int intScale = MathKt.roundToInt(scale);
        if ((double)intScale == scale) {
            return Duration.times-UwyO8pc(arg0, intScale);
        }
        DurationUnit unit = Duration.getStorageUnit-impl(arg0);
        double d = Duration.toDouble-impl(l, unit) * var2_1;
        return DurationKt.toDuration(d, unit);
    }

    /*
     * WARNING - void declaration
     */
    public static final long div-UwyO8pc(long arg0, int scale) {
        void var3_2;
        if (scale == 0) {
            if (Duration.isPositive-impl(arg0)) {
                return INFINITE;
            }
            if (Duration.isNegative-impl(arg0)) {
                return NEG_INFINITE;
            }
            throw new IllegalArgumentException("Dividing zero duration by zero yields an undefined result.");
        }
        if (Duration.isInNanos-impl(arg0)) {
            return DurationKt.access$durationOfNanos(Duration.getValue-impl(arg0) / (long)scale);
        }
        if (Duration.isInfinite-impl(arg0)) {
            return Duration.times-UwyO8pc(arg0, MathKt.getSign(scale));
        }
        long result = Duration.getValue-impl(arg0) / (long)scale;
        boolean bl = -4611686018426L <= result ? result < 4611686018427L : false;
        if (bl) {
            void var2_1;
            long l;
            long rem = DurationKt.access$millisToNanos(Duration.getValue-impl(l) - result * (long)scale) / (long)var2_1;
            return DurationKt.access$durationOfNanos(DurationKt.access$millisToNanos(result) + rem);
        }
        return DurationKt.access$durationOfMillis((long)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    public static final long div-UwyO8pc(long arg0, double scale) {
        void var2_1;
        long l;
        int intScale = MathKt.roundToInt(scale);
        if ((double)intScale == scale && intScale != 0) {
            return Duration.div-UwyO8pc(arg0, intScale);
        }
        DurationUnit unit = Duration.getStorageUnit-impl(arg0);
        double d = Duration.toDouble-impl(l, unit) / var2_1;
        return DurationKt.toDuration(d, unit);
    }

    /*
     * WARNING - void declaration
     */
    public static final double div-LRDsOJo(long arg0, long other) {
        void var2_1;
        long l;
        DurationUnit coarserUnit = (DurationUnit)((Object)ComparisonsKt.maxOf((Comparable)((Object)Duration.getStorageUnit-impl(arg0)), (Comparable)((Object)Duration.getStorageUnit-impl(other))));
        return Duration.toDouble-impl(l, coarserUnit) / Duration.toDouble-impl((long)var2_1, coarserUnit);
    }

    /*
     * WARNING - void declaration
     */
    public static final long truncateTo-UwyO8pc$kotlin_stdlib(long arg0, DurationUnit unit) {
        void var3_2;
        long l;
        void var2_1;
        Intrinsics.checkNotNullParameter((Object)unit, "unit");
        DurationUnit storageUnit = Duration.getStorageUnit-impl(arg0);
        if (unit.compareTo((Enum)storageUnit) <= 0 || Duration.isInfinite-impl(arg0)) {
            return arg0;
        }
        long scale = DurationUnitKt.convertDurationUnit(1L, (DurationUnit)var2_1, storageUnit);
        long l2 = Duration.getValue-impl(arg0) - Duration.getValue-impl(l) % scale;
        return DurationKt.toDuration(l2, (DurationUnit)var3_2);
    }

    public static final boolean isNegative-impl(long arg0) {
        return arg0 < 0L;
    }

    public static final boolean isPositive-impl(long arg0) {
        return arg0 > 0L;
    }

    public static final boolean isInfinite-impl(long arg0) {
        long l;
        return arg0 == INFINITE || l == NEG_INFINITE;
    }

    public static final boolean isFinite-impl(long arg0) {
        return !Duration.isInfinite-impl(arg0);
    }

    public static final long getAbsoluteValue-UwyO8pc(long arg0) {
        long l;
        if (Duration.isNegative-impl(arg0)) {
            return Duration.unaryMinus-UwyO8pc(arg0);
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    public static int compareTo-LRDsOJo(long arg0, long other) {
        void var2_2;
        long l;
        long compareBits = arg0 ^ other;
        if (compareBits < 0L || ((int)compareBits & 1) == 0) {
            return Intrinsics.compare(arg0, other);
        }
        int r = ((int)arg0 & 1) - ((int)other & 1);
        if (Duration.isNegative-impl(l)) {
            return -r;
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final int compareTo-LRDsOJo(long other) {
        void var1_1;
        return Duration.compareTo-LRDsOJo(this.rawValue, (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static final <T> T toComponents-impl(long arg0, Function5<? super Long, ? super Integer, ? super Integer, ? super Integer, ? super Integer, ? extends T> action) {
        long l;
        void var2_1;
        Intrinsics.checkNotNullParameter(action, "action");
        return (T)var2_1.invoke(Duration.getInWholeDays-impl(arg0), Duration.getHoursComponent-impl(arg0), Duration.getMinutesComponent-impl(arg0), Duration.getSecondsComponent-impl(arg0), Duration.getNanosecondsComponent-impl(l));
    }

    /*
     * WARNING - void declaration
     */
    public static final <T> T toComponents-impl(long arg0, Function4<? super Long, ? super Integer, ? super Integer, ? super Integer, ? extends T> action) {
        long l;
        void var2_1;
        Intrinsics.checkNotNullParameter(action, "action");
        return (T)var2_1.invoke(Duration.getInWholeHours-impl(arg0), Duration.getMinutesComponent-impl(arg0), Duration.getSecondsComponent-impl(arg0), Duration.getNanosecondsComponent-impl(l));
    }

    /*
     * WARNING - void declaration
     */
    public static final <T> T toComponents-impl(long arg0, Function3<? super Long, ? super Integer, ? super Integer, ? extends T> action) {
        long l;
        void var2_1;
        Intrinsics.checkNotNullParameter(action, "action");
        return (T)var2_1.invoke(Duration.getInWholeMinutes-impl(arg0), Duration.getSecondsComponent-impl(arg0), Duration.getNanosecondsComponent-impl(l));
    }

    /*
     * WARNING - void declaration
     */
    public static final <T> T toComponents-impl(long arg0, Function2<? super Long, ? super Integer, ? extends T> action) {
        long l;
        void var2_1;
        Intrinsics.checkNotNullParameter(action, "action");
        return (T)var2_1.invoke(Duration.getInWholeSeconds-impl(arg0), Duration.getNanosecondsComponent-impl(l));
    }

    public static final int getHoursComponent-impl(long arg0) {
        long l;
        if (Duration.isInfinite-impl(arg0)) {
            return 0;
        }
        return (int)(Duration.getInWholeHours-impl(l) % 24L);
    }

    @PublishedApi
    public static /* synthetic */ void getHoursComponent$annotations() {
    }

    public static final int getMinutesComponent-impl(long arg0) {
        long l;
        if (Duration.isInfinite-impl(arg0)) {
            return 0;
        }
        return (int)(Duration.getInWholeMinutes-impl(l) % 60L);
    }

    @PublishedApi
    public static /* synthetic */ void getMinutesComponent$annotations() {
    }

    public static final int getSecondsComponent-impl(long arg0) {
        long l;
        if (Duration.isInfinite-impl(arg0)) {
            return 0;
        }
        return (int)(Duration.getInWholeSeconds-impl(l) % 60L);
    }

    @PublishedApi
    public static /* synthetic */ void getSecondsComponent$annotations() {
    }

    public static final int getNanosecondsComponent-impl(long arg0) {
        long l;
        if (Duration.isInfinite-impl(arg0)) {
            return 0;
        }
        if (Duration.isInMillis-impl(arg0)) {
            return (int)DurationKt.access$millisToNanos(Duration.getValue-impl(arg0) % 1000L);
        }
        return (int)(Duration.getValue-impl(l) % 1000000000L);
    }

    @PublishedApi
    public static /* synthetic */ void getNanosecondsComponent$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    public static final double toDouble-impl(long arg0, DurationUnit unit) {
        void var2_1;
        long l;
        Intrinsics.checkNotNullParameter((Object)unit, "unit");
        if (arg0 == INFINITE) {
            return Double.POSITIVE_INFINITY;
        }
        if (arg0 == NEG_INFINITE) {
            return Double.NEGATIVE_INFINITY;
        }
        return DurationUnitKt.convertDurationUnit((double)Duration.getValue-impl(arg0), Duration.getStorageUnit-impl(l), (DurationUnit)var2_1);
    }

    /*
     * WARNING - void declaration
     */
    public static final long toLong-impl(long arg0, DurationUnit unit) {
        void var2_1;
        long l;
        Intrinsics.checkNotNullParameter((Object)unit, "unit");
        if (arg0 == INFINITE) {
            return Long.MAX_VALUE;
        }
        if (arg0 == NEG_INFINITE) {
            return Long.MIN_VALUE;
        }
        return DurationUnitKt.convertDurationUnit(Duration.getValue-impl(arg0), Duration.getStorageUnit-impl(l), (DurationUnit)var2_1);
    }

    /*
     * WARNING - void declaration
     */
    public static final int toInt-impl(long arg0, DurationUnit unit) {
        void var2_1;
        long l;
        Intrinsics.checkNotNullParameter((Object)unit, "unit");
        return (int)RangesKt.coerceIn(Duration.toLong-impl(l, (DurationUnit)var2_1), Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public static final long getInWholeDays-impl(long arg0) {
        return Duration.toLong-impl(arg0, DurationUnit.DAYS);
    }

    public static final long getInWholeHours-impl(long arg0) {
        return Duration.toLong-impl(arg0, DurationUnit.HOURS);
    }

    public static final long getInWholeMinutes-impl(long arg0) {
        return Duration.toLong-impl(arg0, DurationUnit.MINUTES);
    }

    public static final long getInWholeSeconds-impl(long arg0) {
        return Duration.toLong-impl(arg0, DurationUnit.SECONDS);
    }

    public static final long getInWholeMilliseconds-impl(long arg0) {
        long l;
        if (Duration.isInMillis-impl(arg0) && Duration.isFinite-impl(arg0)) {
            return Duration.getValue-impl(arg0);
        }
        return Duration.toLong-impl(l, DurationUnit.MILLISECONDS);
    }

    public static final long getInWholeMicroseconds-impl(long arg0) {
        return Duration.toLong-impl(arg0, DurationUnit.MICROSECONDS);
    }

    /*
     * WARNING - void declaration
     */
    public static final long getInWholeNanoseconds-impl(long arg0) {
        void var2_1;
        long l;
        long value = Duration.getValue-impl(arg0);
        if (Duration.isInNanos-impl(l)) {
            return value;
        }
        if (value > 9223372036854L) {
            return Long.MAX_VALUE;
        }
        if (value < -9223372036854L) {
            return Long.MIN_VALUE;
        }
        return DurationKt.access$millisToNanos((long)var2_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String toString-impl(long arg0) {
        void var2_1;
        void nanoseconds;
        void seconds;
        void minutes;
        void hours;
        StringBuilder stringBuilder;
        if (arg0 == 0L) {
            return "0s";
        }
        if (arg0 == INFINITE) {
            return "Infinity";
        }
        if (arg0 == NEG_INFINITE) {
            return "-Infinity";
        }
        boolean isNegative = Duration.isNegative-impl(arg0);
        StringBuilder $this$toString_impl_u24lambda_u241 = stringBuilder = new StringBuilder();
        if (isNegative) {
            $this$toString_impl_u24lambda_u241.append('-');
        }
        long arg0$iv22 = Duration.getAbsoluteValue-UwyO8pc(arg0);
        int arg0$iv22 = Duration.getNanosecondsComponent-impl(arg0$iv22);
        int n = Duration.getSecondsComponent-impl(arg0$iv22);
        int n2 = Duration.getMinutesComponent-impl(arg0$iv22);
        int n3 = Duration.getHoursComponent-impl(arg0$iv22);
        long days = Duration.getInWholeDays-impl(arg0$iv22);
        boolean hasDays = days != 0L;
        boolean hasHours = hours != false;
        boolean hasMinutes = minutes != false;
        boolean hasSeconds = seconds != false || nanoseconds != false;
        int components = 0;
        if (hasDays) {
            $this$toString_impl_u24lambda_u241.append(days).append('d');
            ++components;
        }
        if (hasHours || hasDays && (hasMinutes || hasSeconds)) {
            if (components++ > 0) {
                $this$toString_impl_u24lambda_u241.append(' ');
            }
            $this$toString_impl_u24lambda_u241.append((int)hours).append('h');
        }
        if (hasMinutes || hasSeconds && (hasHours || hasDays)) {
            if (components++ > 0) {
                $this$toString_impl_u24lambda_u241.append(' ');
            }
            $this$toString_impl_u24lambda_u241.append((int)minutes).append('m');
        }
        if (hasSeconds) {
            if (components++ > 0) {
                $this$toString_impl_u24lambda_u241.append(' ');
            }
            if (seconds != false || hasDays || hasHours || hasMinutes) {
                Duration.appendFractional-impl(arg0, $this$toString_impl_u24lambda_u241, (int)seconds, (int)nanoseconds, 9, "s", false);
            } else if (nanoseconds >= 1000000) {
                Duration.appendFractional-impl(arg0, $this$toString_impl_u24lambda_u241, (int)(nanoseconds / 1000000), (int)(nanoseconds % 1000000), 6, "ms", false);
            } else if (nanoseconds >= 1000) {
                long l;
                Duration.appendFractional-impl(l, $this$toString_impl_u24lambda_u241, (int)(nanoseconds / 1000), (int)(nanoseconds % 1000), 3, "us", false);
            } else {
                $this$toString_impl_u24lambda_u241.append((int)nanoseconds).append("ns");
            }
        }
        if (var2_1 != false && components > 1) {
            $this$toString_impl_u24lambda_u241.insert(1, '(').append(')');
        }
        return stringBuilder.toString();
    }

    public final String toString() {
        return Duration.toString-impl(this.rawValue);
    }

    /*
     * WARNING - void declaration
     */
    private static final void appendFractional-impl(long arg0, StringBuilder $this$appendFractional, int whole, int fractional, int fractionalSize, String unit, boolean isoZeroes) {
        void var2_2;
        int n;
        $this$appendFractional.append(n);
        if (fractional != 0) {
            int n2;
            String fracString;
            block5: {
                $this$appendFractional.append('.');
                fracString = StringsKt.padStart(String.valueOf(fractional), fractionalSize, '0');
                CharSequence $this$indexOfLast$iv = fracString;
                n = $this$indexOfLast$iv.length() + -1;
                if (n >= 0) {
                    do {
                        int index$iv;
                        char c;
                        if (!((c = $this$indexOfLast$iv.charAt(index$iv = n--)) != '0')) continue;
                        n2 = index$iv;
                        break block5;
                    } while (n >= 0);
                }
                n2 = -1;
            }
            int nonZeroDigits = n2 + 1;
            if (!isoZeroes && nonZeroDigits < 3) {
                Intrinsics.checkNotNullExpressionValue($this$appendFractional.append(fracString, 0, nonZeroDigits), "append(...)");
            } else {
                void var1_9;
                void var0_1;
                Intrinsics.checkNotNullExpressionValue($this$appendFractional.append((CharSequence)var0_1, 0, (int)((var1_9 + 2) / 3 * 3)), "append(...)");
            }
        }
        var2_2.append(unit);
    }

    /*
     * WARNING - void declaration
     */
    public static final String toString-impl(long arg0, DurationUnit unit, int decimals) {
        void var2_1;
        void var3_2;
        long l;
        Intrinsics.checkNotNullParameter((Object)unit, "unit");
        if (!(decimals >= 0)) {
            String string = "decimals must be not negative, but was " + decimals;
            throw new IllegalArgumentException(string.toString());
        }
        double number = Duration.toDouble-impl(l, unit);
        if (Double.isInfinite(number)) {
            return String.valueOf(number);
        }
        return DurationJvmKt.formatToExactDecimals(number, RangesKt.coerceAtMost((int)var3_2, 12)) + DurationUnitKt.shortName((DurationUnit)var2_1);
    }

    public static /* synthetic */ String toString-impl$default(long l, DurationUnit durationUnit, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return Duration.toString-impl(l, durationUnit, n);
    }

    /*
     * WARNING - void declaration
     */
    public static final String toIsoString-impl(long arg0) {
        void minutes;
        boolean hasMinutes;
        void nanoseconds;
        void seconds;
        long l;
        StringBuilder stringBuilder;
        StringBuilder $this$toIsoString_impl_u24lambda_u245 = stringBuilder = new StringBuilder();
        if (Duration.isNegative-impl(arg0)) {
            $this$toIsoString_impl_u24lambda_u245.append('-');
        }
        $this$toIsoString_impl_u24lambda_u245.append("PT");
        long arg0$iv22 = Duration.getAbsoluteValue-UwyO8pc(arg0);
        int arg0$iv22 = Duration.getNanosecondsComponent-impl(arg0$iv22);
        int n = Duration.getSecondsComponent-impl(arg0$iv22);
        int n2 = Duration.getMinutesComponent-impl(arg0$iv22);
        long hours = l = Duration.getInWholeHours-impl(arg0$iv22);
        if (Duration.isInfinite-impl(arg0)) {
            hours = 9999999999999L;
        }
        boolean hasHours = hours != 0L;
        boolean hasSeconds = seconds != false || nanoseconds != false;
        boolean bl = hasMinutes = minutes != false || hasSeconds && hasHours;
        if (hasHours) {
            $this$toIsoString_impl_u24lambda_u245.append(hours).append('H');
        }
        if (hasMinutes) {
            $this$toIsoString_impl_u24lambda_u245.append((int)minutes).append('M');
        }
        if (hasSeconds || !hasHours && !hasMinutes) {
            void var3_2;
            long l2;
            Duration.appendFractional-impl(l2, (StringBuilder)var3_2, (int)seconds, (int)nanoseconds, 9, "S", true);
        }
        return stringBuilder.toString();
    }

    public static int hashCode-impl(long arg0) {
        return Long.hashCode(arg0);
    }

    public final int hashCode() {
        return Duration.hashCode-impl(this.rawValue);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean equals-impl(long arg0, Object other) {
        long l;
        void var2_1;
        if (!(other instanceof Duration)) {
            return false;
        }
        long l2 = ((Duration)var2_1).unbox-impl();
        return l == l2;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var1_1;
        return Duration.equals-impl(this.rawValue, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Duration(long rawValue) {
        void var1_1;
        this.rawValue = var1_1;
    }

    public static long constructor-impl(long rawValue) {
        long l;
        if (DurationJvmKt.getDurationAssertionsEnabled()) {
            if (Duration.isInNanos-impl(rawValue)) {
                long l2 = Duration.getValue-impl(rawValue);
                if (!(-4611686018426999999L <= l2 ? l2 < 4611686018427000000L : false)) {
                    throw new AssertionError((Object)(Duration.getValue-impl(rawValue) + " ns is out of nanoseconds range"));
                }
            } else {
                long l3 = Duration.getValue-impl(rawValue);
                if (!(-4611686018427387903L <= l3 ? l3 < 0x4000000000000000L : false)) {
                    throw new AssertionError((Object)(Duration.getValue-impl(rawValue) + " ms is out of milliseconds range"));
                }
                l3 = Duration.getValue-impl(rawValue);
                boolean bl = -4611686018426L <= l3 ? l3 < 4611686018427L : false;
                if (bl) {
                    throw new AssertionError((Object)(Duration.getValue-impl(rawValue) + " ms is denormalized"));
                }
            }
        }
        return l;
    }

    public static final /* synthetic */ Duration box-impl(long v) {
        long l;
        return new Duration(l);
    }

    public final /* synthetic */ long unbox-impl() {
        return this.rawValue;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean equals-impl0(long p1, long p2) {
        void var2_1;
        return p1 == var2_1;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0016\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0010\u0010\u000eJ\u0017\u0010\u0014\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0016\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0015\u0010\u0013R\u001a\u0010\u0017\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\u001b\u001a\u00020\f8\u0006\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0018\u001a\u0004\b\u001c\u0010\u001aR\u001a\u0010\u001d\u001a\u00020\f8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u001d\u0010\u0018\u001a\u0004\b\u001e\u0010\u001aR\u001f\u0010$\u001a\u00020\f*\u00020\u001f8\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\"\u0010#\u001a\u0004\b \u0010!R\u001f\u0010$\u001a\u00020\f*\u00020%8\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\"\u0010'\u001a\u0004\b \u0010&R\u001f\u0010$\u001a\u00020\f*\u00020\u00048\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\"\u0010)\u001a\u0004\b \u0010(R\u001f\u0010,\u001a\u00020\f*\u00020\u001f8\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b+\u0010#\u001a\u0004\b*\u0010!R\u001f\u0010,\u001a\u00020\f*\u00020%8\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b+\u0010'\u001a\u0004\b*\u0010&R\u001f\u0010,\u001a\u00020\f*\u00020\u00048\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b+\u0010)\u001a\u0004\b*\u0010(R\u001f\u0010/\u001a\u00020\f*\u00020\u001f8\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b.\u0010#\u001a\u0004\b-\u0010!R\u001f\u0010/\u001a\u00020\f*\u00020%8\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b.\u0010'\u001a\u0004\b-\u0010&R\u001f\u0010/\u001a\u00020\f*\u00020\u00048\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b.\u0010)\u001a\u0004\b-\u0010(R\u001f\u00102\u001a\u00020\f*\u00020\u001f8\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b1\u0010#\u001a\u0004\b0\u0010!R\u001f\u00102\u001a\u00020\f*\u00020%8\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b1\u0010'\u001a\u0004\b0\u0010&R\u001f\u00102\u001a\u00020\f*\u00020\u00048\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b1\u0010)\u001a\u0004\b0\u0010(R\u001f\u00105\u001a\u00020\f*\u00020\u001f8\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b4\u0010#\u001a\u0004\b3\u0010!R\u001f\u00105\u001a\u00020\f*\u00020%8\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b4\u0010'\u001a\u0004\b3\u0010&R\u001f\u00105\u001a\u00020\f*\u00020\u00048\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b4\u0010)\u001a\u0004\b3\u0010(R\u001f\u00108\u001a\u00020\f*\u00020\u001f8\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b7\u0010#\u001a\u0004\b6\u0010!R\u001f\u00108\u001a\u00020\f*\u00020%8\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b7\u0010'\u001a\u0004\b6\u0010&R\u001f\u00108\u001a\u00020\f*\u00020\u00048\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b7\u0010)\u001a\u0004\b6\u0010(R\u001f\u0010;\u001a\u00020\f*\u00020\u001f8\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b:\u0010#\u001a\u0004\b9\u0010!R\u001f\u0010;\u001a\u00020\f*\u00020%8\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b:\u0010'\u001a\u0004\b9\u0010&R\u001f\u0010;\u001a\u00020\f*\u00020\u00048\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b:\u0010)\u001a\u0004\b9\u0010("}, d2={"Lkotlin/time/Duration$Companion;", "", "<init>", "()V", "", "value", "Lkotlin/time/DurationUnit;", "sourceUnit", "targetUnit", "convert", "(DLkotlin/time/DurationUnit;Lkotlin/time/DurationUnit;)D", "", "Lkotlin/time/Duration;", "parse-UwyO8pc", "(Ljava/lang/String;)J", "parse", "parseIsoString-UwyO8pc", "parseIsoString", "parseOrNull-FghU774", "(Ljava/lang/String;)Lkotlin/time/Duration;", "parseOrNull", "parseIsoStringOrNull-FghU774", "parseIsoStringOrNull", "ZERO", "J", "getZERO-UwyO8pc", "()J", "INFINITE", "getINFINITE-UwyO8pc", "NEG_INFINITE", "getNEG_INFINITE-UwyO8pc$kotlin_stdlib", "", "getNanoseconds-UwyO8pc", "(I)J", "getNanoseconds-UwyO8pc$annotations", "(I)V", "nanoseconds", "", "(J)J", "(J)V", "(D)J", "(D)V", "getMicroseconds-UwyO8pc", "getMicroseconds-UwyO8pc$annotations", "microseconds", "getMilliseconds-UwyO8pc", "getMilliseconds-UwyO8pc$annotations", "milliseconds", "getSeconds-UwyO8pc", "getSeconds-UwyO8pc$annotations", "seconds", "getMinutes-UwyO8pc", "getMinutes-UwyO8pc$annotations", "minutes", "getHours-UwyO8pc", "getHours-UwyO8pc$annotations", "hours", "getDays-UwyO8pc", "getDays-UwyO8pc$annotations", "days"})
    public static final class Companion {
        private Companion() {
        }

        public final long getZERO-UwyO8pc() {
            return ZERO;
        }

        public final long getINFINITE-UwyO8pc() {
            return INFINITE;
        }

        public final long getNEG_INFINITE-UwyO8pc$kotlin_stdlib() {
            return NEG_INFINITE;
        }

        /*
         * WARNING - void declaration
         */
        @ExperimentalTime
        public final double convert(double value, DurationUnit sourceUnit, DurationUnit targetUnit) {
            void var3_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)sourceUnit, "sourceUnit");
            Intrinsics.checkNotNullParameter((Object)targetUnit, "targetUnit");
            return DurationUnitKt.convertDurationUnit((double)var1_1, (DurationUnit)var3_2, targetUnit);
        }

        private final long getNanoseconds-UwyO8pc(int $this$nanoseconds) {
            return DurationKt.toDuration($this$nanoseconds, DurationUnit.NANOSECONDS);
        }

        @InlineOnly
        public static /* synthetic */ void getNanoseconds-UwyO8pc$annotations(int n) {
        }

        private final long getNanoseconds-UwyO8pc(long $this$nanoseconds) {
            return DurationKt.toDuration($this$nanoseconds, DurationUnit.NANOSECONDS);
        }

        @InlineOnly
        public static /* synthetic */ void getNanoseconds-UwyO8pc$annotations(long l) {
        }

        private final long getNanoseconds-UwyO8pc(double $this$nanoseconds) {
            return DurationKt.toDuration($this$nanoseconds, DurationUnit.NANOSECONDS);
        }

        @InlineOnly
        public static /* synthetic */ void getNanoseconds-UwyO8pc$annotations(double d) {
        }

        private final long getMicroseconds-UwyO8pc(int $this$microseconds) {
            return DurationKt.toDuration($this$microseconds, DurationUnit.MICROSECONDS);
        }

        @InlineOnly
        public static /* synthetic */ void getMicroseconds-UwyO8pc$annotations(int n) {
        }

        private final long getMicroseconds-UwyO8pc(long $this$microseconds) {
            return DurationKt.toDuration($this$microseconds, DurationUnit.MICROSECONDS);
        }

        @InlineOnly
        public static /* synthetic */ void getMicroseconds-UwyO8pc$annotations(long l) {
        }

        private final long getMicroseconds-UwyO8pc(double $this$microseconds) {
            return DurationKt.toDuration($this$microseconds, DurationUnit.MICROSECONDS);
        }

        @InlineOnly
        public static /* synthetic */ void getMicroseconds-UwyO8pc$annotations(double d) {
        }

        private final long getMilliseconds-UwyO8pc(int $this$milliseconds) {
            return DurationKt.toDuration($this$milliseconds, DurationUnit.MILLISECONDS);
        }

        @InlineOnly
        public static /* synthetic */ void getMilliseconds-UwyO8pc$annotations(int n) {
        }

        private final long getMilliseconds-UwyO8pc(long $this$milliseconds) {
            return DurationKt.toDuration($this$milliseconds, DurationUnit.MILLISECONDS);
        }

        @InlineOnly
        public static /* synthetic */ void getMilliseconds-UwyO8pc$annotations(long l) {
        }

        private final long getMilliseconds-UwyO8pc(double $this$milliseconds) {
            return DurationKt.toDuration($this$milliseconds, DurationUnit.MILLISECONDS);
        }

        @InlineOnly
        public static /* synthetic */ void getMilliseconds-UwyO8pc$annotations(double d) {
        }

        private final long getSeconds-UwyO8pc(int $this$seconds) {
            return DurationKt.toDuration($this$seconds, DurationUnit.SECONDS);
        }

        @InlineOnly
        public static /* synthetic */ void getSeconds-UwyO8pc$annotations(int n) {
        }

        private final long getSeconds-UwyO8pc(long $this$seconds) {
            return DurationKt.toDuration($this$seconds, DurationUnit.SECONDS);
        }

        @InlineOnly
        public static /* synthetic */ void getSeconds-UwyO8pc$annotations(long l) {
        }

        private final long getSeconds-UwyO8pc(double $this$seconds) {
            return DurationKt.toDuration($this$seconds, DurationUnit.SECONDS);
        }

        @InlineOnly
        public static /* synthetic */ void getSeconds-UwyO8pc$annotations(double d) {
        }

        private final long getMinutes-UwyO8pc(int $this$minutes) {
            return DurationKt.toDuration($this$minutes, DurationUnit.MINUTES);
        }

        @InlineOnly
        public static /* synthetic */ void getMinutes-UwyO8pc$annotations(int n) {
        }

        private final long getMinutes-UwyO8pc(long $this$minutes) {
            return DurationKt.toDuration($this$minutes, DurationUnit.MINUTES);
        }

        @InlineOnly
        public static /* synthetic */ void getMinutes-UwyO8pc$annotations(long l) {
        }

        private final long getMinutes-UwyO8pc(double $this$minutes) {
            return DurationKt.toDuration($this$minutes, DurationUnit.MINUTES);
        }

        @InlineOnly
        public static /* synthetic */ void getMinutes-UwyO8pc$annotations(double d) {
        }

        private final long getHours-UwyO8pc(int $this$hours) {
            return DurationKt.toDuration($this$hours, DurationUnit.HOURS);
        }

        @InlineOnly
        public static /* synthetic */ void getHours-UwyO8pc$annotations(int n) {
        }

        private final long getHours-UwyO8pc(long $this$hours) {
            return DurationKt.toDuration($this$hours, DurationUnit.HOURS);
        }

        @InlineOnly
        public static /* synthetic */ void getHours-UwyO8pc$annotations(long l) {
        }

        private final long getHours-UwyO8pc(double $this$hours) {
            return DurationKt.toDuration($this$hours, DurationUnit.HOURS);
        }

        @InlineOnly
        public static /* synthetic */ void getHours-UwyO8pc$annotations(double d) {
        }

        private final long getDays-UwyO8pc(int $this$days) {
            return DurationKt.toDuration($this$days, DurationUnit.DAYS);
        }

        @InlineOnly
        public static /* synthetic */ void getDays-UwyO8pc$annotations(int n) {
        }

        private final long getDays-UwyO8pc(long $this$days) {
            return DurationKt.toDuration($this$days, DurationUnit.DAYS);
        }

        @InlineOnly
        public static /* synthetic */ void getDays-UwyO8pc$annotations(long l) {
        }

        private final long getDays-UwyO8pc(double $this$days) {
            return DurationKt.toDuration($this$days, DurationUnit.DAYS);
        }

        @InlineOnly
        public static /* synthetic */ void getDays-UwyO8pc$annotations(double d) {
        }

        /*
         * WARNING - void declaration
         */
        public final long parse-UwyO8pc(String value) {
            long l;
            Intrinsics.checkNotNullParameter(value, "value");
            try {
                l = DurationKt.access$parseDuration(value, false);
            }
            catch (IllegalArgumentException e) {
                void var2_3;
                void var1_1;
                throw new IllegalArgumentException("Invalid duration string format: '" + (String)var1_1 + "'.", (Throwable)var2_3);
            }
            return l;
        }

        /*
         * WARNING - void declaration
         */
        public final long parseIsoString-UwyO8pc(String value) {
            long l;
            Intrinsics.checkNotNullParameter(value, "value");
            try {
                l = DurationKt.access$parseDuration(value, true);
            }
            catch (IllegalArgumentException e) {
                void var2_3;
                void var1_1;
                throw new IllegalArgumentException("Invalid ISO duration string format: '" + (String)var1_1 + "'.", (Throwable)var2_3);
            }
            return l;
        }

        public final Duration parseOrNull-FghU774(String value) {
            Duration duration;
            Intrinsics.checkNotNullParameter(value, "value");
            try {
                duration = Duration.box-impl(DurationKt.access$parseDuration((String)((Object)duration), false));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                duration = null;
            }
            return duration;
        }

        public final Duration parseIsoStringOrNull-FghU774(String value) {
            Duration duration;
            Intrinsics.checkNotNullParameter(value, "value");
            try {
                duration = Duration.box-impl(DurationKt.access$parseDuration((String)((Object)duration), true));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                duration = null;
            }
            return duration;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

