/*
 * Decompiled with CFR 0.152.
 */
package kotlin.random;

import java.io.Serializable;
import kotlin.Metadata;
import kotlin.SinceKotlin;
import kotlin.internal.PlatformImplementationsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.PlatformRandomKt;
import kotlin.random.RandomKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\t\b'\u0018\u0000 &2\u00020\u0001:\u0001&B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H&\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\b\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\b\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\b\u0010\u0007J\u001f\u0010\b\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\b\u0010\fJ\u000f\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u0010J\u001f\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u0011J\u000f\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0016\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0018J\u001f\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0019J\u000f\u0010\u001b\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ+\u0010!\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\b\b\u0002\u0010\u001f\u001a\u00020\u00042\b\b\u0002\u0010 \u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010!\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0016\u00a2\u0006\u0004\b!\u0010#J\u0017\u0010!\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b!\u0010%"}, d2={"Lkotlin/random/Random;", "", "<init>", "()V", "", "bitCount", "nextBits", "(I)I", "nextInt", "()I", "until", "from", "(II)I", "", "nextLong", "()J", "(J)J", "(JJ)J", "", "nextBoolean", "()Z", "", "nextDouble", "()D", "(D)D", "(DD)D", "", "nextFloat", "()F", "", "array", "fromIndex", "toIndex", "nextBytes", "([BII)[B", "([B)[B", "size", "(I)[B", "Default"})
@SinceKotlin(version="1.3")
@SourceDebugExtension(value={"SMAP\nRandom.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Random.kt\nkotlin/random/Random\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,383:1\n1#2:384\n*E\n"})
public abstract class Random {
    public static final Default Default = new Default(null);
    private static final Random defaultRandom = PlatformImplementationsKt.IMPLEMENTATIONS.defaultPlatformRandom();

    public abstract int nextBits(int var1);

    public int nextInt() {
        return this.nextBits(32);
    }

    /*
     * WARNING - void declaration
     */
    public int nextInt(int until) {
        void var1_1;
        return this.nextInt(0, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public int nextInt(int from, int until) {
        void var3_3;
        boolean bl;
        int rnd;
        void var2_2;
        RandomKt.checkRangeBounds(from, until);
        int n = until - from;
        if (n > 0 || n == Integer.MIN_VALUE) {
            int n2;
            int n3 = n;
            if ((n3 & -n3) == n) {
                int bitCount = RandomKt.fastLog2(n);
                n2 = this.nextBits(bitCount);
            } else {
                int v;
                int bits;
                while ((bits = this.nextInt() >>> 1) - (v = bits % n) + (n - 1) < 0) {
                }
                n2 = var2_2;
            }
            rnd = n2;
            return from + rnd;
        }
        do {
            if (from <= (rnd = this.nextInt())) {
                if (rnd < var2_2) {
                    bl = true;
                    continue;
                }
                bl = false;
                continue;
            }
            bl = false;
        } while (!bl);
        return (int)var3_3;
    }

    public long nextLong() {
        return ((long)this.nextInt() << 32) + (long)this.nextInt();
    }

    /*
     * WARNING - void declaration
     */
    public long nextLong(long until) {
        void var1_1;
        return this.nextLong(0L, (long)var1_1);
    }

    public long nextLong(long from, long until) {
        long rnd;
        boolean bl;
        RandomKt.checkRangeBounds(from, until);
        long n = until - from;
        if (n > 0L) {
            long rnd2;
            long l = n;
            if ((l & -l) == n) {
                long l2;
                int bitCount;
                int nLow = (int)n;
                int nHigh = (int)(n >>> 32);
                if (nLow != 0) {
                    bitCount = RandomKt.fastLog2(nLow);
                    l2 = (long)this.nextBits(bitCount) & 0xFFFFFFFFL;
                } else if (nHigh == 1) {
                    l2 = (long)this.nextInt() & 0xFFFFFFFFL;
                } else {
                    bitCount = RandomKt.fastLog2(nHigh);
                    l2 = ((long)this.nextBits(bitCount) << 32) + ((long)this.nextInt() & 0xFFFFFFFFL);
                }
                rnd2 = l2;
            } else {
                long v;
                long bits;
                while ((bits = this.nextLong() >>> 1) - (v = bits % n) + (n - 1L) < 0L) {
                }
                rnd2 = v;
            }
            return from + rnd2;
        }
        do {
            if (from <= (rnd = this.nextLong())) {
                if (rnd < until) {
                    bl = true;
                    continue;
                }
                bl = false;
                continue;
            }
            bl = false;
        } while (!bl);
        return rnd;
    }

    public boolean nextBoolean() {
        return this.nextBits(1) != 0;
    }

    public double nextDouble() {
        return PlatformRandomKt.doubleFromParts(this.nextBits(26), this.nextBits(27));
    }

    /*
     * WARNING - void declaration
     */
    public double nextDouble(double until) {
        void var1_1;
        return this.nextDouble(0.0, (double)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public double nextDouble(double from, double until) {
        void r;
        double d;
        RandomKt.checkRangeBounds(from, until);
        double size = until - from;
        if (Double.isInfinite(size) && !Double.isInfinite(from) && !Double.isNaN(from) && !Double.isInfinite(until) && !Double.isNaN(until)) {
            double r1 = this.nextDouble() * (until / 2.0 - from / 2.0);
            d = from + r1 + r1;
        } else {
            void var1_1;
            d = r = var1_1 + this.nextDouble() * size;
        }
        if (d >= until) {
            void var3_2;
            return Math.nextAfter((double)var3_2, Double.NEGATIVE_INFINITY);
        }
        return (double)r;
    }

    public float nextFloat() {
        return (float)this.nextBits(24) / 1.6777216E7f;
    }

    /*
     * Unable to fully structure code
     */
    public byte[] nextBytes(byte[] array, int fromIndex, int toIndex) {
        Intrinsics.checkNotNullParameter(array, "array");
        v0 = fromIndex >= 0 ? fromIndex <= array.length : false;
        if (!v0) ** GOTO lbl-1000
        v1 = toIndex >= 0 ? toIndex <= array.length : false;
        if (v1) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        if (!v2) {
            fromIndex = "fromIndex (" + fromIndex + ") or toIndex (" + toIndex + ") are out of range: 0.." + array.length + '.';
            throw new IllegalArgumentException(fromIndex.toString());
        }
        if (!(fromIndex <= toIndex)) {
            fromIndex = "fromIndex (" + fromIndex + ") must be not greater than toIndex (" + toIndex + ").";
            throw new IllegalArgumentException(fromIndex.toString());
        }
        steps = (toIndex - fromIndex) / 4;
        for (var5_7 = 0; var5_7 < steps; ++var5_7) {
            v = this.nextInt();
            array[position] = (byte)v;
            array[position + true] = (byte)(v >>> 8);
            array[position + 2] = (byte)(v >>> 16);
            array[position + 3] = (byte)(v >>> 24);
            position += 4;
        }
        remainder = toIndex - position;
        vr = this.nextBits(remainder * 8);
        for (i = 0; i < remainder; ++i) {
            array[position + i] = (byte)(vr >>> i * 8);
        }
        return var1_1;
    }

    public static /* synthetic */ byte[] nextBytes$default(Random random, byte[] byArray, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: nextBytes");
        }
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        return random.nextBytes(byArray, n, n2);
    }

    /*
     * WARNING - void declaration
     */
    public byte[] nextBytes(byte[] array) {
        void var1_1;
        Intrinsics.checkNotNullParameter(array, "array");
        return this.nextBytes(array, 0, ((void)var1_1).length);
    }

    /*
     * WARNING - void declaration
     */
    public byte[] nextBytes(int size) {
        void var1_1;
        return this.nextBytes(new byte[var1_1]);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u00012\u00060\u0002j\u0002`\u0003:\u0001-B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\r\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\r\u0010\fJ\u001f\u0010\r\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\r\u0010\u0011J\u000f\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0015J\u001f\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0016J\u000f\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001b\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0017\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001dJ\u001f\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001eJ\u000f\u0010 \u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\b \u0010!J\u0017\u0010$\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"H\u0016\u00a2\u0006\u0004\b$\u0010%J\u0017\u0010$\u001a\u00020\"2\u0006\u0010&\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b$\u0010'J'\u0010$\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"2\u0006\u0010(\u001a\u00020\t2\u0006\u0010)\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b$\u0010*R\u0014\u0010+\u001a\u00020\u00018\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010,"}, d2={"Lkotlin/random/Random$Default;", "Lkotlin/random/Random;", "Ljava/io/Serializable;", "Lkotlin/io/Serializable;", "<init>", "()V", "", "writeReplace", "()Ljava/lang/Object;", "", "bitCount", "nextBits", "(I)I", "nextInt", "()I", "until", "from", "(II)I", "", "nextLong", "()J", "(J)J", "(JJ)J", "", "nextBoolean", "()Z", "", "nextDouble", "()D", "(D)D", "(DD)D", "", "nextFloat", "()F", "", "array", "nextBytes", "([B)[B", "size", "(I)[B", "fromIndex", "toIndex", "([BII)[B", "defaultRandom", "Lkotlin/random/Random;", "Serialized"})
    public static final class Default
    extends Random
    implements Serializable {
        private Default() {
        }

        private final Object writeReplace() {
            return Serialized.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int nextBits(int bitCount) {
            void var1_1;
            return defaultRandom.nextBits((int)var1_1);
        }

        @Override
        public final int nextInt() {
            return defaultRandom.nextInt();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int nextInt(int until) {
            void var1_1;
            return defaultRandom.nextInt((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int nextInt(int from, int until) {
            void var2_2;
            void var1_1;
            return defaultRandom.nextInt((int)var1_1, (int)var2_2);
        }

        @Override
        public final long nextLong() {
            return defaultRandom.nextLong();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final long nextLong(long until) {
            void var1_1;
            return defaultRandom.nextLong((long)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final long nextLong(long from, long until) {
            void var3_2;
            void var1_1;
            return defaultRandom.nextLong((long)var1_1, (long)var3_2);
        }

        @Override
        public final boolean nextBoolean() {
            return defaultRandom.nextBoolean();
        }

        @Override
        public final double nextDouble() {
            return defaultRandom.nextDouble();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final double nextDouble(double until) {
            void var1_1;
            return defaultRandom.nextDouble((double)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final double nextDouble(double from, double until) {
            void var3_2;
            void var1_1;
            return defaultRandom.nextDouble((double)var1_1, (double)var3_2);
        }

        @Override
        public final float nextFloat() {
            return defaultRandom.nextFloat();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final byte[] nextBytes(byte[] array) {
            void var1_1;
            Intrinsics.checkNotNullParameter(array, "array");
            return defaultRandom.nextBytes((byte[])var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final byte[] nextBytes(int size) {
            void var1_1;
            return defaultRandom.nextBytes((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final byte[] nextBytes(byte[] array, int fromIndex, int toIndex) {
            void var3_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter(array, "array");
            return defaultRandom.nextBytes((byte[])var1_1, (int)var2_2, (int)var3_3);
        }

        public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0006\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\t\u0010\n"}, d2={"Lkotlin/random/Random$Default$Serialized;", "Ljava/io/Serializable;", "Lkotlin/io/Serializable;", "<init>", "()V", "", "readResolve", "()Ljava/lang/Object;", "", "serialVersionUID", "J"})
        private static final class Serialized
        implements Serializable {
            public static final Serialized INSTANCE = new Serialized();
            private static final long serialVersionUID = 0L;

            private Serialized() {
            }

            private final Object readResolve() {
                return Default;
            }
        }
    }
}

