/*
 * Decompiled with CFR 0.152.
 */
package kotlin.jvm.internal;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import kotlin.SinceKotlin;
import kotlin.jvm.KotlinReflectionNotSupportedError;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KCallable;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KParameter;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeParameter;
import kotlin.reflect.KVisibility;

public abstract class CallableReference
implements Serializable,
KCallable {
    private transient KCallable reflected;
    @SinceKotlin(version="1.1")
    protected final Object receiver;
    @SinceKotlin(version="1.4")
    private final Class owner;
    @SinceKotlin(version="1.4")
    private final String name;
    @SinceKotlin(version="1.4")
    private final String signature;
    @SinceKotlin(version="1.4")
    private final boolean isTopLevel;
    @SinceKotlin(version="1.1")
    public static final Object NO_RECEIVER = NoReceiver.access$000();

    public CallableReference() {
        this(NO_RECEIVER);
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.1")
    protected CallableReference(Object receiver) {
        this(var1_1, null, null, null, false);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.4")
    protected CallableReference(Object receiver, Class owner, String name, String signature, boolean isTopLevel) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.receiver = var1_1;
        this.owner = var2_2;
        this.name = var3_3;
        this.signature = signature;
        this.isTopLevel = isTopLevel;
    }

    protected abstract KCallable computeReflected();

    @SinceKotlin(version="1.1")
    public Object getBoundReceiver() {
        return this.receiver;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.1")
    public KCallable compute() {
        void var1_1;
        KCallable result = this.reflected;
        if (result == null) {
            this.reflected = result = this.computeReflected();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.1")
    protected KCallable getReflected() {
        void var1_1;
        KCallable result = this.compute();
        if (result == this) {
            throw new KotlinReflectionNotSupportedError();
        }
        return var1_1;
    }

    public KDeclarationContainer getOwner() {
        if (this.owner == null) {
            return null;
        }
        if (this.isTopLevel) {
            return Reflection.getOrCreateKotlinPackage(this.owner);
        }
        return Reflection.getOrCreateKotlinClass(this.owner);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getSignature() {
        return this.signature;
    }

    @Override
    public List<KParameter> getParameters() {
        return this.getReflected().getParameters();
    }

    @Override
    public KType getReturnType() {
        return this.getReflected().getReturnType();
    }

    @Override
    public List<Annotation> getAnnotations() {
        return this.getReflected().getAnnotations();
    }

    @Override
    @SinceKotlin(version="1.1")
    public List<KTypeParameter> getTypeParameters() {
        return this.getReflected().getTypeParameters();
    }

    /*
     * WARNING - void declaration
     */
    public Object call(Object ... args) {
        void var1_1;
        return this.getReflected().call((Object[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Object callBy(Map args) {
        void var1_1;
        return this.getReflected().callBy((Map<KParameter, Object>)var1_1);
    }

    @Override
    @SinceKotlin(version="1.1")
    public KVisibility getVisibility() {
        return this.getReflected().getVisibility();
    }

    @Override
    @SinceKotlin(version="1.1")
    public boolean isFinal() {
        return this.getReflected().isFinal();
    }

    @Override
    @SinceKotlin(version="1.1")
    public boolean isOpen() {
        return this.getReflected().isOpen();
    }

    @Override
    @SinceKotlin(version="1.1")
    public boolean isAbstract() {
        return this.getReflected().isAbstract();
    }

    @Override
    @SinceKotlin(version="1.3")
    public boolean isSuspend() {
        return this.getReflected().isSuspend();
    }

    @SinceKotlin(version="1.2")
    private static class NoReceiver
    implements Serializable {
        private static final NoReceiver INSTANCE = new NoReceiver();

        private NoReceiver() {
        }

        private Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }

        static /* synthetic */ NoReceiver access$000() {
            return INSTANCE;
        }
    }
}

