/*
 * Decompiled with CFR 0.152.
 */
package kotlin.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.NoSuchElementException;
import kotlin.Deprecated;
import kotlin.DeprecatedSinceKotlin;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.SinceKotlin;
import kotlin.collections.ByteIterator;
import kotlin.internal.InlineOnly;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0006\u001a\u0014\u0010\u0002\u001a\u00020\u0001*\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u001e\u0010\b\u001a\u00020\u0007*\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u0087\b\u00a2\u0006\u0004\b\b\u0010\t\u001a\u0014\u0010\u000b\u001a\u00020\u0007*\u00020\nH\u0087\b\u00a2\u0006\u0004\b\u000b\u0010\f\u001a$\u0010\u000b\u001a\u00020\u0007*\u00020\n2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0087\b\u00a2\u0006\u0004\b\u000b\u0010\u0010\u001a\u001e\u0010\u0013\u001a\u00020\u0000*\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\rH\u0087\b\u00a2\u0006\u0004\b\u0013\u0010\u0014\u001a\u001e\u0010\u0016\u001a\u00020\u0015*\u00020\u00112\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u0087\b\u00a2\u0006\u0004\b\u0016\u0010\u0017\u001a\u001e\u0010\u0019\u001a\u00020\u0018*\u00020\u00112\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u0087\b\u00a2\u0006\u0004\b\u0019\u0010\u001a\u001a\u001e\u0010\u0013\u001a\u00020\u001c*\u00020\u001b2\b\b\u0002\u0010\u0012\u001a\u00020\rH\u0087\b\u00a2\u0006\u0004\b\u0013\u0010\u001d\u001a\u001e\u0010\u001f\u001a\u00020\u001e*\u00020\u001b2\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u0087\b\u00a2\u0006\u0004\b\u001f\u0010 \u001a\u001e\u0010\"\u001a\u00020!*\u00020\u001b2\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u0087\b\u00a2\u0006\u0004\b\"\u0010#\u001a#\u0010&\u001a\u00020%*\u00020\u00112\u0006\u0010$\u001a\u00020\u001b2\b\b\u0002\u0010\u0012\u001a\u00020\r\u00a2\u0006\u0004\b&\u0010'\u001a\u001d\u0010)\u001a\u00020\n*\u00020\u00112\b\b\u0002\u0010(\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b)\u0010*\u001a\u0013\u0010)\u001a\u00020\n*\u00020\u0011H\u0007\u00a2\u0006\u0004\b)\u0010+"}, d2={"Ljava/io/BufferedInputStream;", "Lkotlin/collections/ByteIterator;", "iterator", "(Ljava/io/BufferedInputStream;)Lkotlin/collections/ByteIterator;", "", "Ljava/nio/charset/Charset;", "charset", "Ljava/io/ByteArrayInputStream;", "byteInputStream", "(Ljava/lang/String;Ljava/nio/charset/Charset;)Ljava/io/ByteArrayInputStream;", "", "inputStream", "([B)Ljava/io/ByteArrayInputStream;", "", "offset", "length", "([BII)Ljava/io/ByteArrayInputStream;", "Ljava/io/InputStream;", "bufferSize", "buffered", "(Ljava/io/InputStream;I)Ljava/io/BufferedInputStream;", "Ljava/io/InputStreamReader;", "reader", "(Ljava/io/InputStream;Ljava/nio/charset/Charset;)Ljava/io/InputStreamReader;", "Ljava/io/BufferedReader;", "bufferedReader", "(Ljava/io/InputStream;Ljava/nio/charset/Charset;)Ljava/io/BufferedReader;", "Ljava/io/OutputStream;", "Ljava/io/BufferedOutputStream;", "(Ljava/io/OutputStream;I)Ljava/io/BufferedOutputStream;", "Ljava/io/OutputStreamWriter;", "writer", "(Ljava/io/OutputStream;Ljava/nio/charset/Charset;)Ljava/io/OutputStreamWriter;", "Ljava/io/BufferedWriter;", "bufferedWriter", "(Ljava/io/OutputStream;Ljava/nio/charset/Charset;)Ljava/io/BufferedWriter;", "out", "", "copyTo", "(Ljava/io/InputStream;Ljava/io/OutputStream;I)J", "estimatedSize", "readBytes", "(Ljava/io/InputStream;I)[B", "(Ljava/io/InputStream;)[B"})
@JvmName(name="ByteStreamsKt")
public final class ByteStreamsKt {
    public static final ByteIterator iterator(BufferedInputStream $this$iterator) {
        BufferedInputStream bufferedInputStream;
        Intrinsics.checkNotNullParameter($this$iterator, "<this>");
        return new ByteIterator(bufferedInputStream){
            private int nextByte;
            private boolean nextPrepared;
            private boolean finished;
            final /* synthetic */ BufferedInputStream $this_iterator;
            {
                void var1_1;
                this.$this_iterator = var1_1;
                this.nextByte = -1;
            }

            public final int getNextByte() {
                return this.nextByte;
            }

            /*
             * WARNING - void declaration
             */
            public final void setNextByte(int n) {
                void var1_1;
                this.nextByte = var1_1;
            }

            public final boolean getNextPrepared() {
                return this.nextPrepared;
            }

            /*
             * WARNING - void declaration
             */
            public final void setNextPrepared(boolean bl) {
                void var1_1;
                this.nextPrepared = var1_1;
            }

            public final boolean getFinished() {
                return this.finished;
            }

            /*
             * WARNING - void declaration
             */
            public final void setFinished(boolean bl) {
                void var1_1;
                this.finished = var1_1;
            }

            private final void prepareNext() {
                if (!this.nextPrepared && !this.finished) {
                    this.nextByte = this.$this_iterator.read();
                    this.nextPrepared = true;
                    this.finished = this.nextByte == -1;
                }
            }

            public final boolean hasNext() {
                this.prepareNext();
                return !this.finished;
            }

            /*
             * WARNING - void declaration
             */
            public final byte nextByte() {
                void var1_1;
                this.prepareNext();
                if (this.finished) {
                    throw new NoSuchElementException("Input stream is over.");
                }
                byte res = (byte)this.nextByte;
                this.nextPrepared = false;
                return (byte)var1_1;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @InlineOnly
    private static final ByteArrayInputStream byteInputStream(String $this$byteInputStream, Charset charset) {
        void var1_1;
        String string;
        Intrinsics.checkNotNullParameter($this$byteInputStream, "<this>");
        Intrinsics.checkNotNullParameter(charset, "charset");
        byte[] byArray = string.getBytes((Charset)var1_1);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        return new ByteArrayInputStream(byArray);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ ByteArrayInputStream byteInputStream$default(String $this$byteInputStream_u24default, Charset charset, int n, Object object) {
        void var1_1;
        String string;
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        Intrinsics.checkNotNullParameter($this$byteInputStream_u24default, "<this>");
        Intrinsics.checkNotNullParameter(charset, "charset");
        byte[] byArray = string.getBytes((Charset)var1_1);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        return new ByteArrayInputStream(byArray);
    }

    @InlineOnly
    private static final ByteArrayInputStream inputStream(byte[] $this$inputStream) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter($this$inputStream, "<this>");
        return new ByteArrayInputStream(byArray);
    }

    /*
     * WARNING - void declaration
     */
    @InlineOnly
    private static final ByteArrayInputStream inputStream(byte[] $this$inputStream, int offset, int length) {
        void var2_2;
        void var1_1;
        byte[] byArray;
        Intrinsics.checkNotNullParameter($this$inputStream, "<this>");
        return new ByteArrayInputStream(byArray, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @InlineOnly
    private static final BufferedInputStream buffered(InputStream $this$buffered, int bufferSize) {
        void var1_1;
        InputStream inputStream;
        Intrinsics.checkNotNullParameter($this$buffered, "<this>");
        if ($this$buffered instanceof BufferedInputStream) {
            return (BufferedInputStream)$this$buffered;
        }
        return new BufferedInputStream(inputStream, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ BufferedInputStream buffered$default(InputStream $this$buffered_u24default, int bufferSize, int n, Object object) {
        void var1_1;
        InputStream inputStream;
        if ((n & 1) != 0) {
            bufferSize = 8192;
        }
        Intrinsics.checkNotNullParameter($this$buffered_u24default, "<this>");
        if ($this$buffered_u24default instanceof BufferedInputStream) {
            return (BufferedInputStream)$this$buffered_u24default;
        }
        return new BufferedInputStream(inputStream, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @InlineOnly
    private static final InputStreamReader reader(InputStream $this$reader, Charset charset) {
        void var1_1;
        InputStream inputStream;
        Intrinsics.checkNotNullParameter($this$reader, "<this>");
        Intrinsics.checkNotNullParameter(charset, "charset");
        return new InputStreamReader(inputStream, (Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ InputStreamReader reader$default(InputStream $this$reader_u24default, Charset charset, int n, Object object) {
        void var1_1;
        InputStream inputStream;
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        Intrinsics.checkNotNullParameter($this$reader_u24default, "<this>");
        Intrinsics.checkNotNullParameter(charset, "charset");
        return new InputStreamReader(inputStream, (Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @InlineOnly
    private static final BufferedReader bufferedReader(InputStream $this$bufferedReader, Charset charset) {
        void var1_1;
        Closeable closeable;
        Intrinsics.checkNotNullParameter($this$bufferedReader, "<this>");
        Intrinsics.checkNotNullParameter(charset, "charset");
        closeable = new InputStreamReader((InputStream)closeable, (Charset)var1_1);
        return new BufferedReader((Reader)closeable, 8192);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ BufferedReader bufferedReader$default(InputStream $this$bufferedReader_u24default, Charset charset, int n, Object object) {
        void var1_1;
        InputStream inputStream;
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        Intrinsics.checkNotNullParameter($this$bufferedReader_u24default, "<this>");
        Intrinsics.checkNotNullParameter(charset, "charset");
        Reader reader = new InputStreamReader(inputStream, (Charset)var1_1);
        return new BufferedReader(reader, 8192);
    }

    /*
     * WARNING - void declaration
     */
    @InlineOnly
    private static final BufferedOutputStream buffered(OutputStream $this$buffered, int bufferSize) {
        void var1_1;
        OutputStream outputStream;
        Intrinsics.checkNotNullParameter($this$buffered, "<this>");
        if ($this$buffered instanceof BufferedOutputStream) {
            return (BufferedOutputStream)$this$buffered;
        }
        return new BufferedOutputStream(outputStream, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ BufferedOutputStream buffered$default(OutputStream $this$buffered_u24default, int bufferSize, int n, Object object) {
        void var1_1;
        OutputStream outputStream;
        if ((n & 1) != 0) {
            bufferSize = 8192;
        }
        Intrinsics.checkNotNullParameter($this$buffered_u24default, "<this>");
        if ($this$buffered_u24default instanceof BufferedOutputStream) {
            return (BufferedOutputStream)$this$buffered_u24default;
        }
        return new BufferedOutputStream(outputStream, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @InlineOnly
    private static final OutputStreamWriter writer(OutputStream $this$writer, Charset charset) {
        void var1_1;
        OutputStream outputStream;
        Intrinsics.checkNotNullParameter($this$writer, "<this>");
        Intrinsics.checkNotNullParameter(charset, "charset");
        return new OutputStreamWriter(outputStream, (Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ OutputStreamWriter writer$default(OutputStream $this$writer_u24default, Charset charset, int n, Object object) {
        void var1_1;
        OutputStream outputStream;
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        Intrinsics.checkNotNullParameter($this$writer_u24default, "<this>");
        Intrinsics.checkNotNullParameter(charset, "charset");
        return new OutputStreamWriter(outputStream, (Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @InlineOnly
    private static final BufferedWriter bufferedWriter(OutputStream $this$bufferedWriter, Charset charset) {
        void var1_1;
        Closeable closeable;
        Intrinsics.checkNotNullParameter($this$bufferedWriter, "<this>");
        Intrinsics.checkNotNullParameter(charset, "charset");
        closeable = new OutputStreamWriter((OutputStream)closeable, (Charset)var1_1);
        return new BufferedWriter((Writer)closeable, 8192);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ BufferedWriter bufferedWriter$default(OutputStream $this$bufferedWriter_u24default, Charset charset, int n, Object object) {
        void var1_1;
        OutputStream outputStream;
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        Intrinsics.checkNotNullParameter($this$bufferedWriter_u24default, "<this>");
        Intrinsics.checkNotNullParameter(charset, "charset");
        Writer writer = new OutputStreamWriter(outputStream, (Charset)var1_1);
        return new BufferedWriter(writer, 8192);
    }

    /*
     * WARNING - void declaration
     */
    public static final long copyTo(InputStream $this$copyTo, OutputStream out, int bufferSize) {
        void var3_4;
        Intrinsics.checkNotNullParameter($this$copyTo, "<this>");
        Intrinsics.checkNotNullParameter(out, "out");
        long bytesCopied = 0L;
        byte[] buffer = new byte[bufferSize];
        int bytes = $this$copyTo.read(buffer);
        while (bytes >= 0) {
            out.write(buffer, 0, bytes);
            bytesCopied += (long)bytes;
            bytes = $this$copyTo.read(buffer);
        }
        return (long)var3_4;
    }

    public static /* synthetic */ long copyTo$default(InputStream inputStream, OutputStream outputStream, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 8192;
        }
        return ByteStreamsKt.copyTo(inputStream, outputStream, n);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated(message="Use readBytes() overload without estimatedSize parameter", replaceWith=@ReplaceWith(expression="readBytes()", imports={}))
    @DeprecatedSinceKotlin(warningSince="1.3", errorSince="1.5")
    public static final byte[] readBytes(InputStream $this$readBytes, int estimatedSize) {
        void var1_2;
        InputStream inputStream;
        Intrinsics.checkNotNullParameter($this$readBytes, "<this>");
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(Math.max(estimatedSize, $this$readBytes.available()));
        ByteStreamsKt.copyTo$default(inputStream, buffer, 0, 2, null);
        byte[] byArray = var1_2.toByteArray();
        Intrinsics.checkNotNullExpressionValue(byArray, "toByteArray(...)");
        return byArray;
    }

    public static /* synthetic */ byte[] readBytes$default(InputStream inputStream, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 8192;
        }
        return ByteStreamsKt.readBytes(inputStream, n);
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.3")
    public static final byte[] readBytes(InputStream $this$readBytes) {
        void var1_1;
        InputStream inputStream;
        Intrinsics.checkNotNullParameter($this$readBytes, "<this>");
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(Math.max(8192, $this$readBytes.available()));
        ByteStreamsKt.copyTo$default(inputStream, buffer, 0, 2, null);
        byte[] byArray = var1_1.toByteArray();
        Intrinsics.checkNotNullExpressionValue(byArray, "toByteArray(...)");
        return byArray;
    }
}

