/*
 * Decompiled with CFR 0.152.
 */
package kotlin.collections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.SinceKotlin;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.builders.ListBuilder;
import kotlin.internal.InlineOnly;
import kotlin.internal.PlatformImplementationsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 1, 0}, k=5, xi=49, d1={"\u0000Z\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\b\u001a!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\"\u0004\b\u0000\u0010\u00002\u0006\u0010\u0001\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a>\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\"\u0004\b\u0000\u0010\u00052\u001d\u0010\n\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\b\tH\u0081\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000b\u0010\f\u001aF\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\"\u0004\b\u0000\u0010\u00052\u0006\u0010\u000e\u001a\u00020\r2\u001d\u0010\n\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\b\tH\u0081\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000b\u0010\u000f\u001a\u001b\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\"\u0004\b\u0000\u0010\u0005H\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011\u001a#\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\"\u0004\b\u0000\u0010\u00052\u0006\u0010\u000e\u001a\u00020\rH\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0012\u001a)\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\"\u0004\b\u0000\u0010\u00052\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007H\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015\u001a&\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\"\u0004\b\u0000\u0010\u0000*\b\u0012\u0004\u0012\u00028\u00000\u0016H\u0087\b\u00a2\u0006\u0004\b\u0017\u0010\u0018\u001a%\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\"\u0004\b\u0000\u0010\u0000*\b\u0012\u0004\u0012\u00028\u00000\u0019H\u0007\u00a2\u0006\u0004\b\u001a\u0010\u001b\u001a-\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\"\u0004\b\u0000\u0010\u0000*\b\u0012\u0004\u0012\u00028\u00000\u00192\u0006\u0010\u001d\u001a\u00020\u001cH\u0007\u00a2\u0006\u0004\b\u001a\u0010\u001e\u001a$\u0010#\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\"0!2\n\u0010 \u001a\u0006\u0012\u0002\b\u00030\u001fH\u0081\b\u00a2\u0006\u0004\b#\u0010$\u001a6\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000!\"\u0004\b\u0000\u0010\u00002\n\u0010 \u001a\u0006\u0012\u0002\b\u00030\u001f2\f\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000!H\u0081\b\u00a2\u0006\u0004\b#\u0010&\u001a1\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000!\"\u0004\b\u0000\u0010\u00002\u0006\u0010'\u001a\u00020\r2\f\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000!H\u0000\u00a2\u0006\u0004\b(\u0010)\u001a3\u0010,\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\"0!\"\u0004\b\u0000\u0010\u0000*\n\u0012\u0006\b\u0001\u0012\u00028\u00000!2\u0006\u0010+\u001a\u00020*H\u0000\u00a2\u0006\u0004\b,\u0010-\u001a\u0018\u0010/\u001a\u00020\r2\u0006\u0010.\u001a\u00020\rH\u0081\b\u00a2\u0006\u0004\b/\u00100\u001a\u0018\u00102\u001a\u00020\r2\u0006\u00101\u001a\u00020\rH\u0081\b\u00a2\u0006\u0004\b2\u00100\u0082\u0002\u0007\n\u0005\b\u009920\u0001"}, d2={"T", "element", "", "listOf", "(Ljava/lang/Object;)Ljava/util/List;", "E", "Lkotlin/Function1;", "", "", "Lkotlin/ExtensionFunctionType;", "builderAction", "buildListInternal", "(Lkotlin/jvm/functions/Function1;)Ljava/util/List;", "", "capacity", "(ILkotlin/jvm/functions/Function1;)Ljava/util/List;", "createListBuilder", "()Ljava/util/List;", "(I)Ljava/util/List;", "builder", "build", "(Ljava/util/List;)Ljava/util/List;", "Ljava/util/Enumeration;", "toList", "(Ljava/util/Enumeration;)Ljava/util/List;", "", "shuffled", "(Ljava/lang/Iterable;)Ljava/util/List;", "Ljava/util/Random;", "random", "(Ljava/lang/Iterable;Ljava/util/Random;)Ljava/util/List;", "", "collection", "", "", "collectionToArray", "(Ljava/util/Collection;)[Ljava/lang/Object;", "array", "(Ljava/util/Collection;[Ljava/lang/Object;)[Ljava/lang/Object;", "collectionSize", "terminateCollectionToArray", "(I[Ljava/lang/Object;)[Ljava/lang/Object;", "", "isVarargs", "copyToArrayOfAny", "([Ljava/lang/Object;Z)[Ljava/lang/Object;", "index", "checkIndexOverflow", "(I)I", "count", "checkCountOverflow"}, xs="kotlin/collections/CollectionsKt")
@SourceDebugExtension(value={"SMAP\nCollectionsJVM.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CollectionsJVM.kt\nkotlin/collections/CollectionsKt__CollectionsJVMKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,131:1\n1#2:132\n*E\n"})
class CollectionsKt__CollectionsJVMKt {
    public static final <T> List<T> listOf(T element) {
        List<T> list = Collections.singletonList(element);
        Intrinsics.checkNotNullExpressionValue(list, "singletonList(...)");
        return list;
    }

    @PublishedApi
    @SinceKotlin(version="1.3")
    @InlineOnly
    private static final <E> List<E> buildListInternal(Function1<? super List<E>, Unit> builderAction) {
        Function1<List<E>, Unit> function1;
        Intrinsics.checkNotNullParameter(builderAction, "builderAction");
        List<E> list = CollectionsKt.createListBuilder();
        function1.invoke(list);
        return CollectionsKt.build(list);
    }

    /*
     * WARNING - void declaration
     */
    @PublishedApi
    @SinceKotlin(version="1.3")
    @InlineOnly
    private static final <E> List<E> buildListInternal(int capacity, Function1<? super List<E>, Unit> builderAction) {
        void var1_2;
        int n;
        Intrinsics.checkNotNullParameter(builderAction, "builderAction");
        List<E> list = CollectionsKt.createListBuilder(n);
        var1_2.invoke(list);
        return CollectionsKt.build(list);
    }

    @PublishedApi
    @SinceKotlin(version="1.3")
    public static final <E> List<E> createListBuilder() {
        return new ListBuilder(0, 1, null);
    }

    @PublishedApi
    @SinceKotlin(version="1.3")
    public static final <E> List<E> createListBuilder(int capacity) {
        int n;
        return new ListBuilder(n);
    }

    @PublishedApi
    @SinceKotlin(version="1.3")
    public static final <E> List<E> build(List<E> builder) {
        List<E> list;
        Intrinsics.checkNotNullParameter(builder, "builder");
        return ((ListBuilder)list).build();
    }

    @InlineOnly
    private static final <T> List<T> toList(Enumeration<T> $this$toList) {
        Enumeration<T> enumeration;
        Intrinsics.checkNotNullParameter($this$toList, "<this>");
        ArrayList<T> arrayList = Collections.list(enumeration);
        Intrinsics.checkNotNullExpressionValue(arrayList, "list(...)");
        return arrayList;
    }

    @SinceKotlin(version="1.2")
    public static final <T> List<T> shuffled(Iterable<? extends T> $this$shuffled) {
        Iterable<? extends T> iterable;
        Intrinsics.checkNotNullParameter($this$shuffled, "<this>");
        iterable = CollectionsKt.toMutableList(iterable);
        List<T> list = iterable;
        Collections.shuffle(iterable);
        return iterable;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.2")
    public static final <T> List<T> shuffled(Iterable<? extends T> $this$shuffled, Random random) {
        void var1_1;
        Iterable<? extends T> iterable;
        Intrinsics.checkNotNullParameter($this$shuffled, "<this>");
        Intrinsics.checkNotNullParameter(random, "random");
        iterable = CollectionsKt.toMutableList(iterable);
        List<T> list = iterable;
        Collections.shuffle(iterable, (Random)var1_1);
        return iterable;
    }

    @InlineOnly
    private static final Object[] collectionToArray(Collection<?> collection) {
        Collection<?> collection2;
        Intrinsics.checkNotNullParameter(collection, "collection");
        return CollectionToArray.toArray(collection2);
    }

    /*
     * WARNING - void declaration
     */
    @InlineOnly
    private static final <T> T[] collectionToArray(Collection<?> collection, T[] array) {
        void var1_1;
        Collection<?> collection2;
        Intrinsics.checkNotNullParameter(collection, "collection");
        Intrinsics.checkNotNullParameter(array, "array");
        return CollectionToArray.toArray(collection2, (Object[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static final <T> T[] terminateCollectionToArray(int collectionSize, T[] array) {
        void var1_1;
        Intrinsics.checkNotNullParameter(array, "array");
        if (collectionSize < array.length) {
            array[var0] = null;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final <T> Object[] copyToArrayOfAny(T[] $this$copyToArrayOfAny, boolean isVarargs) {
        T[] TArray;
        void var1_1;
        Intrinsics.checkNotNullParameter($this$copyToArrayOfAny, "<this>");
        if (var1_1 != false && Intrinsics.areEqual($this$copyToArrayOfAny.getClass(), Object[].class)) {
            return $this$copyToArrayOfAny;
        }
        Object[] objectArray = Arrays.copyOf(TArray, TArray.length, Object[].class);
        Intrinsics.checkNotNullExpressionValue(objectArray, "copyOf(...)");
        return objectArray;
    }

    @PublishedApi
    @SinceKotlin(version="1.3")
    @InlineOnly
    private static final int checkIndexOverflow(int index) {
        int n;
        if (index < 0) {
            if (PlatformImplementationsKt.apiVersionIsAtLeast(1, 3, 0)) {
                CollectionsKt.throwIndexOverflow();
            } else {
                throw new ArithmeticException("Index overflow has happened.");
            }
        }
        return n;
    }

    @PublishedApi
    @SinceKotlin(version="1.3")
    @InlineOnly
    private static final int checkCountOverflow(int count) {
        int n;
        if (count < 0) {
            if (PlatformImplementationsKt.apiVersionIsAtLeast(1, 3, 0)) {
                CollectionsKt.throwCountOverflow();
            } else {
                throw new ArithmeticException("Count overflow has happened.");
            }
        }
        return n;
    }
}

