/*
 * Decompiled with CFR 0.152.
 */
package application.core.targets.discovery;

import application.core.icons.Icon;
import application.core.targets.DesktopTargetSpec;
import application.core.targets.LinkTarget;
import application.core.targets.discovery.DiscoveredTarget;
import application.core.targets.discovery.TargetDiscovery;
import application.core.targets.discovery.TargetDiscoveryResult;
import application.core.targets.discovery.WindowsTargetDiscoveryKt;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import shared.system.files.FilesKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0005\u001a\u00020\u0004H\u0096@\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0019\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\n\u0010\u000bR\u0018\u0010\r\u001a\u0006*\u00020\f0\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000e"}, d2={"Lapplication/core/targets/discovery/WindowsRegistryTargetDiscovery;", "Lapplication/core/targets/discovery/TargetDiscovery;", "<init>", "()V", "Lapplication/core/targets/discovery/TargetDiscoveryResult;", "discoverTargets", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "", "command", "Ljava/io/File;", "commandToExecutable", "(Ljava/lang/String;)Ljava/io/File;", "Ljava/util/regex/Pattern;", "commandPattern", "Ljava/util/regex/Pattern;"})
@SourceDebugExtension(value={"SMAP\nWindowsTargetDiscovery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsTargetDiscovery.kt\napplication/core/targets/discovery/WindowsRegistryTargetDiscovery\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,179:1\n1863#2:180\n1864#2:184\n13402#3:181\n13403#3:183\n1#4:182\n*S KotlinDebug\n*F\n+ 1 WindowsTargetDiscovery.kt\napplication/core/targets/discovery/WindowsRegistryTargetDiscovery\n*L\n50#1:180\n50#1:184\n54#1:181\n54#1:183\n*E\n"})
final class WindowsRegistryTargetDiscovery
extends TargetDiscovery {
    private final Pattern commandPattern = Pattern.compile("([^\"]\\S*|\".+?\")\\s*");

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object discoverTargets(Continuation<? super TargetDiscoveryResult> $completion) {
        void var2_2;
        void var1_1;
        List targets = new ArrayList();
        Set icons = new LinkedHashSet();
        Object[] objectArray = new WinReg.HKEY[2];
        Object object = objectArray;
        objectArray[0] = WinReg.HKEY_LOCAL_MACHINE;
        object[1] = WinReg.HKEY_CURRENT_USER;
        object = CollectionsKt.listOf((Object[])object);
        object = object.iterator();
        while (object.hasNext()) {
            String startMenuInternetKey;
            Object e = object.next();
            WinReg.HKEY root = (WinReg.HKEY)e;
            if (!Advapi32Util.registryKeyExists((WinReg.HKEY)root, (String)(startMenuInternetKey = "Software\\Clients\\StartMenuInternet"))) continue;
            String[] browserKeys = Advapi32Util.registryGetKeys((WinReg.HKEY)root, (String)startMenuInternetKey);
            Intrinsics.checkNotNull((Object)browserKeys);
            String[] $this$forEach$iv = browserKeys;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                byte[] bytes;
                String string;
                String browserKeyName = string = $this$forEach$iv[i];
                String browserKeyPath = startMenuInternetKey + "\\" + browserKeyName;
                WindowsTargetDiscoveryKt.access$getLogger$p().trace(() -> WindowsRegistryTargetDiscovery.discoverTargets$lambda$7$lambda$6$lambda$0(browserKeyPath));
                String browserName = Advapi32Util.registryGetStringValue((WinReg.HKEY)root, (String)browserKeyPath, (String)"");
                WindowsTargetDiscoveryKt.access$getLogger$p().trace(() -> WindowsRegistryTargetDiscovery.discoverTargets$lambda$7$lambda$6$lambda$1(browserName));
                String browserCommandKey = startMenuInternetKey + "\\" + browserKeyName + "\\shell\\open\\command";
                String command = Advapi32Util.registryGetStringValue((WinReg.HKEY)root, (String)browserCommandKey, (String)"");
                WindowsTargetDiscoveryKt.access$getLogger$p().trace(() -> WindowsRegistryTargetDiscovery.discoverTargets$lambda$7$lambda$6$lambda$2(command));
                Intrinsics.checkNotNull((Object)command);
                File executable = this.commandToExecutable(command);
                WindowsTargetDiscoveryKt.access$getLogger$p().trace(() -> WindowsRegistryTargetDiscovery.discoverTargets$lambda$7$lambda$6$lambda$3(executable));
                if (executable == null) continue;
                Icon icon = WindowsTargetDiscoveryKt.access$extractIconFrom(executable) != null ? new Icon(bytes, null, 2, null) : null;
                if (icon != null) {
                    Icon it;
                    it = it;
                    Boxing.boxBoolean((boolean)icons.add(it));
                }
                Intrinsics.checkNotNull((Object)browserName);
                Icon icon2 = icon;
                String string2 = icon2 != null ? icon2.getHash() : null;
                String string3 = executable.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getAbsolutePath(...)");
                targets.add(new DiscoveredTarget(new LinkTarget(null, browserName, string2, false, true, new DesktopTargetSpec(string3, null, null, null, 14, null), 9, null), MapsKt.mapOf((Pair)TuplesKt.to((Object)"AppFullName", (Object)browserName))));
            }
        }
        return new TargetDiscoveryResult((List<DiscoveredTarget>)var1_1, (Set<Icon>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private final File commandToExecutable(String command) {
        File file;
        try {
            File file2;
            Object object;
            Object matcher;
            if (StringsKt.startsWith$default((String)command, (String)"\"", (boolean)false, (int)2, null)) {
                matcher = this.commandPattern.matcher(command);
                object = CollectionsKt.createListBuilder();
                List $this$commandToExecutable_u24lambda_u248 = object;
                while (((Matcher)matcher).find()) {
                    String part = ((Matcher)matcher).group();
                    Intrinsics.checkNotNull((Object)part);
                    $this$commandToExecutable_u24lambda_u248.add(StringsKt.removeSurrounding((String)part, (CharSequence)"\""));
                }
                List parsedCommand = CollectionsKt.build((List)object);
                file2 = new File((String)CollectionsKt.first((List)object));
            } else {
                file2 = new File(command);
            }
            matcher = file2;
            object = file2;
            matcher = file2.exists() ? matcher : null;
            matcher = matcher != null ? FilesKt.getResolvedSymlink((File)matcher) : null;
        }
        catch (Exception ex) {
            void var1_1;
            void var2_3;
            WindowsTargetDiscoveryKt.access$getLogger$p().warn((Throwable)var2_3, () -> WindowsRegistryTargetDiscovery.commandToExecutable$lambda$10((String)var1_1));
            file = null;
        }
        return file;
    }

    private static final Object discoverTargets$lambda$7$lambda$6$lambda$0(String $browserKeyPath) {
        return "Potential browser at " + $browserKeyPath;
    }

    private static final Object discoverTargets$lambda$7$lambda$6$lambda$1(String $browserName) {
        return "Found browser name '" + $browserName + "'";
    }

    private static final Object discoverTargets$lambda$7$lambda$6$lambda$2(String $command) {
        return "Found browser command " + $command;
    }

    private static final Object discoverTargets$lambda$7$lambda$6$lambda$3(File $executable) {
        return "Found browser executable " + $executable;
    }

    private static final Object commandToExecutable$lambda$10(String $command) {
        return "Failed to turn registry command '" + $command + "' to executable, ignoring this target";
    }
}

