/*
 * Decompiled with CFR 0.152.
 */
package application.core.targets.discovery;

import application.core.icons.Icon;
import application.core.targets.DesktopTargetSpec;
import application.core.targets.LinkTarget;
import application.core.targets.discovery.DiscoveredTarget;
import application.core.targets.discovery.MacTargetDiscoveryKt;
import application.core.targets.discovery.TargetDiscovery;
import application.core.targets.discovery.TargetDiscoveryResult;
import com.dd.plist.NSArray;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import com.dd.plist.PropertyListParser;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.apache.commons.imaging.ImagingParameters;
import org.apache.commons.imaging.PixelDensity;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.formats.icns.IcnsImageParser;
import org.apache.commons.imaging.formats.icns.IcnsImagingParameters;
import org.apache.commons.io.build.AbstractOrigin;
import shared.system.files.FilesKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0005\u001a\u00020\u0004H\u0096@\u00a2\u0006\u0004\b\u0005\u0010\u0006"}, d2={"Lapplication/core/targets/discovery/MacAppsTargetDiscovery;", "Lapplication/core/targets/discovery/TargetDiscovery;", "<init>", "()V", "Lapplication/core/targets/discovery/TargetDiscoveryResult;", "discoverTargets", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion"})
@SourceDebugExtension(value={"SMAP\nMacTargetDiscovery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MacTargetDiscovery.kt\napplication/core/targets/discovery/MacAppsTargetDiscovery\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,142:1\n1557#2:143\n1628#2,3:144\n1611#2,9:147\n1863#2:156\n1864#2:158\n1620#2:159\n1755#2,3:167\n1#3:157\n1#3:160\n13402#4,2:161\n11158#4:163\n11493#4,3:164\n*S KotlinDebug\n*F\n+ 1 MacTargetDiscovery.kt\napplication/core/targets/discovery/MacAppsTargetDiscovery\n*L\n54#1:143\n54#1:144,3\n55#1:147,9\n55#1:156\n55#1:158\n55#1:159\n82#1:167,3\n55#1:157\n64#1:161,2\n81#1:163\n81#1:164,3\n*E\n"})
public final class MacAppsTargetDiscovery
extends TargetDiscovery {
    private static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object discoverTargets(Continuation<? super TargetDiscoveryResult> $completion) {
        Collection<DiscoveredTarget> collection;
        Set set;
        void $this$mapNotNull$iv;
        Collection<DiscoveredTarget> collection2;
        Iterator $this$mapTo$iv$iv;
        File userApplications = new File(System.getenv("HOME") + "/Applications");
        File systemApplications = new File("/Applications");
        Object[] objectArray = new File[2];
        Object object = objectArray;
        objectArray[0] = userApplications;
        object[1] = systemApplications;
        userApplications = SequencesKt.filter((Sequence)SequencesKt.sequenceOf((Object[])object), MacAppsTargetDiscovery::discoverTargets$lambda$0);
        userApplications = SequencesKt.distinct((Sequence)SequencesKt.flatMapIterable((Sequence)userApplications, MacAppsTargetDiscovery::findAppDirectories$lambda$9));
        userApplications = SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)userApplications, MacAppsTargetDiscovery::findValidBrowsersInfo$lambda$13), MacAppsTargetDiscovery::findValidBrowsersInfo$lambda$16);
        List<Object> discovered = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)userApplications, MacAppsTargetDiscovery::mapToValidTargets$lambda$29));
        Iterable $this$map$iv = discovered;
        object = $this$map$iv;
        Iterable<Set> destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $this$mapTo$iv$iv = $this$mapTo$iv$iv.iterator();
        while ($this$mapTo$iv$iv.hasNext()) {
            void it;
            Object item$iv$iv = $this$mapTo$iv$iv.next();
            item$iv$iv = (Pair)item$iv$iv;
            collection2 = destination$iv$iv;
            collection2.add((DiscoveredTarget)it.getFirst());
        }
        List list = (List)destination$iv$iv;
        destination$iv$iv = discovered;
        collection2 = list;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            Object t = iterator.next();
            discovered = t;
            discovered = t;
            discovered = (Pair)t;
            if ((Icon)discovered.getSecond() == null) continue;
            destination$iv$iv.add(set);
        }
        set = CollectionsKt.toSet((Iterable)((List)collection));
        collection = collection2;
        return new TargetDiscoveryResult((List<DiscoveredTarget>)collection, set);
    }

    private static final boolean discoverTargets$lambda$0(File it) {
        File file;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return file.isDirectory();
    }

    private static final boolean findAppDirectories$lambda$9$lambda$8$lambda$4(File it) {
        return it.isDirectory();
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean findAppDirectories$lambda$9$lambda$8$lambda$7$lambda$6(Set $found, File dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        String string = dir.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (StringsKt.endsWith$default((String)string, (String)".app", (boolean)false, (int)2, null)) {
            void var1_1;
            Set set;
            ((Collection)set).add(FilesKt.getResolvedSymlink((File)var1_1));
            return false;
        }
        return true;
    }

    private static final Iterable findAppDirectories$lambda$9(File applicationsDir) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)applicationsDir, (String)"applicationsDir");
        Set found = set = (Set)new LinkedHashSet();
        applicationsDir = applicationsDir.listFiles(MacAppsTargetDiscovery::findAppDirectories$lambda$9$lambda$8$lambda$4);
        if (applicationsDir != null) {
            File $this$forEach$iv;
            int n = ((File)$this$forEach$iv).length;
            for (int i = 0; i < n; ++i) {
                File file;
                File subDir = file = $this$forEach$iv[i];
                Intrinsics.checkNotNull((Object)file);
                SequencesKt.toList((Sequence)((Sequence)kotlin.io.FilesKt.walkTopDown((File)subDir).onEnter(arg_0 -> MacAppsTargetDiscovery.findAppDirectories$lambda$9$lambda$8$lambda$7$lambda$6(found, arg_0))));
            }
        }
        return set;
    }

    private static final Pair findValidBrowsersInfo$lambda$13(File appDir) {
        File file;
        Intrinsics.checkNotNullParameter((Object)appDir, (String)"appDir");
        File file2 = file = kotlin.io.FilesKt.resolve((File)kotlin.io.FilesKt.resolve((File)appDir, (String)"Contents"), (String)"Info.plist");
        if ((file = file.isFile() ? file : null) != null) {
            File file3 = file;
            file = file3;
            file = file3;
            file = PropertyListParser.parse((Path)file3.toPath());
            file = file instanceof NSDictionary ? (NSDictionary)file : null;
            if (file != null) {
                File file4;
                return TuplesKt.to((Object)file4, (Object)file);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean findValidBrowsersInfo$lambda$16(Pair object) {
        List list;
        String string;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)object, (String)"<destruct>");
        object = (NSDictionary)object.component2();
        object = object.get((Object)"NSUserActivityTypes");
        object = object instanceof NSArray ? (NSObject[])object : null;
        NSObject[] nSObjectArray = object;
        if (object != null && (nSObjectArray = nSObjectArray.getArray()) != null) {
            void $this$mapTo$iv$iv;
            NSObject[] $this$map$iv = nSObjectArray;
            object2 = nSObjectArray;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Collection collection = destination$iv$iv;
                collection.add((String)it.toJavaObject(String.class));
            }
            list = (List)((Object)string);
        } else {
            List $this$map$iv;
            list = $this$map$iv = null;
        }
        if (list != null) {
            boolean bl;
            Iterable $this$any$iv = list;
            if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) {
                Iterator iterator;
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    object2 = iterator.next();
                    string = (String)object2;
                    if (!StringsKt.equals((String)string, (String)"NSUserActivityTypeBrowsingWeb", (boolean)true)) continue;
                    bl = true;
                    break;
                }
            } else {
                bl = false;
            }
            return bl;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static final Object mapToValidTargets$lambda$29$lambda$28$lambda$27$lambda$18(String $targetName, File $appDir) {
        void var1_1;
        return "Found '" + $targetName + "' in " + (File)var1_1;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Pair mapToValidTargets$lambda$29(Pair object) {
        void var0_1;
        Object object2;
        void $this$mapToValidTargets_u24lambda_u2429_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426;
        LinkTarget linkTarget;
        DesktopTargetSpec desktopTargetSpec;
        Icon icon;
        Icon icon2;
        Object object3;
        Map bufferedImage;
        Object object4;
        File file;
        File $this$mapToValidTargets_u24lambda_u2429_u24lambda_u2428_u24lambda_u2427_u24lambda_u2422_u24lambda_u2421;
        Intrinsics.checkNotNullParameter((Object)object, (String)"<destruct>");
        Object appDir = (File)object.component1();
        NSDictionary infoDict = (NSDictionary)object.component2();
        NSObject nSObject = (NSObject)infoDict.get((Object)"CFBundleName");
        String bundleName = nSObject != null ? nSObject.toString() : null;
        NSObject nSObject2 = (NSObject)infoDict.get((Object)"CFBundleDisplayName");
        String bundleDisplayName = nSObject2 != null ? nSObject2.toString() : null;
        NSObject nSObject3 = (NSObject)infoDict.get((Object)"CFBundleExecutable");
        Object object5 = nSObject3;
        if (nSObject3 == null) return null;
        String string = object5.toString();
        object5 = string;
        if (string == null) return null;
        Object executableName = object5;
        String string2 = bundleDisplayName;
        if (string2 == null && (string2 = bundleName) == null) {
            string2 = executableName;
        }
        String targetName = string2;
        File contentsDir = kotlin.io.FilesKt.resolve((File)appDir, (String)"Contents");
        executableName = kotlin.io.FilesKt.resolve((File)kotlin.io.FilesKt.resolve((File)contentsDir, (String)"MacOS"), (String)executableName);
        File file2 = executableName;
        if (!((File)executableName).isFile()) return null;
        Object object6 = executableName;
        executableName = object6;
        if (object6 == null) return null;
        Object targetExecutable = executableName;
        MacTargetDiscoveryKt.access$getLogger$p().trace(() -> MacAppsTargetDiscovery.mapToValidTargets$lambda$29$lambda$28$lambda$27$lambda$18(targetName, (File)appDir));
        NSObject nSObject4 = (NSObject)infoDict.get((Object)"CFBundleIconFile");
        Object object7 = appDir = nSObject4 != null ? nSObject4.toString() : null;
        if (object7 != null) {
            iconFileName = object7;
            $this$mapToValidTargets_u24lambda_u2429_u24lambda_u2428_u24lambda_u2427_u24lambda_u2422_u24lambda_u2421 = kotlin.io.FilesKt.resolve((File)contentsDir, (String)"Resources");
            file = contentsDir = kotlin.io.FilesKt.resolve((File)$this$mapToValidTargets_u24lambda_u2429_u24lambda_u2428_u24lambda_u2427_u24lambda_u2422_u24lambda_u2421, (String)iconFileName);
            object4 = contentsDir.isFile() ? contentsDir : null;
            if (object4 == null) {
                file = contentsDir = kotlin.io.FilesKt.resolve((File)$this$mapToValidTargets_u24lambda_u2429_u24lambda_u2428_u24lambda_u2427_u24lambda_u2422_u24lambda_u2421, (String)(iconFileName + ".icns"));
                object4 = contentsDir.isFile() ? contentsDir : null;
            }
        } else {
            object4 = iconFileName = null;
        }
        if (object4 != null) {
            BufferedImage bufferedImage2;
            ImagingParameters $this$mapToValidTargets_u24lambda_u2429_u24lambda_u2428_u24lambda_u2427_u24lambda_u2424_u24lambda_u24242;
            File file3;
            File file4 = file3 = object4;
            contentsDir = file3 = new IcnsImagingParameters();
            file = file4;
            $this$mapToValidTargets_u24lambda_u2429_u24lambda_u2428_u24lambda_u2427_u24lambda_u2422_u24lambda_u2421 = new IcnsImageParser();
            $this$mapToValidTargets_u24lambda_u2429_u24lambda_u2428_u24lambda_u2427_u24lambda_u2424_u24lambda_u24242.setPixelDensity(PixelDensity.createUnitless((double)2.0, (double)2.0));
            File file5 = $this$mapToValidTargets_u24lambda_u2429_u24lambda_u2428_u24lambda_u2427_u24lambda_u2422_u24lambda_u2421;
            $this$mapToValidTargets_u24lambda_u2429_u24lambda_u2428_u24lambda_u2427_u24lambda_u2424_u24lambda_u24242 = (ImagingParameters)file3;
            $this$mapToValidTargets_u24lambda_u2429_u24lambda_u2428_u24lambda_u2427_u24lambda_u2422_u24lambda_u2421 = file;
            file3 = file5;
            File file6 = $this$mapToValidTargets_u24lambda_u2429_u24lambda_u2428_u24lambda_u2427_u24lambda_u2422_u24lambda_u2421;
            file = file5;
            if (!file5.canAcceptExtension(file6.getName())) {
                bufferedImage2 = null;
            } else {
                file = $this$mapToValidTargets_u24lambda_u2429_u24lambda_u2428_u24lambda_u2427_u24lambda_u2422_u24lambda_u2421;
                bufferedImage2 = file3.getBufferedImage(new ByteSource((AbstractOrigin)new AbstractOrigin.FileOrigin(file), file.getName()), $this$mapToValidTargets_u24lambda_u2429_u24lambda_u2428_u24lambda_u2427_u24lambda_u2424_u24lambda_u24242);
            }
            bufferedImage = bufferedImage2;
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            boolean $this$mapToValidTargets_u24lambda_u2429_u24lambda_u2428_u24lambda_u2427_u24lambda_u2424_u24lambda_u24242 = ImageIO.write((RenderedImage)((Object)bufferedImage), "png", output);
            if ($this$mapToValidTargets_u24lambda_u2429_u24lambda_u2428_u24lambda_u2427_u24lambda_u2424_u24lambda_u24242) {
                byte[] byArray = ((ByteArrayOutputStream)object3).toByteArray();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
                icon2 = new Icon(byArray, null, 2, null);
            } else {
                icon2 = null;
            }
        } else {
            icon2 = null;
        }
        Icon icon3 = icon = icon2;
        String string3 = icon3 != null ? icon3.getHash() : null;
        if (Intrinsics.areEqual((Object)bundleName, (Object)"Safari")) {
            Object[] objectArray = new String[2];
            object3 = objectArray;
            objectArray[0] = "-a";
            object3[1] = bundleName;
            DesktopTargetSpec desktopTargetSpec = new DesktopTargetSpec("/usr/bin/open", CollectionsKt.listOf((Object[])object3), CollectionsKt.listOf((Object)"-u"), null, 8, null);
            desktopTargetSpec = desktopTargetSpec;
        } else {
            String string4 = ((File)targetExecutable).getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getAbsolutePath(...)");
            desktopTargetSpec = new DesktopTargetSpec(string4, null, null, null, 14, null);
        }
        object3 = MapsKt.createMapBuilder();
        bufferedImage = object3;
        linkTarget = new LinkTarget(null, (String)((Object)linkTarget), string3, false, true, desktopTargetSpec, 9, null);
        if (bundleName != null) {
            void var2_4;
            $this$mapToValidTargets_u24lambda_u2429_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426.put("CFBundleName", var2_4);
        }
        if ((object2 = (NSObject)var0_1.get((Object)"CrProductDirName")) != null && (object2 = object2.toJavaObject()) != null && (object2 = object2.toString()) != null) {
            Object crProductDirName = object2;
            $this$mapToValidTargets_u24lambda_u2429_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426.put("CrProductDirName", crProductDirName);
        }
        Map map2 = MapsKt.build((Map)object3);
        object3 = linkTarget;
        object3 = new DiscoveredTarget((LinkTarget)object3, map2);
        Pair pair = TuplesKt.to((Object)object3, (Object)icon);
        return pair;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003"}, d2={"Lapplication/core/targets/discovery/MacAppsTargetDiscovery$Companion;", "", "<init>", "()V"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

