/*
 * Decompiled with CFR 0.152.
 */
package application.core.targets.discovery;

import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.io.File;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.Path;
import shared.system.process.DesktopSystemKt;

public final class LinuxTargetDiscoveryKt {
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(LinuxTargetDiscoveryKt::logger$lambda$0);
    private static final Lazy isConvertAvailable$delegate = LazyKt.lazy(LinuxTargetDiscoveryKt::isConvertAvailable_delegate$lambda$4);

    public static final File toResolvedLinuxBrowserExecutable(File $this$toResolvedLinuxBrowserExecutable) {
        File file;
        Intrinsics.checkNotNullParameter((Object)$this$toResolvedLinuxBrowserExecutable, (String)"<this>");
        String string = $this$toResolvedLinuxBrowserExecutable.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"snap", (boolean)false, (int)2, null)) {
            return $this$toResolvedLinuxBrowserExecutable;
        }
        return shared.system.files.FilesKt.getResolvedSymlink((File)file);
    }

    /*
     * WARNING - void declaration
     */
    private static final byte[] convertToPngBytes(File $this$convertToPngBytes, Path temporaryDirectory) {
        Object[] objectArray;
        File png = Path.resolve$default((Path)temporaryDirectory, (String)("svg2png/" + FilesKt.getNameWithoutExtension((File)$this$convertToPngBytes) + ".png"), (boolean)false, (int)2, null).toFile();
        if (png.isFile()) {
            return FilesKt.readBytes((File)png);
        }
        try {
            png.getParentFile().mkdirs();
            String[] stringArray = new String[9];
            objectArray = stringArray;
            stringArray[0] = "convert";
            objectArray[1] = "-background";
            objectArray[2] = "none";
            objectArray[3] = "-density";
            objectArray[4] = "2400";
            objectArray[5] = "-size";
            objectArray[6] = "512x512";
            objectArray[7] = $this$convertToPngBytes.getAbsolutePath();
            objectArray[8] = png.getAbsolutePath();
            DesktopSystemKt.systemCommandLineOutputOf((String[])objectArray, LinuxTargetDiscoveryKt::convertToPngBytes$lambda$1);
            objectArray = FilesKt.readBytes((File)png);
        }
        catch (Exception ex) {
            File file;
            void var1_2;
            logger.warn((Throwable)var1_2, () -> LinuxTargetDiscoveryKt.convertToPngBytes$lambda$2(file));
            objectArray = null;
        }
        return objectArray;
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Unit convertToPngBytes$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final Object convertToPngBytes$lambda$2(File $this_convertToPngBytes) {
        return "Unable to convert icon file to PNG: '" + $this_convertToPngBytes.getAbsolutePath() + "'";
    }

    private static final boolean isConvertAvailable_delegate$lambda$4$lambda$3(String it) {
        String string;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.contains$default((CharSequence)string, (CharSequence)"ImageMagick", (boolean)false, (int)2, null);
    }

    private static final boolean isConvertAvailable_delegate$lambda$4() {
        String[] stringArray = new String[2];
        String[] stringArray2 = stringArray;
        stringArray[0] = "convert";
        stringArray2[1] = "--version";
        return (Boolean)DesktopSystemKt.systemCommandLineOutputOf((String[])stringArray2, LinuxTargetDiscoveryKt::isConvertAvailable_delegate$lambda$4$lambda$3);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ byte[] access$readPngBytes(File $receiver, Path temporaryDirectory) {
        File file = $receiver;
        if (Intrinsics.areEqual((Object)FilesKt.getExtension((File)file), (Object)"png")) {
            return FilesKt.readBytes((File)file);
        }
        Lazy lazy = isConvertAvailable$delegate;
        if (((Boolean)lazy.getValue()).booleanValue()) {
            void var1_1;
            return LinuxTargetDiscoveryKt.convertToPngBytes(file, (Path)var1_1);
        }
        return null;
    }
}

