/*
 * Decompiled with CFR 0.152.
 */
package application.core.targets;

import application.core.targets.IShellItemImageFactory;
import application.core.targets.SIZEByValue;
import application.core.targets.Shell32Extra;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.GDI32;
import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.Ole32;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinGDI;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.PointerByReference;
import java.awt.image.BufferedImage;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ'\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\r\u0010\u000e"}, d2={"Lapplication/core/targets/WindowsIconExtractor;", "", "<init>", "()V", "", "width", "height", "", "fileName", "Ljava/awt/image/BufferedImage;", "getIconForFile", "(IILjava/lang/String;)Ljava/awt/image/BufferedImage;", "Lcom/sun/jna/platform/win32/WinDef$HBITMAP;", "getHBITMAPForFile", "(IILjava/lang/String;)Lcom/sun/jna/platform/win32/WinDef$HBITMAP;"})
public final class WindowsIconExtractor {
    public static final WindowsIconExtractor INSTANCE = new WindowsIconExtractor();

    private WindowsIconExtractor() {
    }

    /*
     * WARNING - void declaration
     */
    public final BufferedImage getIconForFile(int width, int height, String fileName2) {
        WinDef.HBITMAP hbitmap;
        block4: {
            BufferedImage bufferedImage;
            Intrinsics.checkNotNullParameter((Object)fileName2, (String)"fileName");
            hbitmap = this.getHBITMAPForFile(width, height, fileName2);
            WinGDI.BITMAP bitmap = new WinGDI.BITMAP();
            try {
                void var3_8;
                void var2_5;
                int fileName2 = GDI32.INSTANCE.GetObject((WinNT.HANDLE)hbitmap, bitmap.size(), bitmap.getPointer());
                if (fileName2 <= 0) break block4;
                bitmap.read();
                int w = bitmap.bmWidth.intValue();
                int h = bitmap.bmHeight.intValue();
                Object hdc = User32.INSTANCE.GetDC(null);
                Object bitmapinfo = new WinGDI.BITMAPINFO();
                new WinGDI.BITMAPINFO().bmiHeader.biSize = ((WinGDI.BITMAPINFO)bitmapinfo).bmiHeader.size();
                if (!(GDI32.INSTANCE.GetDIBits((WinDef.HDC)hdc, hbitmap, 0, 0, Pointer.NULL, (WinGDI.BITMAPINFO)bitmapinfo, 0) != 0)) {
                    hdc = "GetDIBits should not return 0";
                    throw new IllegalArgumentException(hdc.toString());
                }
                bitmapinfo.read();
                Memory lpPixels = new Memory((long)((WinGDI.BITMAPINFO)bitmapinfo).bmiHeader.biSizeImage);
                ((WinGDI.BITMAPINFO)bitmapinfo).bmiHeader.biCompression = 0;
                ((WinGDI.BITMAPINFO)bitmapinfo).bmiHeader.biHeight = -h;
                if (!(GDI32.INSTANCE.GetDIBits((WinDef.HDC)hdc, hbitmap, 0, ((WinGDI.BITMAPINFO)bitmapinfo).bmiHeader.biHeight, (Pointer)lpPixels, (WinGDI.BITMAPINFO)bitmapinfo, 0) != 0)) {
                    bitmapinfo = "GetDIBits should not return 0";
                    throw new IllegalArgumentException(bitmapinfo.toString());
                }
                int[] nArray = lpPixels.getIntArray(0L, w * h);
                Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getIntArray(...)");
                int[] colorArray = nArray;
                BufferedImage bi = new BufferedImage(w, h, 2);
                bi.setRGB(0, 0, w, (int)var2_5, colorArray, 0, (int)var3_8);
                bufferedImage = bi;
            }
            catch (Throwable throwable) {
                void var1_2;
                GDI32.INSTANCE.DeleteObject((WinNT.HANDLE)var1_2);
                throw throwable;
            }
            GDI32.INSTANCE.DeleteObject((WinNT.HANDLE)hbitmap);
            return bufferedImage;
        }
        GDI32.INSTANCE.DeleteObject((WinNT.HANDLE)hbitmap);
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final WinDef.HBITMAP getHBITMAPForFile(int width, int height, String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        WinNT.HRESULT hRESULT = Ole32.INSTANCE.CoInitialize(null);
        if (COMUtils.SUCCEEDED((WinNT.HRESULT)hRESULT)) {
            PointerByReference factory = new PointerByReference();
            fileName = Shell32Extra.Companion.getINSTANCE().SHCreateItemFromParsingName(new WString(fileName), null, new Guid.REFIID(new Guid.IID("BCC18B79-BA16-442F-80C4-8A59C30C463B")), factory);
            if (COMUtils.SUCCEEDED((WinNT.HRESULT)fileName)) {
                void var3_4;
                void var2_3;
                void var1_1;
                Pointer pointer = factory.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"getValue(...)");
                IShellItemImageFactory imageFactory = new IShellItemImageFactory(pointer);
                PointerByReference hbitmapPointer = new PointerByReference();
                WinNT.HRESULT hRESULT2 = imageFactory.GetImage(new SIZEByValue((int)var1_1, (int)var2_3), 0, hbitmapPointer);
                if (COMUtils.SUCCEEDED((WinNT.HRESULT)hRESULT2)) {
                    hRESULT2 = new WinDef.HBITMAP(hbitmapPointer.getValue());
                    return hRESULT2;
                }
                var3_4.Release();
            }
        }
        return null;
    }
}

