/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.platform.a11y;

import androidx.collection.MutableScatterMap;
import androidx.collection.ScatterMap;
import androidx.collection.ScatterMapKt;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.platform.PlatformComponent;
import androidx.compose.ui.platform.a11y.AccessibilityController;
import androidx.compose.ui.platform.a11y.ComposeAccessible;
import androidx.compose.ui.semantics.ProgressBarRangeInfo;
import androidx.compose.ui.semantics.SemanticsConfigurationKt;
import androidx.compose.ui.semantics.SemanticsNode;
import androidx.compose.ui.semantics.SemanticsOwner;
import androidx.compose.ui.semantics.SemanticsProperties;
import androidx.compose.ui.semantics.SemanticsPropertyKey;
import androidx.compose.ui.state.ToggleableState;
import androidx.compose.ui.text.TextRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.accessibility.AccessibleState;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;

@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nAccessibilityController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AccessibilityController.kt\nandroidx/compose/ui/platform/a11y/AccessibilityController\n+ 2 ScatterMap.kt\nandroidx/collection/ScatterMap\n+ 3 ScatterMap.kt\nandroidx/collection/ScatterMapKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,419:1\n391#2,4:420\n363#2,6:424\n373#2,3:431\n376#2,2:435\n396#2,2:437\n379#2,6:439\n398#2:445\n1810#3:430\n1672#3:434\n1#4:446\n*S KotlinDebug\n*F\n+ 1 AccessibilityController.kt\nandroidx/compose/ui/platform/a11y/AccessibilityController\n*L\n264#1:420,4\n264#1:424,6\n264#1:431,3\n264#1:435,2\n264#1:437,2\n264#1:439,6\n264#1:445\n264#1:430\n264#1:434\n*E\n"})
public final class AccessibilityController {
    private final SemanticsOwner owner;
    private final PlatformComponent desktopComponent;
    private final Function1<ComposeAccessible, Unit> onFocusReceived;
    private MutableScatterMap<Integer, ComposeAccessible> accessibleByNodeId;
    private boolean nodeMappingIsValid;
    private final Channel<Unit> nodeSyncChannel;
    private final ArrayDeque<SemanticsNode> bfsDeque;
    private MutableScatterMap<Integer, ComposeAccessible> auxAccessibleByNodeId;
    private final List<Function0<Unit>> delayedNodeNotifications;
    private Job syncingJob;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public AccessibilityController(SemanticsOwner owner2, PlatformComponent desktopComponent, Function1<? super ComposeAccessible, Unit> onFocusReceived) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)owner2, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)desktopComponent, (String)"desktopComponent");
        Intrinsics.checkNotNullParameter(onFocusReceived, (String)"onFocusReceived");
        this.owner = var1_1;
        this.desktopComponent = var2_2;
        this.onFocusReceived = var3_3;
        this.accessibleByNodeId = ScatterMapKt.mutableScatterMapOf();
        this.nodeSyncChannel = ChannelKt.Channel$default$46bdd92((int)0, null, null, (int)6);
        this.bfsDeque = new ArrayDeque();
        this.auxAccessibleByNodeId = ScatterMapKt.mutableScatterMapOf();
        this.delayedNodeNotifications = new ArrayList();
    }

    public final PlatformComponent getDesktopComponent() {
        return this.desktopComponent;
    }

    /*
     * WARNING - void declaration
     */
    public final ComposeAccessible accessibleByNodeId(int nodeId) {
        void var1_1;
        if (!this.nodeMappingIsValid) {
            this.syncNodes();
        }
        return (ComposeAccessible)this.accessibleByNodeId.get((Object)((int)var1_1));
    }

    public final void dispose() {
        Job job2 = this.syncingJob;
        if (job2 != null) {
            Object var1_1 = null;
            boolean bl = true;
            Job job3 = null;
            job3 = job2;
            job2.cancel(null);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void launchSyncLoop(CoroutineContext context2) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (this.syncingJob != null) {
            throw new IllegalStateException("Sync loop already running");
        }
        this.syncingJob = BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)var1_1), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ AccessibilityController this$0;
            {
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                super(2, (Continuation)var2_2);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        if (AccessibilityUsage.INSTANCE.runActiveController(this.this$0, (Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new Function1<Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ AccessibilityController this$0;
                            {
                                void var2_2;
                                void var1_1;
                                this.this$0 = var1_1;
                                super(1, (Continuation)var2_2);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object var1_1) {
                                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)var1_1);
lbl5:
                                        // 2 sources

                                        while (true) {
                                            this.label = 1;
                                            if (AccessibilityController.access$getNodeSyncChannel$p(this.this$0).receive((Continuation)this) == var2_2) {
                                                return var2_2;
                                            }
                                            ** GOTO lbl12
                                            break;
                                        }
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)var1_1);
lbl12:
                                        // 2 sources

                                        AccessibilityController.access$syncNodes(this.this$0);
                                        ** continue;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Continuation<Unit> create(Continuation<?> $completion) {
                                void var1_1;
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }
                        }), (Continuation<? super Unit>)((Continuation)this)) != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)object);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            /*
             * WARNING - void declaration
             */
            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                void var2_2;
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }
        }), (int)3, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void syncNodes() {
        void var2_2;
        AccessibilityController accessibilityController;
        MutableScatterMap<Integer, ComposeAccessible> previous = this.accessibleByNodeId;
        MutableScatterMap<Integer, ComposeAccessible> updated = this.auxAccessibleByNodeId;
        Object object = this;
        if (AccessibilityController.syncNodes$isValid(((AccessibilityController)object).owner.getRootSemanticsNode())) {
            object = this;
            this.bfsDeque.add((Object)((AccessibilityController)object).owner.getRootSemanticsNode());
        }
        while (!((Collection)this.bfsDeque).isEmpty()) {
            ComposeAccessible composeAccessible;
            SemanticsNode node = (SemanticsNode)this.bfsDeque.removeFirst();
            ComposeAccessible composeAccessible2 = (ComposeAccessible)previous.get((Object)node.getId());
            Integer n = node.getId();
            if (composeAccessible2 != null) {
                SemanticsNode prevSemanticsNode = composeAccessible2.getSemanticsNode();
                composeAccessible2.setSemanticsNode(node);
                this.delayedNodeNotifications.add(new Function0<Unit>(this, composeAccessible2, prevSemanticsNode, node){
                    final /* synthetic */ AccessibilityController this$0;
                    final /* synthetic */ ComposeAccessible $existingAccessible;
                    final /* synthetic */ SemanticsNode $prevSemanticsNode;
                    final /* synthetic */ SemanticsNode $node;
                    {
                        void var3_3;
                        void var2_2;
                        void var1_1;
                        this.this$0 = var1_1;
                        this.$existingAccessible = var2_2;
                        this.$prevSemanticsNode = var3_3;
                        this.$node = $node;
                        super(0);
                    }

                    public final void invoke() {
                        AccessibilityController.access$onNodeChanged(this.this$0, this.$existingAccessible, this.$prevSemanticsNode, this.$node);
                    }
                });
                composeAccessible = composeAccessible2;
            } else {
                ComposeAccessible newAccessible = new ComposeAccessible(node, this);
                this.delayedNodeNotifications.add(new Function0<Unit>(this, newAccessible){
                    final /* synthetic */ AccessibilityController this$0;
                    final /* synthetic */ ComposeAccessible $newAccessible;
                    {
                        void var2_2;
                        void var1_1;
                        this.this$0 = var1_1;
                        this.$newAccessible = var2_2;
                        super(0);
                    }

                    public final void invoke() {
                        AccessibilityController.access$onNodeAdded(this.this$0, this.$newAccessible);
                    }
                });
                composeAccessible = newAccessible;
            }
            updated.set((Object)n, (Object)composeAccessible);
            for (SemanticsNode semanticsNode : CollectionsKt.asReversed(node.getReplacedChildren$ui())) {
                if (!AccessibilityController.syncNodes$isValid(semanticsNode)) continue;
                this.bfsDeque.add((Object)semanticsNode);
            }
        }
        ScatterMap this_$iv = (ScatterMap)previous;
        Object[] k$iv = this_$iv.keys;
        Object[] objectArray = this_$iv.values;
        long[] m$iv$iv = this_$iv.metadata;
        int lastIndex$iv$iv = this_$iv.metadata.length - 2;
        int i$iv$iv = 0;
        if (lastIndex$iv$iv >= 0) {
            while (true) {
                long $this$maskEmptyOrDeleted$iv$iv$iv;
                long slot$iv$iv;
                if ((slot$iv$iv & (($this$maskEmptyOrDeleted$iv$iv$iv = (slot$iv$iv = m$iv$iv[i$iv$iv])) ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                    int bitCount$iv$iv = 8 - (~(i$iv$iv - lastIndex$iv$iv) >>> 31);
                    for (int j$iv$iv = 0; j$iv$iv < bitCount$iv$iv; ++j$iv$iv) {
                        long l = slot$iv$iv & 0xFFL;
                        if (l < 128L) {
                            int n;
                            int index$iv232 = n = (i$iv$iv << 3) + j$iv$iv;
                            ComposeAccessible index$iv232 = (ComposeAccessible)objectArray[index$iv232];
                            int id = ((Number)k$iv[index$iv232]).intValue();
                            if (!updated.contains((Object)id)) {
                                void node;
                                this.delayedNodeNotifications.add(new Function0<Unit>(this, (ComposeAccessible)node){
                                    final /* synthetic */ AccessibilityController this$0;
                                    final /* synthetic */ ComposeAccessible $node;
                                    {
                                        void var2_2;
                                        void var1_1;
                                        this.this$0 = var1_1;
                                        this.$node = var2_2;
                                        super(0);
                                    }

                                    public final void invoke() {
                                        AccessibilityController.access$onNodeRemoved(this.this$0, this.$node);
                                    }
                                });
                            }
                        }
                        slot$iv$iv >>= 8;
                    }
                    if (bitCount$iv$iv != 8) break;
                }
                if (i$iv$iv == lastIndex$iv$iv) break;
                ++i$iv$iv;
            }
        }
        object = accessibilityController;
        void var4_8 = object;
        accessibilityController = this;
        var4_8.clear();
        accessibilityController.auxAccessibleByNodeId = object;
        this.accessibleByNodeId = var2_2;
        this.nodeMappingIsValid = true;
        for (Function0 function0 : this.delayedNodeNotifications) {
            function0.invoke();
        }
        this.delayedNodeNotifications.clear();
    }

    private final void scheduleNodeSyncIfNeeded() {
        if (AccessibilityUsage.INSTANCE.getRecentlyUsed() && !this.nodeMappingIsValid) {
            this.nodeSyncChannel.trySend-JP2dKIU((Object)Unit.INSTANCE);
        }
    }

    public final void onSemanticsChange() {
        this.nodeMappingIsValid = false;
        this.scheduleNodeSyncIfNeeded();
    }

    public final void onLayoutChanged$13462e() {
        this.nodeMappingIsValid = false;
        this.scheduleNodeSyncIfNeeded();
    }

    public final ComposeAccessible getRootAccessible() {
        AccessibilityController accessibilityController = this;
        ComposeAccessible composeAccessible = accessibilityController.accessibleByNodeId(accessibilityController.owner.getRootSemanticsNode().getId());
        Intrinsics.checkNotNull((Object)composeAccessible);
        return composeAccessible;
    }

    private static final boolean syncNodes$isValid(SemanticsNode $this$syncNodes_u24isValid) {
        LayoutNode layoutNode;
        LayoutNode it = $this$syncNodes_u24isValid.getLayoutNode$ui();
        return it.isPlaced() && layoutNode.isAttached();
    }

    public static final /* synthetic */ Channel access$getNodeSyncChannel$p(AccessibilityController $this) {
        return $this.nodeSyncChannel;
    }

    public static final /* synthetic */ void access$syncNodes(AccessibilityController $this) {
        $this.syncNodes();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$onNodeChanged(AccessibilityController $this, ComposeAccessible component, SemanticsNode previousSemanticsNode, SemanticsNode newSemanticsNode) {
        Iterator<Map.Entry<SemanticsPropertyKey<?>, Object>> iterator2;
        AccessibilityController accessibilityController = $this;
        for (Object object : ((SemanticsNode)((Object)iterator2)).getConfig()) {
            void var1_1;
            void var2_2;
            Object obj = SemanticsConfigurationKt.getOrNull(var2_2.getConfig(), object.getKey());
            if (Intrinsics.areEqual((Object)object.getValue(), obj)) continue;
            SemanticsPropertyKey<?> semanticsPropertyKey = object.getKey();
            if (Intrinsics.areEqual(semanticsPropertyKey, SemanticsProperties.INSTANCE.getText())) {
                var1_1.getComposeAccessibleContext().firePropertyChange("AccessibleText", obj, object.getValue());
                continue;
            }
            if (Intrinsics.areEqual(semanticsPropertyKey, SemanticsProperties.INSTANCE.getEditableText())) {
                var1_1.getComposeAccessibleContext().firePropertyChange("AccessibleText", obj, object.getValue());
                continue;
            }
            if (Intrinsics.areEqual(semanticsPropertyKey, SemanticsProperties.INSTANCE.getTextSelectionRange())) {
                ComposeAccessible.ComposeAccessibleComponent composeAccessibleComponent = var1_1.getComposeAccessibleContext();
                Object object2 = object.getValue();
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type androidx.compose.ui.text.TextRange");
                composeAccessibleComponent.firePropertyChange("AccessibleCaret", obj, TextRange.getStart-impl((long)((TextRange)object2).unbox-impl()));
                continue;
            }
            if (Intrinsics.areEqual(semanticsPropertyKey, SemanticsProperties.INSTANCE.getFocused())) {
                Object object3 = object.getValue();
                Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.Boolean");
                if (((Boolean)object3).booleanValue()) {
                    var1_1.getComposeAccessibleContext().firePropertyChange("AccessibleState", null, AccessibleState.FOCUSED);
                    accessibilityController.onFocusReceived.invoke((Object)var1_1);
                    continue;
                }
                var1_1.getComposeAccessibleContext().firePropertyChange("AccessibleState", AccessibleState.FOCUSED, null);
                continue;
            }
            if (Intrinsics.areEqual(semanticsPropertyKey, SemanticsProperties.INSTANCE.getToggleableState())) {
                Object object4 = object.getValue();
                Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type androidx.compose.ui.state.ToggleableState");
                switch (WhenMappings.$EnumSwitchMapping$0[((ToggleableState)((Object)object4)).ordinal()]) {
                    case 1: {
                        var1_1.getComposeAccessibleContext().firePropertyChange("AccessibleState", null, AccessibleState.CHECKED);
                        break;
                    }
                    case 2: 
                    case 3: {
                        var1_1.getComposeAccessibleContext().firePropertyChange("AccessibleState", AccessibleState.CHECKED, null);
                    }
                }
                continue;
            }
            if (!Intrinsics.areEqual(semanticsPropertyKey, SemanticsProperties.INSTANCE.getProgressBarRangeInfo())) continue;
            Object object5 = object.getValue();
            Intrinsics.checkNotNull((Object)object5, (String)"null cannot be cast to non-null type androidx.compose.ui.semantics.ProgressBarRangeInfo");
            object = (ProgressBarRangeInfo)object5;
            var1_1.getComposeAccessibleContext().firePropertyChange("AccessibleValue", obj, Float.valueOf(((ProgressBarRangeInfo)object).getCurrent()));
        }
    }

    public static final /* synthetic */ void access$onNodeAdded(AccessibilityController $this, ComposeAccessible accessible2) {
    }

    public static final /* synthetic */ void access$onNodeRemoved(AccessibilityController $this, ComposeAccessible accessible2) {
        ComposeAccessible composeAccessible = accessible2;
        composeAccessible.setRemoved(true);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J6\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u001c\u0010\n\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\t\u0012\u0006\u0012\u0004\u0018\u00010\u00010\bH\u0086@\u00a2\u0006\u0004\b\u000b\u0010\fR\u0014\u0010\u000e\u001a\u00020\r8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u00108\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\u00020\r8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u000fR\u0011\u0010\u0017\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016"}, d2={"Landroidx/compose/ui/platform/a11y/AccessibilityController$AccessibilityUsage;", "", "<init>", "()V", "", "notifyInUse", "Landroidx/compose/ui/platform/a11y/AccessibilityController;", "controller", "Lkotlin/Function1;", "Lkotlin/coroutines/Continuation;", "block", "runActiveController", "(Landroidx/compose/ui/platform/a11y/AccessibilityController;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "", "MaxIdleTimeNanos", "J", "", "activeControllers", "Ljava/util/Set;", "lastUseTimeNanos", "", "getRecentlyUsed", "()Z", "recentlyUsed"})
    @StabilityInferred(parameters=0)
    public static final class AccessibilityUsage {
        public static final AccessibilityUsage INSTANCE = new AccessibilityUsage();
        private static final long MaxIdleTimeNanos = Duration.getInWholeNanoseconds-impl((long)DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.MINUTES));
        private static final Set<AccessibilityController> activeControllers = new LinkedHashSet();
        private static long lastUseTimeNanos = System.nanoTime() - (MaxIdleTimeNanos + 1L);
        public static final int $stable = 8;

        private AccessibilityUsage() {
        }

        public static void notifyInUse() {
            lastUseTimeNanos = System.nanoTime();
            for (AccessibilityController accessibilityController : activeControllers) {
                accessibilityController.scheduleNodeSyncIfNeeded();
            }
        }

        public static boolean getRecentlyUsed() {
            return System.nanoTime() - lastUseTimeNanos < MaxIdleTimeNanos;
        }

        /*
         * Unable to fully structure code
         */
        public final Object runActiveController(AccessibilityController var1_1, Function1<? super Continuation<? super Unit>, ? extends Object> var2_2, Continuation<? super Unit> var3_4) {
            if (!(var3_4 instanceof runActiveController.1)) ** GOTO lbl-1000
            var4_5 = var3_4;
            if ((var4_5.label & -2147483648) != 0) {
                var4_5.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var3_4){
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ AccessibilityUsage this$0;
                    int label;
                    {
                        void var2_2;
                        void var1_1;
                        this.this$0 = var1_1;
                        super((Continuation)var2_2);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final Object invokeSuspend(Object $result) {
                        void var1_1;
                        this.result = var1_1;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.runActiveController(null, null, (Continuation<? super Unit>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var5_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    AccessibilityUsage.activeControllers.add(controller);
                    $continuation.L$0 = controller;
                    $continuation.label = 1;
                    if (var2_2.invoke((Object)$continuation) == var5_6) {
                        return var5_6;
                    }
                }
                case 1: {
                    controller = (AccessibilityController)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure(var3_4);
                    }
                    catch (Throwable var2_3) {
                        AccessibilityUsage.activeControllers.remove(var1_1);
                        throw var2_3;
                    }
                    AccessibilityUsage.activeControllers.remove(controller);
                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ToggleableState.values().length];
            try {
                nArray[ToggleableState.On.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ToggleableState.Off.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ToggleableState.Indeterminate.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

