/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.platform;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.platform.DesktopPlatformInput_desktopKt;
import androidx.compose.ui.platform.PlatformComponent;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextRangeKt;
import androidx.compose.ui.text.input.CommitTextCommand;
import androidx.compose.ui.text.input.DeleteSurroundingTextInCodePointsCommand;
import androidx.compose.ui.text.input.EditCommand;
import androidx.compose.ui.text.input.ImeAction;
import androidx.compose.ui.text.input.ImeOptions;
import androidx.compose.ui.text.input.PlatformTextInputService;
import androidx.compose.ui.text.input.SetComposingTextCommand;
import androidx.compose.ui.text.input.TextFieldValue;
import java.awt.Rectangle;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodRequests;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;

@StabilityInferred(parameters=0)
public final class DesktopTextInputService
implements PlatformTextInputService {
    private final PlatformComponent component;
    private CurrentInput currentInput;
    private boolean charKeyPressed;
    private boolean needToDeletePreviousChar;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public DesktopTextInputService(PlatformComponent component) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this.component = var1_1;
    }

    public final boolean getCharKeyPressed() {
        return this.charKeyPressed;
    }

    public final void setNeedToDeletePreviousChar(boolean bl) {
        this.needToDeletePreviousChar = true;
    }

    /*
     * WARNING - void declaration
     */
    public final void startInput(TextFieldValue value, ImeOptions imeOptions, Function1<? super List<? extends EditCommand>, Unit> onEditCommand, Function1<? super ImeAction, Unit> onImeActionPerformed) {
        DesktopTextInputService desktopTextInputService;
        void var2_2;
        void var3_3;
        CurrentInput input;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)imeOptions, (String)"imeOptions");
        Intrinsics.checkNotNullParameter(onEditCommand, (String)"onEditCommand");
        Intrinsics.checkNotNullParameter(onImeActionPerformed, (String)"onImeActionPerformed");
        this.currentInput = input = new CurrentInput(value, (Function1)var3_3, onImeActionPerformed, var2_2.getImeAction-eUduSuo(), null, 16, null);
        var2_2 = desktopTextInputService;
        desktopTextInputService = this;
        this.component.enableInput(new InputMethodRequests((CurrentInput)var2_2, desktopTextInputService){
            final /* synthetic */ CurrentInput $input;
            final /* synthetic */ DesktopTextInputService this$0;
            {
                void var2_2;
                void var1_1;
                this.$input = var1_1;
                this.this$0 = var2_2;
            }

            public final TextHitInfo getLocationOffset(int x, int y) {
                if (this.$input.getValue().getComposition-MzsxiRA() != null) {
                    return TextHitInfo.leading(0);
                }
                return null;
            }

            public final AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributes) {
                return null;
            }

            /*
             * WARNING - void declaration
             */
            public final int getInsertPositionOffset() {
                void var1_1;
                void var2_2;
                void var3_3;
                TextRange textRange = this.$input.getValue().getComposition-MzsxiRA();
                int composedStartIndex = textRange != null ? TextRange.getStart-impl((long)textRange.unbox-impl()) : 0;
                TextRange textRange2 = this.$input.getValue().getComposition-MzsxiRA();
                int composedEndIndex = textRange2 != null ? TextRange.getEnd-impl((long)textRange2.unbox-impl()) : 0;
                int caretIndex = TextRange.getStart-impl((long)this.$input.getValue().getSelection-d9O1mEE());
                if (caretIndex < composedStartIndex) {
                    return caretIndex;
                }
                if (caretIndex < composedEndIndex) {
                    return composedStartIndex;
                }
                return (int)(var3_3 - (var2_2 - var1_1));
            }

            public final int getCommittedTextLength() {
                TextRange textRange = this.$input.getValue().getComposition-MzsxiRA();
                return this.$input.getValue().getText().length() - (textRange != null ? TextRange.getLength-impl((long)textRange.unbox-impl()) : 0);
            }

            /*
             * WARNING - void declaration
             */
            public final AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributes) {
                void var1_1;
                if (this.this$0.getCharKeyPressed()) {
                    this.this$0.setNeedToDeletePreviousChar(true);
                }
                String str = TextRangeKt.substring-FDrldGo((CharSequence)this.$input.getValue().getText(), (long)this.$input.getValue().getSelection-d9O1mEE());
                AttributedCharacterIterator attributedCharacterIterator = new AttributedString((String)var1_1).getIterator();
                Intrinsics.checkNotNullExpressionValue((Object)attributedCharacterIterator, (String)"getIterator(...)");
                return attributedCharacterIterator;
            }

            /*
             * WARNING - void declaration
             */
            public final Rectangle getTextLocation(TextHitInfo offset) {
                Rect rect = this.$input.getFocusedRect();
                if (rect != null) {
                    void var1_1;
                    void var2_3;
                    void var3_4;
                    offset = rect;
                    DesktopTextInputService desktopTextInputService = this.this$0;
                    TextHitInfo it = offset;
                    int x = (int)(it.getRight() / DesktopTextInputService.access$getComponent$p(desktopTextInputService).getDensity().getDensity()) + DesktopTextInputService.access$getComponent$p((DesktopTextInputService)desktopTextInputService).getLocationOnScreen().x;
                    int y = (int)(it.getTop() / DesktopTextInputService.access$getComponent$p(desktopTextInputService).getDensity().getDensity()) + DesktopTextInputService.access$getComponent$p((DesktopTextInputService)desktopTextInputService).getLocationOnScreen().y;
                    return new Rectangle((int)var3_4, (int)var2_3, (int)it.getWidth(), (int)var1_1.getHeight());
                }
                return null;
            }

            /*
             * WARNING - void declaration
             */
            public final AttributedCharacterIterator getCommittedText(int beginIndex, int endIndex, AttributedCharacterIterator.Attribute[] attributes) {
                void var1_3;
                void var3_5;
                void var2_4;
                TextRange comp = this.$input.getValue().getComposition-MzsxiRA();
                String text = this.$input.getValue().getText();
                long range = TextRangeKt.TextRange((int)RangesKt.coerceAtMost((int)beginIndex, (int)text.length()), (int)RangesKt.coerceAtMost((int)var2_4, (int)text.length()));
                if (comp == null) {
                    String res = TextRangeKt.substring-FDrldGo((CharSequence)text, (long)range);
                    AttributedCharacterIterator attributedCharacterIterator = new AttributedString(res).getIterator();
                    Intrinsics.checkNotNullExpressionValue((Object)attributedCharacterIterator, (String)"getIterator(...)");
                    return attributedCharacterIterator;
                }
                String committed = TextRangeKt.substring-FDrldGo((CharSequence)text, (long)TextRangeKt.TextRange((int)RangesKt.coerceAtMost((int)Math.min(TextRange.getMin-impl((long)range), TextRange.getMin-impl((long)comp.unbox-impl())), (int)text.length()), (int)RangesKt.coerceAtMost((int)Math.max(TextRange.getMax-impl((long)range), TextRange.getMax-impl((long)var3_5.unbox-impl())), (int)text.length())));
                AttributedCharacterIterator attributedCharacterIterator = new AttributedString((String)var1_3).getIterator();
                Intrinsics.checkNotNullExpressionValue((Object)attributedCharacterIterator, (String)"getIterator(...)");
                return attributedCharacterIterator;
            }
        });
    }

    public final void stopInput() {
        this.component.disableInput();
        this.currentInput = null;
    }

    public final void showSoftwareKeyboard() {
    }

    public final void hideSoftwareKeyboard() {
    }

    /*
     * WARNING - void declaration
     */
    public final void updateState(TextFieldValue oldValue, TextFieldValue newValue) {
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
        CurrentInput currentInput = this.currentInput;
        if (currentInput == null) {
            return;
        }
        currentInput.setValue((TextFieldValue)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated(message="This method should not be called, use BringIntoViewRequester instead.")
    public final void notifyFocusedRect(Rect rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        CurrentInput currentInput = this.currentInput;
        if (currentInput != null) {
            void var1_1;
            CurrentInput currentInput2 = currentInput;
            currentInput.setFocusedRect((Rect)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void onKeyEvent(KeyEvent keyEvent) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)keyEvent, (String)"keyEvent");
        switch (var1_1.getID()) {
            case 400: {
                this.charKeyPressed = true;
                return;
            }
            case 402: {
                this.charKeyPressed = false;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void inputMethodTextChanged(InputMethodEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!event.isConsumed()) {
            void var1_1;
            InputMethodEvent inputMethodEvent = event;
            DesktopTextInputService desktopTextInputService = this;
            CurrentInput currentInput = desktopTextInputService.currentInput;
            if (currentInput != null) {
                String string;
                String string2;
                Object object;
                String string3;
                String string4;
                String string5;
                CurrentInput currentInput2 = currentInput;
                Object object2 = inputMethodEvent.getText();
                if (object2 != null) {
                    Intrinsics.checkNotNull((Object)object2);
                    string5 = DesktopPlatformInput_desktopKt.access$toStringUntil((AttributedCharacterIterator)object2, inputMethodEvent.getCommittedCharacterCount());
                } else {
                    string5 = string4 = null;
                }
                if (string5 == null) {
                    string4 = string3 = "";
                }
                if ((object = inputMethodEvent.getText()) != null) {
                    Intrinsics.checkNotNull((Object)object);
                    string2 = DesktopPlatformInput_desktopKt.access$toStringFrom((AttributedCharacterIterator)object, inputMethodEvent.getCommittedCharacterCount());
                } else {
                    string2 = string = null;
                }
                if (string2 == null) {
                    string = "";
                }
                object2 = string;
                object = new ArrayList();
                if (desktopTextInputService.needToDeletePreviousChar && DesktopPlatformInput_desktopKt.access$isMac$p() && TextRange.getMin-impl((long)currentInput2.getValue().getSelection-d9O1mEE()) > 0 && ((CharSequence)object2).length() == 0) {
                    desktopTextInputService.needToDeletePreviousChar = false;
                    object.add(new DeleteSurroundingTextInCodePointsCommand(1, 0));
                }
                object.add(new CommitTextCommand(string3, 1));
                if (((CharSequence)object2).length() > 0) {
                    object.add(new SetComposingTextCommand((String)object2, 1));
                }
                currentInput2.getOnEditCommand().invoke(object);
            }
            var1_1.consume();
        }
    }

    public static final /* synthetic */ PlatformComponent access$getComponent$p(DesktopTextInputService $this) {
        return $this.component;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0011\b\u0087\b\u0018\u00002\u00020\u0001BQ\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0018\u0010\b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0004\u0012\u00020\u00070\u0004\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00070\u0004\u0012\u0006\u0010\u000b\u001a\u00020\t\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001a\u0010\u0014\u001a\u00020\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\u0017\u001a\u00020\u0016H\u00d6\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0010\u0010\u001a\u001a\u00020\u0019H\u00d6\u0001\u00a2\u0006\u0004\b\u001a\u0010\u001bR$\u0010\r\u001a\u0004\u0018\u00010\f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\r\u0010\u001c\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010\u000b\u001a\u00020\t8\u0006\u00f8\u0001\u0000\u00a2\u0006\f\n\u0004\b\u000b\u0010!\u001a\u0004\b\"\u0010\u0018R)\u0010\b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0004\u0012\u00020\u00070\u00048\u0006\u00a2\u0006\f\n\u0004\b\b\u0010#\u001a\u0004\b$\u0010%R#\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00070\u00048\u0006\u00a2\u0006\f\n\u0004\b\n\u0010#\u001a\u0004\b&\u0010%R\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010'\u001a\u0004\b(\u0010\u0011\"\u0004\b)\u0010*\u0082\u0002\u0004\n\u0002\b!"}, d2={"Landroidx/compose/ui/platform/DesktopTextInputService$CurrentInput;", "", "Landroidx/compose/ui/text/input/TextFieldValue;", "value", "Lkotlin/Function1;", "", "Landroidx/compose/ui/text/input/EditCommand;", "", "onEditCommand", "Landroidx/compose/ui/text/input/ImeAction;", "onImeActionPerformed", "imeAction", "Landroidx/compose/ui/geometry/Rect;", "focusedRect", "<init>", "(Landroidx/compose/ui/text/input/TextFieldValue;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;ILandroidx/compose/ui/geometry/Rect;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "component1", "()Landroidx/compose/ui/text/input/TextFieldValue;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Landroidx/compose/ui/geometry/Rect;", "getFocusedRect", "()Landroidx/compose/ui/geometry/Rect;", "setFocusedRect", "(Landroidx/compose/ui/geometry/Rect;)V", "I", "getImeAction-eUduSuo", "Lkotlin/jvm/functions/Function1;", "getOnEditCommand", "()Lkotlin/jvm/functions/Function1;", "getOnImeActionPerformed", "Landroidx/compose/ui/text/input/TextFieldValue;", "getValue", "setValue", "(Landroidx/compose/ui/text/input/TextFieldValue;)V"})
    @StabilityInferred(parameters=0)
    public static final class CurrentInput {
        private TextFieldValue value;
        private final Function1<List<? extends EditCommand>, Unit> onEditCommand;
        private final Function1<ImeAction, Unit> onImeActionPerformed;
        private final int imeAction;
        private Rect focusedRect;
        public static final int $stable = 8;

        /*
         * WARNING - void declaration
         */
        private CurrentInput(TextFieldValue value, Function1<? super List<? extends EditCommand>, Unit> onEditCommand, Function1<? super ImeAction, Unit> onImeActionPerformed, int imeAction, Rect focusedRect) {
            void var3_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter(onEditCommand, (String)"onEditCommand");
            Intrinsics.checkNotNullParameter(onImeActionPerformed, (String)"onImeActionPerformed");
            this.value = var1_1;
            this.onEditCommand = var2_2;
            this.onImeActionPerformed = var3_3;
            this.imeAction = imeAction;
            this.focusedRect = focusedRect;
        }

        public /* synthetic */ CurrentInput(TextFieldValue textFieldValue, Function1 function1, Function1 function12, int n, Rect rect, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 0x10) != 0) {
                rect = null;
            }
            this(textFieldValue, function1, function12, n, rect, null);
        }

        public final TextFieldValue getValue() {
            return this.value;
        }

        /*
         * WARNING - void declaration
         */
        public final void setValue(TextFieldValue textFieldValue) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)textFieldValue, (String)"<set-?>");
            this.value = var1_1;
        }

        public final Function1<List<? extends EditCommand>, Unit> getOnEditCommand() {
            return this.onEditCommand;
        }

        public final Function1<ImeAction, Unit> getOnImeActionPerformed() {
            return this.onImeActionPerformed;
        }

        public final int getImeAction-eUduSuo() {
            return this.imeAction;
        }

        public final Rect getFocusedRect() {
            return this.focusedRect;
        }

        /*
         * WARNING - void declaration
         */
        public final void setFocusedRect(Rect rect) {
            void var1_1;
            this.focusedRect = var1_1;
        }

        public final TextFieldValue component1() {
            return this.value;
        }

        public final String toString() {
            return "CurrentInput(value=" + this.value + ", onEditCommand=" + this.onEditCommand + ", onImeActionPerformed=" + this.onImeActionPerformed + ", imeAction=" + ImeAction.toString-impl((int)this.imeAction) + ", focusedRect=" + this.focusedRect + ')';
        }

        public final int hashCode() {
            int n = this.value.hashCode();
            n = n * 31 + this.onEditCommand.hashCode();
            n = n * 31 + this.onImeActionPerformed.hashCode();
            n = n * 31 + ImeAction.hashCode-impl((int)this.imeAction);
            n = n * 31 + (this.focusedRect == null ? 0 : this.focusedRect.hashCode());
            return n;
        }

        public final boolean equals(Object other) {
            CurrentInput currentInput;
            if (this == other) {
                return true;
            }
            if (!(other instanceof CurrentInput)) {
                return false;
            }
            currentInput = currentInput;
            if (!Intrinsics.areEqual((Object)this.value, (Object)currentInput.value)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.onEditCommand, currentInput.onEditCommand)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.onImeActionPerformed, currentInput.onImeActionPerformed)) {
                return false;
            }
            if (!ImeAction.equals-impl0((int)this.imeAction, (int)currentInput.imeAction)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.focusedRect, (Object)currentInput.focusedRect);
        }

        /*
         * WARNING - void declaration
         */
        public /* synthetic */ CurrentInput(TextFieldValue value, Function1 onEditCommand, Function1 onImeActionPerformed, int imeAction, Rect focusedRect, DefaultConstructorMarker $constructor_marker) {
            this((TextFieldValue)var1_1, (Function1<? super List<? extends EditCommand>, Unit>)var2_2, (Function1<? super ImeAction, Unit>)var3_3, imeAction, focusedRect);
            void var3_3;
            void var2_2;
            void var1_1;
        }
    }
}

