/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.node;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.node.DepthSortedSetsForDifferentPasses;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.node.MeasureAndLayoutDelegate;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nLayoutTreeConsistencyChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LayoutTreeConsistencyChecker.kt\nandroidx/compose/ui/node/LayoutTreeConsistencyChecker\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,143:1\n33#2,6:144\n116#2,2:150\n33#2,6:152\n118#2:158\n116#2,2:159\n33#2,6:161\n118#2:167\n33#2,6:168\n*S KotlinDebug\n*F\n+ 1 LayoutTreeConsistencyChecker.kt\nandroidx/compose/ui/node/LayoutTreeConsistencyChecker\n*L\n44#1:144,6\n59#1:150,2\n59#1:152,6\n59#1:158\n84#1:159,2\n84#1:161,6\n84#1:167\n136#1:168,6\n*E\n"})
public final class LayoutTreeConsistencyChecker {
    private final LayoutNode root;
    private final DepthSortedSetsForDifferentPasses relayoutNodes;
    private final List<MeasureAndLayoutDelegate.PostponedRequest> postponedMeasureRequests;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public LayoutTreeConsistencyChecker(LayoutNode root, DepthSortedSetsForDifferentPasses relayoutNodes, List<MeasureAndLayoutDelegate.PostponedRequest> postponedMeasureRequests) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)relayoutNodes, (String)"relayoutNodes");
        Intrinsics.checkNotNullParameter(postponedMeasureRequests, (String)"postponedMeasureRequests");
        this.root = var1_1;
        this.relayoutNodes = var2_2;
        this.postponedMeasureRequests = var3_3;
    }

    public final void assertConsistent() {
        LayoutTreeConsistencyChecker layoutTreeConsistencyChecker = this;
        boolean bl = !layoutTreeConsistencyChecker.isTreeConsistent(layoutTreeConsistencyChecker.root);
        if (bl) {
            LayoutTreeConsistencyChecker layoutTreeConsistencyChecker2 = this;
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = stringBuilder.append("Tree state:");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
            LayoutTreeConsistencyChecker.logTree$printSubTree(layoutTreeConsistencyChecker2, stringBuilder, layoutTreeConsistencyChecker2.root, 0);
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            System.out.println((Object)string);
            throw new IllegalStateException("Inconsistency found!");
        }
    }

    private final boolean isTreeConsistent(LayoutNode node) {
        if (!this.consistentLayoutState(node)) {
            return false;
        }
        List<LayoutNode> $this$fastForEach$iv = node.getChildren$ui();
        int n = $this$fastForEach$iv.size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            LayoutNode layoutNode = $this$fastForEach$iv.get(index$iv);
            LayoutNode it = layoutNode;
            if (this.isTreeConsistent(it)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean consistentLayoutState(LayoutNode $this$consistentLayoutState) {
        block23: {
            LayoutNode.LayoutState parentLayoutState;
            LayoutNode parent2;
            block24: {
                block26: {
                    block25: {
                        MeasureAndLayoutDelegate.PostponedRequest it;
                        MeasureAndLayoutDelegate.PostponedRequest it$iv;
                        int index$iv$iv;
                        int n;
                        List<MeasureAndLayoutDelegate.PostponedRequest> $this$fastForEach$iv$iv;
                        block19: {
                            block20: {
                                block22: {
                                    block21: {
                                        block18: {
                                            parent2 = $this$consistentLayoutState.getParent$ui();
                                            LayoutNode.LayoutState layoutState = parentLayoutState = parent2 != null ? parent2.getLayoutState$ui() : null;
                                            if ($this$consistentLayoutState.isPlaced()) break block18;
                                            if ($this$consistentLayoutState.getPlaceOrder$ui() == Integer.MAX_VALUE) break block19;
                                            LayoutNode layoutNode = parent2;
                                            boolean bl = layoutNode != null ? layoutNode.isPlaced() : false;
                                            if (!bl) break block19;
                                        }
                                        if ($this$consistentLayoutState.getMeasurePending$ui()) {
                                            MeasureAndLayoutDelegate.PostponedRequest postponedRequest;
                                            block16: {
                                                List<MeasureAndLayoutDelegate.PostponedRequest> list;
                                                $this$fastForEach$iv$iv = list = this.postponedMeasureRequests;
                                                n = $this$fastForEach$iv$iv.size();
                                                for (index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                                                    MeasureAndLayoutDelegate.PostponedRequest postponedRequest2;
                                                    it$iv = postponedRequest2 = $this$fastForEach$iv$iv.get(index$iv$iv);
                                                    it = postponedRequest2;
                                                    if (!(Intrinsics.areEqual((Object)postponedRequest2.getNode(), (Object)$this$consistentLayoutState) && !it.isLookahead())) continue;
                                                    postponedRequest = it$iv;
                                                    break block16;
                                                }
                                                postponedRequest = null;
                                            }
                                            if (postponedRequest != null) {
                                                return true;
                                            }
                                        }
                                        if (!$this$consistentLayoutState.getMeasurePending$ui()) break block20;
                                        if (this.relayoutNodes.contains($this$consistentLayoutState) || $this$consistentLayoutState.getLayoutState$ui() == LayoutNode.LayoutState.LookaheadMeasuring) break block21;
                                        LayoutNode layoutNode = parent2;
                                        if (layoutNode != null ? layoutNode.getMeasurePending$ui() : false) break block21;
                                        LayoutNode layoutNode2 = parent2;
                                        boolean bl = layoutNode2 != null ? layoutNode2.getLookaheadMeasurePending$ui() : false;
                                        if (!bl && parentLayoutState != LayoutNode.LayoutState.Measuring) break block22;
                                    }
                                    return true;
                                }
                                return false;
                            }
                            if ($this$consistentLayoutState.getLayoutPending$ui()) {
                                return this.relayoutNodes.contains($this$consistentLayoutState) || parent2 == null || parent2.getMeasurePending$ui() || parent2.getLayoutPending$ui() || parentLayoutState == LayoutNode.LayoutState.Measuring || parentLayoutState == LayoutNode.LayoutState.LayingOut;
                            }
                        }
                        if (!Intrinsics.areEqual((Object)$this$consistentLayoutState.isPlacedInLookahead(), (Object)Boolean.TRUE)) break block23;
                        if ($this$consistentLayoutState.getLookaheadMeasurePending$ui()) {
                            MeasureAndLayoutDelegate.PostponedRequest postponedRequest;
                            block17: {
                                $this$fastForEach$iv$iv = this.postponedMeasureRequests;
                                n = $this$fastForEach$iv$iv.size();
                                for (index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                                    MeasureAndLayoutDelegate.PostponedRequest postponedRequest3 = $this$fastForEach$iv$iv.get(index$iv$iv);
                                    it$iv = postponedRequest3;
                                    it$iv = postponedRequest3;
                                    it = postponedRequest3;
                                    if (!(Intrinsics.areEqual((Object)postponedRequest3.getNode(), (Object)$this$consistentLayoutState) && it.isLookahead())) continue;
                                    postponedRequest = it$iv;
                                    break block17;
                                }
                                postponedRequest = null;
                            }
                            if (postponedRequest != null) {
                                return true;
                            }
                        }
                        if (!$this$consistentLayoutState.getLookaheadMeasurePending$ui()) break block24;
                        if (this.relayoutNodes.contains($this$consistentLayoutState, true)) break block25;
                        LayoutNode layoutNode = parent2;
                        if ((layoutNode != null ? layoutNode.getLookaheadMeasurePending$ui() : false) || parentLayoutState == LayoutNode.LayoutState.LookaheadMeasuring) break block25;
                        LayoutNode layoutNode3 = parent2;
                        boolean bl = layoutNode3 != null ? layoutNode3.getMeasurePending$ui() : false;
                        if (!bl || !Intrinsics.areEqual((Object)$this$consistentLayoutState.getLookaheadRoot$ui(), (Object)$this$consistentLayoutState)) break block26;
                    }
                    return true;
                }
                return false;
            }
            if ($this$consistentLayoutState.getLookaheadLayoutPending$ui()) {
                void var1_1;
                void var2_2;
                void var3_3;
                return this.relayoutNodes.contains($this$consistentLayoutState, true) || parent2 == null || parent2.getLookaheadMeasurePending$ui() || parent2.getLookaheadLayoutPending$ui() || parentLayoutState == LayoutNode.LayoutState.LookaheadMeasuring || var3_3 == LayoutNode.LayoutState.LookaheadLayingOut || var2_2.getLayoutPending$ui() && Intrinsics.areEqual((Object)$this$consistentLayoutState.getLookaheadRoot$ui(), (Object)var1_1);
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final String nodeToString(LayoutNode node) {
        void var2_2;
        void var1_1;
        StringBuilder $this$nodeToString_u24lambda_u243 = new StringBuilder();
        $this$nodeToString_u24lambda_u243.append(node);
        $this$nodeToString_u24lambda_u243.append("[" + (Object)((Object)node.getLayoutState$ui()) + ']');
        if (!node.isPlaced()) {
            $this$nodeToString_u24lambda_u243.append("[!isPlaced]");
        }
        $this$nodeToString_u24lambda_u243.append("[measuredByParent=" + (Object)((Object)node.getMeasuredByParent$ui()) + ']');
        if (!this.consistentLayoutState((LayoutNode)var1_1)) {
            $this$nodeToString_u24lambda_u243.append("[INCONSISTENT]");
        }
        String string = var2_2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"with(...)");
        return string;
    }

    private static final void logTree$printSubTree(LayoutTreeConsistencyChecker this$0, StringBuilder stringBuilder, LayoutNode node, int depth) {
        int childrenDepth = depth;
        Object nodeRepresentation = this$0.nodeToString(node);
        if (((CharSequence)nodeRepresentation).length() > 0) {
            for (int i = 0; i < depth; ++i) {
                stringBuilder.append("..");
            }
            StringBuilder stringBuilder2 = stringBuilder.append((String)nodeRepresentation);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
            ++childrenDepth;
        }
        List<LayoutNode> $this$fastForEach$iv = node.getChildren$ui();
        int n = $this$fastForEach$iv.size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            nodeRepresentation = $this$fastForEach$iv.get(index$iv);
            LayoutNode it = nodeRepresentation;
            LayoutTreeConsistencyChecker.logTree$printSubTree(this$0, stringBuilder, it, childrenDepth);
        }
    }
}

