/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.node;

import androidx.compose.ui.internal.InlineClassHelperKt;
import androidx.compose.ui.node.MyersDiffKt;
import java.util.Arrays;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@SourceDebugExtension(value={"SMAP\nMyersDiff.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MyersDiff.kt\nandroidx/compose/ui/node/IntStack\n+ 2 InlineClassHelper.kt\nandroidx/compose/ui/internal/InlineClassHelperKt\n*L\n1#1,512:1\n42#2,7:513\n*S KotlinDebug\n*F\n+ 1 MyersDiff.kt\nandroidx/compose/ui/node/IntStack\n*L\n464#1:513,7\n*E\n"})
final class IntStack {
    private int[] stack;
    private int lastIndex;

    /*
     * WARNING - void declaration
     */
    public IntStack(int initialCapacity) {
        void var1_1;
        this.stack = new int[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    public final int get(int index) {
        void var1_1;
        return this.stack[var1_1];
    }

    public final int getSize() {
        return this.lastIndex;
    }

    /*
     * WARNING - void declaration
     */
    public final void pushRange(int oldStart, int oldEnd, int newStart, int newEnd) {
        void var3_3;
        void var2_2;
        void var1_1;
        int i = this.lastIndex;
        if (i + 4 >= this.stack.length) {
            int[] nArray = Arrays.copyOf(this.stack, this.stack.length * 2);
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(...)");
            this.stack = nArray;
        }
        int[] stack = this.stack;
        this.stack[i + 0] = var1_1;
        stack[i + 1] = var2_2;
        stack[i + 2] = var3_3;
        stack[i + 3] = newEnd;
        this.lastIndex = i + 4;
    }

    /*
     * WARNING - void declaration
     */
    public final void pushDiagonal(int x, int y, int size) {
        void var3_3;
        void var2_2;
        void var1_1;
        int i = this.lastIndex;
        if (i + 3 >= this.stack.length) {
            int[] nArray = Arrays.copyOf(this.stack, this.stack.length * 2);
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(...)");
            this.stack = nArray;
        }
        int[] stack = this.stack;
        this.stack[i + 0] = var1_1 + size;
        stack[i + 1] = var2_2 + size;
        stack[i + 2] = var3_3;
        this.lastIndex = i + 3;
    }

    public final int pop() {
        this.lastIndex += -1;
        return this.stack[this.lastIndex];
    }

    public final boolean isNotEmpty() {
        return this.lastIndex != 0;
    }

    /*
     * WARNING - void declaration
     */
    public final void sortDiagonals() {
        int i = this.lastIndex;
        boolean bl = i % 3 == 0;
        if (!bl) {
            InlineClassHelperKt.throwIllegalStateException("Array size not a multiple of 3");
        }
        if (i > 3) {
            void var1_1;
            this.quickSort(0, (int)(var1_1 - 3), 3);
        }
    }

    private final void quickSort(int start, int end, int elSize) {
        while (start < end) {
            int i = this.partition(start, end, elSize);
            this.quickSort(start, i - elSize, elSize);
            start = i + elSize;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int partition(int start, int end, int elSize) {
        void var3_3;
        void var2_2;
        void j;
        int i = start - elSize;
        while (j < end) {
            if (this.compareDiagonal((int)j, end)) {
                this.swapDiagonal(i += elSize, (int)j);
            }
            j += elSize;
        }
        this.swapDiagonal(i + elSize, (int)var2_2);
        return i + var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private final void swapDiagonal(int i, int j) {
        void var2_2;
        void var1_1;
        void var3_3;
        int[] stack = this.stack;
        MyersDiffKt.access$swap(this.stack, i, j);
        MyersDiffKt.access$swap(stack, i + 1, j + 1);
        MyersDiffKt.access$swap((int[])var3_3, (int)(var1_1 + 2), (int)(var2_2 + 2));
    }

    /*
     * WARNING - void declaration
     */
    private final boolean compareDiagonal(int a, int b) {
        void var2_2;
        void var3_3;
        void var1_1;
        int a0 = this.stack[a];
        int[] stack = this.stack;
        int b0 = stack[b];
        return a0 < b0 || a0 == b0 && stack[var1_1 + true] <= var3_3[var2_2 + true];
    }
}

