/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.input.pointer.util;

import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.input.pointer.HistoricalChange;
import androidx.compose.ui.input.pointer.PointerEventKt;
import androidx.compose.ui.input.pointer.PointerInputChange;
import androidx.compose.ui.input.pointer.util.DataPointAtTime;
import androidx.compose.ui.input.pointer.util.VelocityTracker;
import androidx.compose.ui.internal.InlineClassHelperKt;
import java.util.List;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@SourceDebugExtension(value={"SMAP\nVelocityTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VelocityTracker.kt\nandroidx/compose/ui/input/pointer/util/VelocityTrackerKt\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 3 MathHelpers.kt\nandroidx/compose/ui/util/MathHelpersKt\n*L\n1#1,756:1\n718#1:769\n725#1,2:770\n721#1,6:772\n718#1:778\n718#1:779\n713#1:780\n699#1:782\n699#1:783\n33#2,6:757\n33#2,6:763\n78#3:781\n*S KotlinDebug\n*F\n+ 1 VelocityTracker.kt\nandroidx/compose/ui/input/pointer/util/VelocityTrackerKt\n*L\n520#1:769\n522#1:770,2\n524#1:772,6\n531#1:778\n533#1:779\n546#1:780\n683#1:782\n689#1:783\n418#1:757,6\n454#1:763,6\n546#1:781\n*E\n"})
public final class VelocityTrackerKt {
    private static boolean VelocityTrackerAddPointsFix = true;
    private static boolean VelocityTrackerStrategyUseImpulse;

    /*
     * WARNING - void declaration
     */
    public static final void addPointerInputChange(VelocityTracker $this$addPointerInputChange, PointerInputChange event) {
        VelocityTracker velocityTracker;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)$this$addPointerInputChange, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (VelocityTrackerAddPointsFix) {
            if (PointerEventKt.changedToDownIgnoreConsumed(event)) {
                $this$addPointerInputChange.resetTracking();
            }
            if (!PointerEventKt.changedToUpIgnoreConsumed(event)) {
                List<HistoricalChange> list = event.getHistorical();
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    HistoricalChange historicalChange = list.get(i);
                    $this$addPointerInputChange.addPosition-Uv8p0NA(historicalChange.getUptimeMillis(), historicalChange.getOriginalEventPosition-F1C5BW0$ui());
                }
                $this$addPointerInputChange.addPosition-Uv8p0NA(event.getUptimeMillis(), event.getOriginalEventPosition-F1C5BW0$ui());
            }
            if (PointerEventKt.changedToUpIgnoreConsumed(event) && event.getUptimeMillis() - $this$addPointerInputChange.getLastMoveEventTimeStamp$ui() > 40L) {
                $this$addPointerInputChange.resetTracking();
            }
            $this$addPointerInputChange.setLastMoveEventTimeStamp$ui(event.getUptimeMillis());
            return;
        }
        if (PointerEventKt.changedToDownIgnoreConsumed((PointerInputChange)var1_1)) {
            velocityTracker.setCurrentPointerPositionAccumulator-k-4lQ0M$ui(var1_1.getPosition-F1C5BW0());
            velocityTracker.resetTracking();
        }
        long l = var1_1.getPreviousPosition-F1C5BW0();
        List<HistoricalChange> list = var1_1.getHistorical();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            HistoricalChange historicalChange = list.get(i);
            HistoricalChange historicalChange2 = historicalChange;
            historicalChange2 = historicalChange;
            long l2 = Offset.minus-MK-Hz9U((long)historicalChange.getPosition-F1C5BW0(), (long)l);
            l = historicalChange2.getPosition-F1C5BW0();
            VelocityTracker velocityTracker2 = velocityTracker;
            velocityTracker2.setCurrentPointerPositionAccumulator-k-4lQ0M$ui(Offset.plus-MK-Hz9U((long)velocityTracker2.getCurrentPointerPositionAccumulator-F1C5BW0$ui(), (long)l2));
            velocityTracker.addPosition-Uv8p0NA(historicalChange2.getUptimeMillis(), velocityTracker.getCurrentPointerPositionAccumulator-F1C5BW0$ui());
        }
        long l3 = Offset.minus-MK-Hz9U((long)var1_1.getPosition-F1C5BW0(), (long)l);
        VelocityTracker velocityTracker3 = velocityTracker;
        velocityTracker3.setCurrentPointerPositionAccumulator-k-4lQ0M$ui(Offset.plus-MK-Hz9U((long)velocityTracker3.getCurrentPointerPositionAccumulator-F1C5BW0$ui(), (long)l3));
        velocityTracker.addPosition-Uv8p0NA(var1_1.getUptimeMillis(), velocityTracker.getCurrentPointerPositionAccumulator-F1C5BW0$ui());
    }

    /*
     * WARNING - void declaration
     */
    public static final float[] polyFitLeastSquares(float[] x2, float[] y, int sampleCount, int degree, float[] coefficients) {
        void var1_4;
        int row$iv2;
        int m;
        Intrinsics.checkNotNullParameter((Object)x2, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Intrinsics.checkNotNullParameter((Object)coefficients, (String)"coefficients");
        if (sampleCount == 0) {
            InlineClassHelperKt.throwIllegalArgumentException("At least one point must be provided");
        }
        int truncatedDegree = 2 >= sampleCount ? sampleCount - 1 : 2;
        int n = truncatedDegree + 1;
        int n2 = 0;
        float[][] fArrayArray = new float[n][];
        while (n2 < n) {
            int n3 = n2++;
            fArrayArray[n3] = new float[m];
        }
        float[][] a = fArrayArray;
        for (int h = 0; h < m; ++h) {
            float[][] fArrayArray2 = a;
            a[0][h] = 1.0f;
            for (int i = 1; i < n; ++i) {
                void $this$get$iv;
                void value$iv22;
                fArrayArray = a;
                float[][] fArrayArray3 = a;
                row$iv2 = i - 1;
                $this$set$iv[i][h] = value$iv22 = $this$get$iv[row$iv2][h] * x2[h];
            }
        }
        int $this$set$iv = 0;
        float[][] value$iv22 = new float[n][];
        while ($this$set$iv < n) {
            row$iv2 = $this$set$iv++;
            value$iv22[row$iv2] = new float[m];
        }
        float[][] q = value$iv22;
        int value$iv22 = 0;
        float[][] row$iv2 = new float[n][];
        while (value$iv22 < n) {
            int x2 = value$iv22++;
            row$iv2[x2] = new float[n];
        }
        float[][] r = row$iv2;
        for (int j = 0; j < n; ++j) {
            float f;
            float[] w = q[j];
            ArraysKt.copyInto((float[])a[j], (float[])w, (int)0, (int)0, (int)m);
            for (int i = 0; i < j; ++i) {
                float[] z = q[i];
                float dot = VelocityTrackerKt.dot(w, z);
                for (int h = 0; h < m; ++h) {
                    int n4 = h;
                    w[n4] = w[n4] - dot * z[h];
                }
            }
            float[] $this$norm$iv = w;
            float $this$fastCoerceAtLeast$iv = (float)Math.sqrt(VelocityTrackerKt.dot(w, $this$norm$iv));
            float inverseNorm = 1.0f / (f < 1.0E-6f ? 1.0E-6f : $this$fastCoerceAtLeast$iv);
            int h = 0;
            while (h < m) {
                int dot = h++;
                w[dot] = w[dot] * inverseNorm;
            }
            float[] v = r[j];
            for (int i = 0; i < n; ++i) {
                int n5 = i;
                v[n5] = n5 < j ? 0.0f : VelocityTrackerKt.dot(w, a[i]);
            }
        }
        void wy = var1_4;
        for (int i = n - 1; i >= 0; --i) {
            float[] fArray;
            float c = VelocityTrackerKt.dot(q[i], (float[])wy);
            float[] ri = r[i];
            int n6 = i + 1;
            int j = n - 1;
            if (n6 <= j) {
                while (true) {
                    c -= ri[j] * coefficients[j];
                    if (j == n6) break;
                    --j;
                }
            }
            coefficients[i] = c / fArray[i];
        }
        return coefficients;
    }

    /*
     * WARNING - void declaration
     */
    private static final float dot(float[] $this$dot, float[] a) {
        void var2_2;
        float result2 = 0.0f;
        int n = $this$dot.length;
        for (int i = 0; i < n; ++i) {
            result2 += $this$dot[i] * a[i];
        }
        return (float)var2_2;
    }

    public static final boolean getVelocityTrackerStrategyUseImpulse() {
        return VelocityTrackerStrategyUseImpulse;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$set(DataPointAtTime[] $receiver, int index, long time, float dataPoint) {
        void var1_1;
        void var2_2;
        float f = dataPoint;
        void var7_5 = var2_2;
        DataPointAtTime[] dataPointAtTimeArray = $receiver;
        DataPointAtTime dataPointAtTime = $receiver[var1_1];
        if (dataPointAtTime == null) {
            dataPointAtTimeArray[var1_1] = new DataPointAtTime((long)var7_5, f);
            return;
        }
        dataPointAtTime.setTime((long)var7_5);
        dataPointAtTime.setDataPoint(f);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ float access$calculateImpulseVelocity(float[] dataPoints, float[] time, int sampleCount, boolean isDataDifferential) {
        void var2_2;
        void var1_1;
        float[] fArray = dataPoints;
        float f = 0.0f;
        void var5_5 = var1_1[--var2_2];
        for (void var6_6 = var2_2; var6_6 > 0; --var6_6) {
            void var3_3;
            float f2 = var5_5;
            if (f2 == (var5_5 = var1_1[var6_6 - true])) continue;
            float f3 = var3_3 != false ? -fArray[var6_6 - true] : fArray[var6_6] - fArray[var6_6 - true];
            f2 = f3 / (f2 - var5_5);
            f3 = Math.signum(f) * (float)Math.sqrt(2.0f * Math.abs(f));
            f += (f2 - f3) * Math.abs(f2);
            if (var6_6 != var2_2) continue;
            f *= 0.5f;
        }
        return Math.signum(f) * (float)Math.sqrt(2.0f * Math.abs(f));
    }
}

