/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.input.pointer;

import androidx.collection.LongSparseArray;
import androidx.collection.MutableObjectList;
import androidx.compose.runtime.collection.MutableVector;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.input.pointer.InternalPointerEvent;
import androidx.compose.ui.input.pointer.Node;
import androidx.compose.ui.input.pointer.PointerInputChange;
import androidx.compose.ui.layout.LayoutCoordinates;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nHitPathTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HitPathTracker.kt\nandroidx/compose/ui/input/pointer/NodeParent\n+ 2 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVectorKt\n+ 3 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector\n*L\n1#1,652:1\n1208#2:653\n1187#2,2:654\n460#3,11:656\n460#3,11:667\n460#3,11:678\n460#3,11:689\n460#3,11:700\n523#3:711\n48#3:712\n523#3:713\n460#3,11:714\n*S KotlinDebug\n*F\n+ 1 HitPathTracker.kt\nandroidx/compose/ui/input/pointer/NodeParent\n*L\n191#1:653\n191#1:654,2\n200#1:656,11\n230#1:667,11\n249#1:678,11\n261#1:689,11\n275#1:700,11\n286#1:711\n299#1:712\n300#1:713\n308#1:714,11\n*E\n"})
public class NodeParent {
    private final MutableVector<Node> children = new MutableVector((Object[])new Node[16], 0);
    public static final int $stable = MutableVector.$stable;

    public final MutableVector<Node> getChildren() {
        return this.children;
    }

    public boolean buildCache(LongSparseArray<PointerInputChange> changes, LayoutCoordinates parentCoordinates, InternalPointerEvent internalPointerEvent, boolean isInBounds) {
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        Intrinsics.checkNotNullParameter((Object)parentCoordinates, (String)"parentCoordinates");
        Intrinsics.checkNotNullParameter((Object)internalPointerEvent, (String)"internalPointerEvent");
        boolean changed = false;
        MutableVector<Node> this_$iv = this.children;
        int size$iv = this_$iv.getSize();
        if (size$iv > 0) {
            int i$iv = 0;
            Object[] content$iv = this_$iv.getContent();
            do {
                Node node;
                boolean bl = changed = ((NodeParent)(node = (Node)content$iv[i$iv])).buildCache(changes, parentCoordinates, internalPointerEvent, isInBounds) || changed;
            } while (++i$iv < size$iv);
        }
        return changed;
    }

    public boolean dispatchMainEventPass(LongSparseArray<PointerInputChange> changes, LayoutCoordinates parentCoordinates, InternalPointerEvent internalPointerEvent, boolean isInBounds) {
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        Intrinsics.checkNotNullParameter((Object)parentCoordinates, (String)"parentCoordinates");
        Intrinsics.checkNotNullParameter((Object)internalPointerEvent, (String)"internalPointerEvent");
        boolean dispatched = false;
        MutableVector<Node> this_$iv = this.children;
        int size$iv = this_$iv.getSize();
        if (size$iv > 0) {
            int i$iv = 0;
            Object[] content$iv = this_$iv.getContent();
            do {
                Node node;
                boolean bl = dispatched = ((NodeParent)(node = (Node)content$iv[i$iv])).dispatchMainEventPass(changes, parentCoordinates, internalPointerEvent, isInBounds) || dispatched;
            } while (++i$iv < size$iv);
        }
        return dispatched;
    }

    /*
     * WARNING - void declaration
     */
    public boolean dispatchFinalEventPass(InternalPointerEvent internalPointerEvent) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)internalPointerEvent, (String)"internalPointerEvent");
        boolean dispatched = false;
        MutableVector<Node> this_$iv = this.children;
        int size$iv = this_$iv.getSize();
        if (size$iv > 0) {
            int i$iv = 0;
            Object[] content$iv = this_$iv.getContent();
            do {
                Node node;
                boolean bl = dispatched = ((NodeParent)(node = (Node)content$iv[i$iv])).dispatchFinalEventPass(internalPointerEvent) || dispatched;
            } while (++i$iv < size$iv);
        }
        this.cleanUpHits((InternalPointerEvent)var1_1);
        this.cleanUpHover();
        return (boolean)var2_2;
    }

    public void dispatchCancel() {
        MutableVector<Node> this_$iv = this.children;
        int size$iv = this_$iv.getSize();
        if (size$iv > 0) {
            int i$iv = 0;
            Object[] content$iv = this_$iv.getContent();
            do {
                Node node = (Node)content$iv[i$iv];
                ((NodeParent)node).dispatchCancel();
            } while (++i$iv < size$iv);
        }
    }

    public void removeInvalidPointerIdsAndChanges(long pointerIdValue, MutableObjectList<Node> hitNodes) {
        Intrinsics.checkNotNullParameter(hitNodes, (String)"hitNodes");
        MutableVector<Node> this_$iv = this.children;
        int size$iv = this_$iv.getSize();
        if (size$iv > 0) {
            int i$iv = 0;
            Object[] content$iv = this_$iv.getContent();
            do {
                Node node = (Node)content$iv[i$iv];
                ((NodeParent)node).removeInvalidPointerIdsAndChanges(pointerIdValue, hitNodes);
            } while (++i$iv < size$iv);
        }
    }

    public final void removeDetachedPointerInputModifierNodes() {
        int index = 0;
        while (index < this.children.getSize()) {
            MutableVector<Node> mutableVector = this.children;
            Node child = (Node)mutableVector.getContent()[index];
            if (!child.getModifierNode().isAttached()) {
                ((NodeParent)child).dispatchCancel();
                this.children.removeAt(index);
                continue;
            }
            ++index;
            mutableVector.removeDetachedPointerInputModifierNodes();
        }
    }

    public void cleanUpHits(InternalPointerEvent internalPointerEvent) {
        Intrinsics.checkNotNullParameter((Object)internalPointerEvent, (String)"internalPointerEvent");
        Object object = this.children;
        for (int i = object.getSize() - 1; i >= 0; --i) {
            object = this.children;
            if (!(object = (Node)object.getContent()[i]).getPointerIds().isEmpty()) continue;
            this.children.removeAt(i);
        }
    }

    public void cleanUpHover() {
        MutableVector<Node> this_$iv = this.children;
        int size$iv = this_$iv.getSize();
        if (size$iv > 0) {
            int i$iv = 0;
            Object[] content$iv = this_$iv.getContent();
            do {
                Node node = (Node)content$iv[i$iv];
                ((NodeParent)node).cleanUpHover();
            } while (++i$iv < size$iv);
        }
    }
}

