/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.vector;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.PathMeasure;
import androidx.compose.ui.graphics.SkiaBackedPath_skikoKt;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.graphics.drawscope.DrawStyle;
import androidx.compose.ui.graphics.drawscope.Stroke;
import androidx.compose.ui.graphics.vector.PathComponent;
import androidx.compose.ui.graphics.vector.PathNode;
import androidx.compose.ui.graphics.vector.PathParserKt;
import androidx.compose.ui.graphics.vector.VNode;
import androidx.compose.ui.graphics.vector.VectorKt;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nVector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Vector.kt\nandroidx/compose/ui/graphics/vector/PathComponent\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,651:1\n1#2:652\n*E\n"})
public final class PathComponent
extends VNode {
    private String name = "";
    private Brush fill;
    private float fillAlpha = 1.0f;
    private List<? extends PathNode> pathData = VectorKt.getEmptyPath();
    private int pathFillType = VectorKt.getDefaultFillType();
    private float strokeAlpha = 1.0f;
    private float strokeLineWidth;
    private Brush stroke;
    private int strokeLineCap = VectorKt.getDefaultStrokeLineCap();
    private int strokeLineJoin = VectorKt.getDefaultStrokeLineJoin();
    private float strokeLineMiter = 4.0f;
    private float trimPathStart;
    private float trimPathEnd = 1.0f;
    private float trimPathOffset;
    private boolean isPathDirty = true;
    private boolean isStrokeDirty = true;
    private boolean isTrimPathDirty;
    private Stroke strokeStyle;
    private final Path path;
    private Path renderPath = this.path = SkiaBackedPath_skikoKt.Path();
    private final Lazy pathMeasure$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)pathMeasure.2.INSTANCE);
    public static final int $stable = 8;

    public PathComponent() {
        super(null);
    }

    /*
     * WARNING - void declaration
     */
    public final void setName(String value) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.name = var1_1;
        this.invalidate();
    }

    public final Brush getFill() {
        return this.fill;
    }

    /*
     * WARNING - void declaration
     */
    public final void setFill(Brush value) {
        void var1_1;
        this.fill = var1_1;
        this.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    public final void setFillAlpha(float value) {
        void var1_1;
        this.fillAlpha = var1_1;
        this.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    public final void setPathData(List<? extends PathNode> value) {
        void var1_1;
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.pathData = var1_1;
        this.isPathDirty = true;
        this.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    public final void setPathFillType-oQ8Xj4U(int value) {
        void var1_1;
        this.pathFillType = value;
        this.renderPath.setFillType-oQ8Xj4U((int)var1_1);
        this.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    public final void setStrokeAlpha(float value) {
        void var1_1;
        this.strokeAlpha = var1_1;
        this.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    public final void setStrokeLineWidth(float value) {
        void var1_1;
        this.strokeLineWidth = var1_1;
        this.isStrokeDirty = true;
        this.invalidate();
    }

    public final Brush getStroke() {
        return this.stroke;
    }

    /*
     * WARNING - void declaration
     */
    public final void setStroke(Brush value) {
        void var1_1;
        this.stroke = var1_1;
        this.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    public final void setStrokeLineCap-BeK7IIE(int value) {
        void var1_1;
        this.strokeLineCap = var1_1;
        this.isStrokeDirty = true;
        this.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    public final void setStrokeLineJoin-Ww9F2mQ(int value) {
        void var1_1;
        this.strokeLineJoin = var1_1;
        this.isStrokeDirty = true;
        this.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    public final void setStrokeLineMiter(float value) {
        void var1_1;
        this.strokeLineMiter = var1_1;
        this.isStrokeDirty = true;
        this.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    public final void setTrimPathStart(float value) {
        void var1_1;
        this.trimPathStart = var1_1;
        this.isTrimPathDirty = true;
        this.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    public final void setTrimPathEnd(float value) {
        void var1_1;
        this.trimPathEnd = var1_1;
        this.isTrimPathDirty = true;
        this.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    public final void setTrimPathOffset(float value) {
        void var1_1;
        this.trimPathOffset = var1_1;
        this.isTrimPathDirty = true;
        this.invalidate();
    }

    private final PathMeasure getPathMeasure() {
        Lazy lazy = this.pathMeasure$delegate;
        return (PathMeasure)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void updateRenderPath() {
        void var3_4;
        void var2_3;
        if (this.trimPathStart == 0.0f && this.trimPathEnd == 1.0f) {
            this.renderPath = this.path;
            return;
        }
        if (Intrinsics.areEqual((Object)this.renderPath, (Object)this.path)) {
            this.renderPath = SkiaBackedPath_skikoKt.Path();
        } else {
            int fillType = this.renderPath.getFillType-Rg-k1Os();
            this.renderPath.rewind();
            this.renderPath.setFillType-oQ8Xj4U(fillType);
        }
        this.getPathMeasure().setPath(this.path, false);
        float length = this.getPathMeasure().getLength();
        float start = (this.trimPathStart + this.trimPathOffset) % 1.0f * length;
        float end = (this.trimPathEnd + this.trimPathOffset) % 1.0f * length;
        if (start > end) {
            void var1_2;
            this.getPathMeasure().getSegment(start, (float)var1_2, this.renderPath, true);
            this.getPathMeasure().getSegment(0.0f, end, this.renderPath, true);
            return;
        }
        this.getPathMeasure().getSegment((float)var2_3, (float)var3_4, this.renderPath, true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void draw(DrawScope $this$draw) {
        Brush it;
        PathComponent pathComponent;
        Intrinsics.checkNotNullParameter((Object)$this$draw, (String)"<this>");
        if (this.isPathDirty) {
            pathComponent = this;
            PathParserKt.toPath(pathComponent.pathData, (Path)pathComponent.path);
            pathComponent.updateRenderPath();
        } else if (this.isTrimPathDirty) {
            this.updateRenderPath();
        }
        this.isPathDirty = false;
        this.isTrimPathDirty = false;
        Brush brush = this.fill;
        if (brush != null) {
            it = brush;
            DrawScope.drawPath-GBMwjPU$default((DrawScope)$this$draw, (Path)this.renderPath, (Brush)it, (float)this.fillAlpha, null, null, (int)0, (int)56, null);
        }
        Brush brush2 = this.stroke;
        if (brush2 != null) {
            void var3_3;
            void var1_1;
            it = brush2;
            Stroke targetStroke = this.strokeStyle;
            if (this.isStrokeDirty || targetStroke == null) {
                this.strokeStyle = targetStroke = new Stroke(this.strokeLineWidth, this.strokeLineMiter, this.strokeLineCap, this.strokeLineJoin, null, 16, null);
                this.isStrokeDirty = false;
            }
            DrawScope.drawPath-GBMwjPU$default((DrawScope)var1_1, (Path)this.renderPath, (Brush)pathComponent, (float)this.strokeAlpha, (DrawStyle)((DrawStyle)var3_3), null, (int)0, (int)48, null);
            return;
        }
    }

    public final String toString() {
        return this.path.toString();
    }
}

