/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.vector;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.Matrix;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.SkiaBackedPath_skikoKt;
import androidx.compose.ui.graphics.SolidColor;
import androidx.compose.ui.graphics.drawscope.DrawContext;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.graphics.drawscope.DrawTransform;
import androidx.compose.ui.graphics.vector.PathComponent;
import androidx.compose.ui.graphics.vector.PathNode;
import androidx.compose.ui.graphics.vector.PathParserKt;
import androidx.compose.ui.graphics.vector.VNode;
import androidx.compose.ui.graphics.vector.VectorKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nVector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Vector.kt\nandroidx/compose/ui/graphics/vector/GroupComponent\n+ 2 Color.kt\nandroidx/compose/ui/graphics/ColorKt\n+ 3 DrawScope.kt\nandroidx/compose/ui/graphics/drawscope/DrawScopeKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,651:1\n696#2:652\n702#2:653\n272#3,8:654\n280#3:663\n282#3,4:670\n1#4:662\n33#5,6:664\n33#5,6:674\n*S KotlinDebug\n*F\n+ 1 Vector.kt\nandroidx/compose/ui/graphics/vector/GroupComponent\n*L\n410#1:652\n411#1:653\n609#1:654,8\n609#1:663\n609#1:670,4\n616#1:664,6\n626#1:674,6\n*E\n"})
public final class GroupComponent
extends VNode {
    private float[] groupMatrix;
    private final List<VNode> children = new ArrayList();
    private boolean isTintable = true;
    private long tintColor = Color.Companion.getUnspecified-0d7_KjU();
    private List<? extends PathNode> clipPathData = VectorKt.getEmptyPath();
    private boolean isClipPathDirty = true;
    private Path clipPath;
    private Function1<? super VNode, Unit> invalidateListener;
    private final Function1<VNode, Unit> wrappedListener = (Function1)new Function1<VNode, Unit>(this){
        final /* synthetic */ GroupComponent this$0;
        {
            void var1_1;
            this.this$0 = var1_1;
            super(1);
        }

        /*
         * WARNING - void declaration
         */
        public final void invoke(VNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            GroupComponent.access$markTintForVNode(this.this$0, node);
            Function1<VNode, Unit> function1 = ((VNode)this.this$0).getInvalidateListener$ui();
            if (function1 != null) {
                void var1_1;
                function1.invoke((Object)var1_1);
                return;
            }
        }
    };
    private String name = "";
    private float rotation;
    private float pivotX;
    private float pivotY;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private float translationX;
    private float translationY;
    private boolean isMatrixDirty = true;
    public static final int $stable = 8;

    public GroupComponent() {
        super(null);
    }

    public final boolean isTintable() {
        return this.isTintable;
    }

    public final long getTintColor-0d7_KjU() {
        return this.tintColor;
    }

    /*
     * WARNING - void declaration
     */
    private final void markTintForBrush(Brush brush) {
        if (!this.isTintable) {
            return;
        }
        if (brush != null) {
            if (brush instanceof SolidColor) {
                void var1_1;
                this.markTintForColor-8_81llA(((SolidColor)var1_1).getValue-0d7_KjU());
                return;
            }
            this.markNotTintable();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void markTintForColor-8_81llA(long color) {
        if (!this.isTintable) {
            return;
        }
        long l = color;
        if (l != 16L) {
            void var1_1;
            l = this.tintColor;
            if (l == 16L) {
                this.tintColor = color;
                return;
            }
            if (!VectorKt.rgbEqual--OWjLjI(this.tintColor, (long)var1_1)) {
                this.markNotTintable();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void markTintForVNode(VNode node) {
        if (node instanceof PathComponent) {
            this.markTintForBrush(((PathComponent)node).getFill());
            this.markTintForBrush(((PathComponent)node).getStroke());
            return;
        }
        if (node instanceof GroupComponent) {
            if (((GroupComponent)node).isTintable && this.isTintable) {
                void var1_1;
                this.markTintForColor-8_81llA(((GroupComponent)var1_1).tintColor);
                return;
            }
            this.markNotTintable();
        }
    }

    private final void markNotTintable() {
        this.isTintable = false;
        this.tintColor = Color.Companion.getUnspecified-0d7_KjU();
    }

    /*
     * WARNING - void declaration
     */
    public final void setClipPathData(List<? extends PathNode> value) {
        void var1_1;
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.clipPathData = var1_1;
        this.isClipPathDirty = true;
        this.invalidate();
    }

    private final boolean getWillClipPath() {
        return !((Collection)this.clipPathData).isEmpty();
    }

    @Override
    public final Function1<VNode, Unit> getInvalidateListener$ui() {
        return this.invalidateListener;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setInvalidateListener$ui(Function1<? super VNode, Unit> function1) {
        void var1_1;
        this.invalidateListener = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setName(String value) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.name = var1_1;
        this.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    public final void setRotation(float value) {
        void var1_1;
        this.rotation = var1_1;
        this.isMatrixDirty = true;
        this.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    public final void setPivotX(float value) {
        void var1_1;
        this.pivotX = var1_1;
        this.isMatrixDirty = true;
        this.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    public final void setPivotY(float value) {
        void var1_1;
        this.pivotY = var1_1;
        this.isMatrixDirty = true;
        this.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    public final void setScaleX(float value) {
        void var1_1;
        this.scaleX = var1_1;
        this.isMatrixDirty = true;
        this.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    public final void setScaleY(float value) {
        void var1_1;
        this.scaleY = var1_1;
        this.isMatrixDirty = true;
        this.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    public final void setTranslationX(float value) {
        void var1_1;
        this.translationX = var1_1;
        this.isMatrixDirty = true;
        this.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    public final void setTranslationY(float value) {
        void var1_1;
        this.translationY = var1_1;
        this.isMatrixDirty = true;
        this.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    public final void insertAt(int index, VNode instance) {
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        GroupComponent groupComponent = this;
        if (index < groupComponent.children.size()) {
            void var1_1;
            this.children.set((int)var1_1, instance);
        } else {
            this.children.add(instance);
        }
        this.markTintForVNode(instance);
        var2_2.setInvalidateListener$ui(this.wrappedListener);
        this.invalidate();
    }

    @Override
    public final void draw(DrawScope $this$draw) {
        Object object;
        GroupComponent groupComponent;
        Intrinsics.checkNotNullParameter((Object)$this$draw, (String)"<this>");
        if (this.isMatrixDirty) {
            groupComponent = this;
            object = groupComponent.groupMatrix;
            if (groupComponent.groupMatrix == null) {
                groupComponent.groupMatrix = object = Matrix.constructor-impl$default$343e1048(null, (int)1);
            } else {
                Matrix.reset-impl((float[])object);
            }
            Matrix.translate-impl$default$4647a9a1((float[])object, (float)(groupComponent.translationX + groupComponent.pivotX), (float)(groupComponent.translationY + groupComponent.pivotY), (float)0.0f, (int)4);
            Matrix.rotateZ-impl((float[])object, (float)groupComponent.rotation);
            Matrix.scale-impl((float[])object, (float)groupComponent.scaleX, (float)groupComponent.scaleY, (float)1.0f);
            Matrix.translate-impl$default$4647a9a1((float[])object, (float)(-groupComponent.pivotX), (float)(-groupComponent.pivotY), (float)0.0f, (int)4);
            this.isMatrixDirty = false;
        }
        if (this.isClipPathDirty) {
            groupComponent = this;
            if (groupComponent.getWillClipPath()) {
                Path path = groupComponent.clipPath;
                object = path;
                if (path == null) {
                    object = SkiaBackedPath_skikoKt.Path();
                    groupComponent.clipPath = (Path)object;
                }
                PathParserKt.toPath(groupComponent.clipPathData, (Path)object);
            }
            this.isClipPathDirty = false;
        }
        groupComponent = $this$draw;
        DrawContext $this$withTransform_u24lambda_u246$iv = groupComponent.getDrawContext();
        long previousSize$iv = $this$withTransform_u24lambda_u246$iv.getSize-NH-jbRc();
        $this$withTransform_u24lambda_u246$iv.getCanvas().save();
        try {
            DrawTransform $this$draw_u24lambda_u244 = $this$withTransform_u24lambda_u246$iv.getTransform();
            if (this.groupMatrix != null) {
                Matrix matrix = this.groupMatrix != null ? Matrix.box-impl((float[])this.groupMatrix) : null;
                float[] it = matrix.values;
                $this$draw_u24lambda_u244.transform-58bKbWc(it);
            }
            Path targetClip = this.clipPath;
            if (this.getWillClipPath() && targetClip != null) {
                DrawTransform.clipPath-mtrdD-E$default((DrawTransform)object, (Path)targetClip, (int)0, (int)2, null);
            }
            List<VNode> $this$fastForEach$iv = this.children;
            int n = $this$fastForEach$iv.size();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                VNode vNode = $this$fastForEach$iv.get(index$iv);
                VNode vNode2 = vNode;
                vNode2 = vNode;
                vNode2 = vNode;
                vNode.draw($this$draw);
            }
        }
        catch (Throwable throwable) {
            $this$withTransform_u24lambda_u246$iv.getCanvas().restore();
            groupComponent.setSize-uvyYCjk(previousSize$iv);
            throw throwable;
        }
        $this$withTransform_u24lambda_u246$iv.getCanvas().restore();
        $this$withTransform_u24lambda_u246$iv.setSize-uvyYCjk(previousSize$iv);
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        StringBuilder sb = new StringBuilder("VGroup: ").append(this.name);
        List<VNode> $this$fastForEach$iv = this.children;
        int n = $this$fastForEach$iv.size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            VNode vNode;
            VNode node = vNode = $this$fastForEach$iv.get(index$iv);
            sb.append("\t").append(node.toString()).append("\n");
        }
        String string = var1_1.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$markTintForVNode(GroupComponent $this, VNode node) {
        void var1_1;
        $this.markTintForVNode((VNode)var1_1);
    }
}

