/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.AnimationVectorsKt;
import androidx.compose.animation.core.FloatDecayAnimationSpec;
import androidx.compose.animation.core.VectorizedDecayAnimationSpec;
import kotlin.jvm.internal.Intrinsics;

final class VectorizedFloatDecaySpec<V extends AnimationVector>
implements VectorizedDecayAnimationSpec<V> {
    private final FloatDecayAnimationSpec floatDecaySpec;
    private V valueVector;
    private V velocityVector;
    private V targetVector;
    private final float absVelocityThreshold;

    /*
     * WARNING - void declaration
     */
    public VectorizedFloatDecaySpec(FloatDecayAnimationSpec floatDecaySpec) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)floatDecaySpec, (String)"floatDecaySpec");
        this.floatDecaySpec = var1_1;
        this.absVelocityThreshold = this.floatDecaySpec.getAbsVelocityThreshold();
    }

    @Override
    public final float getAbsVelocityThreshold() {
        return this.absVelocityThreshold;
    }

    @Override
    public final V getValueFromNanos(long playTimeNanos, V initialValue, V initialVelocity) {
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        if (this.valueVector == null) {
            this.valueVector = AnimationVectorsKt.newInstance(initialValue);
        }
        int i = 0;
        V v = this.valueVector;
        if (v == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"valueVector");
            v = null;
        }
        int n = ((AnimationVector)v).getSize$animation_core();
        while (i < n) {
            V v2 = this.valueVector;
            if (v2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"valueVector");
                v2 = null;
            }
            ((AnimationVector)v2).set$animation_core(i, this.floatDecaySpec.getValueFromNanos(playTimeNanos, ((AnimationVector)initialValue).get$animation_core(i), ((AnimationVector)initialVelocity).get$animation_core(i)));
            ++i;
        }
        V v3 = this.valueVector;
        if (v3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"valueVector");
            v3 = null;
        }
        return v3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long getDurationNanos(V initialValue, V initialVelocity) {
        void var3_3;
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        long maxDuration = 0L;
        if (this.velocityVector == null) {
            this.velocityVector = AnimationVectorsKt.newInstance(initialValue);
        }
        int i = 0;
        V v = this.velocityVector;
        if (v == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"velocityVector");
            v = null;
        }
        int n = ((AnimationVector)v).getSize$animation_core();
        while (i < n) {
            ((AnimationVector)initialValue).get$animation_core(i);
            maxDuration = Math.max(maxDuration, this.floatDecaySpec.getDurationNanos$2548a29(((AnimationVector)initialVelocity).get$animation_core(i)));
            ++i;
        }
        return (long)var3_3;
    }

    @Override
    public final V getVelocityFromNanos(long playTimeNanos, V initialValue, V initialVelocity) {
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        if (this.velocityVector == null) {
            this.velocityVector = AnimationVectorsKt.newInstance(initialValue);
        }
        int i = 0;
        V v = this.velocityVector;
        if (v == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"velocityVector");
            v = null;
        }
        int n = ((AnimationVector)v).getSize$animation_core();
        while (i < n) {
            V v2 = this.velocityVector;
            if (v2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"velocityVector");
                v2 = null;
            }
            ((AnimationVector)initialValue).get$animation_core(i);
            ((AnimationVector)v2).set$animation_core(i, this.floatDecaySpec.getVelocityFromNanos$4875821f(playTimeNanos, ((AnimationVector)initialVelocity).get$animation_core(i)));
            ++i;
        }
        V v3 = this.velocityVector;
        if (v3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"velocityVector");
            v3 = null;
        }
        return v3;
    }

    @Override
    public final V getTargetValue(V initialValue, V initialVelocity) {
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        if (this.targetVector == null) {
            this.targetVector = AnimationVectorsKt.newInstance(initialValue);
        }
        int i = 0;
        V v = this.targetVector;
        if (v == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"targetVector");
            v = null;
        }
        int n = ((AnimationVector)v).getSize$animation_core();
        while (i < n) {
            V v2 = this.targetVector;
            if (v2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"targetVector");
                v2 = null;
            }
            ((AnimationVector)v2).set$animation_core(i, this.floatDecaySpec.getTargetValue(((AnimationVector)initialValue).get$animation_core(i), ((AnimationVector)initialVelocity).get$animation_core(i)));
            ++i;
        }
        V v3 = this.targetVector;
        if (v3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"targetVector");
            v3 = null;
        }
        return v3;
    }
}

