/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.AnimationVector1D;
import androidx.compose.animation.core.AnimationVector2D;
import androidx.compose.animation.core.AnimationVector4D;
import androidx.compose.animation.core.TwoWayConverter;
import androidx.compose.animation.core.TwoWayConverterImpl;
import androidx.compose.animation.core.VectorConvertersKt;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.unit.Dp;
import androidx.compose.ui.unit.DpOffset;
import androidx.compose.ui.unit.IntOffset;
import androidx.compose.ui.unit.IntSize;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.IntCompanionObject;
import kotlin.jvm.internal.Intrinsics;

public final class VectorConvertersKt {
    private static final TwoWayConverter<Float, AnimationVector1D> FloatToVector = VectorConvertersKt.TwoWayConverter(FloatToVector.1.INSTANCE, FloatToVector.2.INSTANCE);
    private static final TwoWayConverter<Integer, AnimationVector1D> IntToVector = VectorConvertersKt.TwoWayConverter(IntToVector.1.INSTANCE, IntToVector.2.INSTANCE);
    private static final TwoWayConverter<Dp, AnimationVector1D> DpToVector = VectorConvertersKt.TwoWayConverter(DpToVector.1.INSTANCE, DpToVector.2.INSTANCE);
    private static final TwoWayConverter<DpOffset, AnimationVector2D> DpOffsetToVector = VectorConvertersKt.TwoWayConverter(DpOffsetToVector.1.INSTANCE, DpOffsetToVector.2.INSTANCE);
    private static final TwoWayConverter<Size, AnimationVector2D> SizeToVector = VectorConvertersKt.TwoWayConverter(SizeToVector.1.INSTANCE, SizeToVector.2.INSTANCE);
    private static final TwoWayConverter<Offset, AnimationVector2D> OffsetToVector = VectorConvertersKt.TwoWayConverter(OffsetToVector.1.INSTANCE, OffsetToVector.2.INSTANCE);
    private static final TwoWayConverter<IntOffset, AnimationVector2D> IntOffsetToVector = VectorConvertersKt.TwoWayConverter(IntOffsetToVector.1.INSTANCE, IntOffsetToVector.2.INSTANCE);
    private static final TwoWayConverter<IntSize, AnimationVector2D> IntSizeToVector = VectorConvertersKt.TwoWayConverter(IntSizeToVector.1.INSTANCE, IntSizeToVector.2.INSTANCE);
    private static final TwoWayConverter<Rect, AnimationVector4D> RectToVector = VectorConvertersKt.TwoWayConverter(RectToVector.1.INSTANCE, RectToVector.2.INSTANCE);

    /*
     * WARNING - void declaration
     */
    public static final <T, V extends AnimationVector> TwoWayConverter<T, V> TwoWayConverter(Function1<? super T, ? extends V> convertToVector, Function1<? super V, ? extends T> convertFromVector) {
        void var1_1;
        Function1<? super T, ? extends V> function1;
        Intrinsics.checkNotNullParameter(convertToVector, (String)"convertToVector");
        Intrinsics.checkNotNullParameter(convertFromVector, (String)"convertFromVector");
        return new TwoWayConverterImpl<T, V>(function1, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static final float lerp(float start, float stop2, float fraction) {
        void var2_2;
        void var1_1;
        return start * (1.0f - fraction) + var1_1 * var2_2;
    }

    public static final TwoWayConverter<Float, AnimationVector1D> getVectorConverter(FloatCompanionObject $this$VectorConverter) {
        Intrinsics.checkNotNullParameter((Object)$this$VectorConverter, (String)"<this>");
        return FloatToVector;
    }

    public static final TwoWayConverter<Integer, AnimationVector1D> getVectorConverter(IntCompanionObject $this$VectorConverter) {
        Intrinsics.checkNotNullParameter((Object)$this$VectorConverter, (String)"<this>");
        return IntToVector;
    }

    public static final TwoWayConverter<Rect, AnimationVector4D> getVectorConverter(Rect.Companion $this$VectorConverter) {
        Intrinsics.checkNotNullParameter((Object)$this$VectorConverter, (String)"<this>");
        return RectToVector;
    }

    public static final TwoWayConverter<Dp, AnimationVector1D> getVectorConverter(Dp.Companion $this$VectorConverter) {
        Intrinsics.checkNotNullParameter((Object)$this$VectorConverter, (String)"<this>");
        return DpToVector;
    }

    public static final TwoWayConverter<DpOffset, AnimationVector2D> getVectorConverter(DpOffset.Companion $this$VectorConverter) {
        Intrinsics.checkNotNullParameter((Object)$this$VectorConverter, (String)"<this>");
        return DpOffsetToVector;
    }

    public static final TwoWayConverter<Size, AnimationVector2D> getVectorConverter(Size.Companion $this$VectorConverter) {
        Intrinsics.checkNotNullParameter((Object)$this$VectorConverter, (String)"<this>");
        return SizeToVector;
    }

    public static final TwoWayConverter<Offset, AnimationVector2D> getVectorConverter(Offset.Companion $this$VectorConverter) {
        Intrinsics.checkNotNullParameter((Object)$this$VectorConverter, (String)"<this>");
        return OffsetToVector;
    }

    public static final TwoWayConverter<IntOffset, AnimationVector2D> getVectorConverter(IntOffset.Companion $this$VectorConverter) {
        Intrinsics.checkNotNullParameter((Object)$this$VectorConverter, (String)"<this>");
        return IntOffsetToVector;
    }

    public static final TwoWayConverter<IntSize, AnimationVector2D> getVectorConverter(IntSize.Companion $this$VectorConverter) {
        Intrinsics.checkNotNullParameter((Object)$this$VectorConverter, (String)"<this>");
        return IntSizeToVector;
    }
}

