/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.SpringSimulationKt;
import androidx.compose.runtime.internal.StabilityInferred;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@StabilityInferred(parameters=0)
public final class SpringSimulation {
    private float finalPosition = 1.0f;
    private double naturalFreq = Math.sqrt(50.0);
    private boolean initialized;
    private double gammaPlus;
    private double gammaMinus;
    private double dampedFreq;
    private float dampingRatio = 1.0f;
    public static final int $stable = 8;

    public SpringSimulation(float finalPosition) {
    }

    /*
     * WARNING - void declaration
     */
    public final void setFinalPosition(float f) {
        void var1_1;
        this.finalPosition = var1_1;
    }

    public final float getStiffness() {
        return (float)(this.naturalFreq * this.naturalFreq);
    }

    /*
     * WARNING - void declaration
     */
    public final void setStiffness(float value) {
        void var1_1;
        if (this.getStiffness() <= 0.0f) {
            throw new IllegalArgumentException("Spring stiffness constant must be positive.");
        }
        this.naturalFreq = Math.sqrt((double)var1_1);
        this.initialized = false;
    }

    public final float getDampingRatio() {
        return this.dampingRatio;
    }

    /*
     * WARNING - void declaration
     */
    public final void setDampingRatio(float value) {
        void var1_1;
        if (value < 0.0f) {
            throw new IllegalArgumentException("Damping ratio must be non-negative");
        }
        this.dampingRatio = var1_1;
        this.initialized = false;
    }

    /*
     * WARNING - void declaration
     */
    public final long updateValues-IJZedt4$animation_core(float lastDisplacement, float lastVelocity, long timeElapsed) {
        double currentVelocity;
        double displacement;
        void var3_3;
        SpringSimulation springSimulation = this;
        if (!springSimulation.initialized) {
            if (springSimulation.finalPosition == SpringSimulationKt.getUNSET()) {
                throw new IllegalStateException("Error: Final position of the spring must be set before the animation starts");
            }
            double d = (double)springSimulation.dampingRatio * (double)springSimulation.dampingRatio;
            if (springSimulation.dampingRatio > 1.0f) {
                springSimulation.gammaPlus = (double)(-springSimulation.dampingRatio) * springSimulation.naturalFreq + springSimulation.naturalFreq * Math.sqrt(d - 1.0);
                springSimulation.gammaMinus = (double)(-springSimulation.dampingRatio) * springSimulation.naturalFreq - springSimulation.naturalFreq * Math.sqrt(d - 1.0);
            } else if (springSimulation.dampingRatio >= 0.0f && springSimulation.dampingRatio < 1.0f) {
                springSimulation.dampedFreq = springSimulation.naturalFreq * Math.sqrt(1.0 - d);
            }
            springSimulation.initialized = true;
        }
        float adjustedDisplacement = lastDisplacement - this.finalPosition;
        double deltaT = (double)var3_3 / 1000.0;
        if (this.dampingRatio > 1.0f) {
            double coeffA = (double)adjustedDisplacement - (this.gammaMinus * (double)adjustedDisplacement - (double)lastVelocity) / (this.gammaMinus - this.gammaPlus);
            double coeffB = (this.gammaMinus * (double)adjustedDisplacement - (double)lastVelocity) / (this.gammaMinus - this.gammaPlus);
            displacement = coeffA * Math.exp(this.gammaMinus * deltaT) + coeffB * Math.exp(this.gammaPlus * deltaT);
            currentVelocity = coeffA * this.gammaMinus * Math.exp(this.gammaMinus * deltaT) + coeffB * this.gammaPlus * Math.exp(this.gammaPlus * deltaT);
        } else if (this.dampingRatio == 1.0f) {
            float coeffA = adjustedDisplacement;
            double coeffB = (double)lastVelocity + this.naturalFreq * (double)adjustedDisplacement;
            displacement = ((double)coeffA + coeffB * deltaT) * Math.exp(-this.naturalFreq * deltaT);
            currentVelocity = ((double)coeffA + coeffB * deltaT) * Math.exp(-this.naturalFreq * deltaT) * -this.naturalFreq + coeffB * Math.exp(-this.naturalFreq * deltaT);
        } else {
            void var2_2;
            void var1_1;
            float cosCoeff = adjustedDisplacement;
            double sinCoeff = 1.0 / this.dampedFreq * ((double)this.dampingRatio * this.naturalFreq * (double)var1_1 + (double)var2_2);
            displacement = Math.exp((double)(-this.dampingRatio) * this.naturalFreq * deltaT) * ((double)cosCoeff * Math.cos(this.dampedFreq * deltaT) + sinCoeff * Math.sin(this.dampedFreq * deltaT));
            currentVelocity = displacement * -this.naturalFreq * (double)this.dampingRatio + Math.exp((double)(-this.dampingRatio) * this.naturalFreq * deltaT) * (-this.dampedFreq * (double)cosCoeff * Math.sin(this.dampedFreq * deltaT) + this.dampedFreq * sinCoeff * Math.cos(this.dampedFreq * deltaT));
        }
        float newValue = (float)(displacement + (double)this.finalPosition);
        float newVelocity = (float)currentVelocity;
        return SpringSimulationKt.Motion(newValue, newVelocity);
    }
}

