/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.Easing;
import androidx.compose.animation.core.EasingKt;
import androidx.compose.animation.core.FloatAnimationSpec;
import androidx.compose.animation.core.VectorConvertersKt;
import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\r\b\u0007\u0018\u00002\u00020\u0001B%\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ'\u0010\u0011\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J/\u0010\u0013\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J/\u0010\u0015\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0014R\u0014\u0010\u0004\u001a\u00020\u00028\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\t8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0003\u001a\u00020\u00028\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0016R\u0014\u0010\u0019\u001a\u00020\t8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u0018R\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u001a"}, d2={"Landroidx/compose/animation/core/FloatTweenSpec;", "Landroidx/compose/animation/core/FloatAnimationSpec;", "", "duration", "delay", "Landroidx/compose/animation/core/Easing;", "easing", "<init>", "(IILandroidx/compose/animation/core/Easing;)V", "", "playTimeNanos", "clampPlayTimeNanos", "(J)J", "", "initialValue", "targetValue", "initialVelocity", "getDurationNanos", "(FFF)J", "getValueFromNanos", "(JFFF)F", "getVelocityFromNanos", "I", "delayNanos", "J", "durationNanos", "Landroidx/compose/animation/core/Easing;"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nFloatAnimationSpec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FloatAnimationSpec.kt\nandroidx/compose/animation/core/FloatTweenSpec\n+ 2 MathHelpers.kt\nandroidx/compose/ui/util/MathHelpersKt\n*L\n1#1,265:1\n71#2,16:266\n*S KotlinDebug\n*F\n+ 1 FloatAnimationSpec.kt\nandroidx/compose/animation/core/FloatTweenSpec\n*L\n218#1:266,16\n*E\n"})
public final class FloatTweenSpec
implements FloatAnimationSpec {
    public final int duration;
    public final int delay;
    private final Easing easing;
    private final long durationNanos;
    private final long delayNanos;

    /*
     * WARNING - void declaration
     */
    public FloatTweenSpec(int duration, int delay, Easing easing) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)easing, (String)"easing");
        this.duration = var1_1;
        this.delay = var2_2;
        this.easing = var3_3;
        this.durationNanos = (long)this.duration * 1000000L;
        this.delayNanos = (long)this.delay * 1000000L;
    }

    public /* synthetic */ FloatTweenSpec(int n, int n2, Easing easing, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = 300;
        }
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        if ((n3 & 4) != 0) {
            easing = EasingKt.getFastOutSlowInEasing();
        }
        this(n, n2, easing);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final float getValueFromNanos(long playTimeNanos, float initialValue, float targetValue, float initialVelocity) {
        void var1_2;
        void var3_3;
        float f;
        float rawFraction;
        long clampedPlayTimeNanos = this.clampPlayTimeNanos(playTimeNanos);
        float $this$fastCoerceAtLeast$iv$iv = rawFraction = this.duration == 0 ? 1.0f : (float)clampedPlayTimeNanos / (float)this.durationNanos;
        float $this$fastCoerceAtMost$iv$iv = f < 0.0f ? 0.0f : $this$fastCoerceAtLeast$iv$iv;
        float fraction = this.easing.transform($this$fastCoerceAtMost$iv$iv > 1.0f ? 1.0f : $this$fastCoerceAtMost$iv$iv);
        return VectorConvertersKt.lerp((float)var3_3, targetValue, (float)var1_2);
    }

    private final long clampPlayTimeNanos(long playTimeNanos) {
        return RangesKt.coerceIn((long)(playTimeNanos - this.delayNanos), (long)0L, (long)this.durationNanos);
    }

    @Override
    public final long getDurationNanos(float initialValue, float targetValue, float initialVelocity) {
        return (long)(this.delay + this.duration) * 1000000L;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final float getVelocityFromNanos(long playTimeNanos, float initialValue, float targetValue, float initialVelocity) {
        void var1_2;
        void var3_3;
        long clampedPlayTimeNanos = this.clampPlayTimeNanos(playTimeNanos);
        if (clampedPlayTimeNanos < 0L) {
            return 0.0f;
        }
        if (clampedPlayTimeNanos == 0L) {
            return initialVelocity;
        }
        float startNum = this.getValueFromNanos(clampedPlayTimeNanos - 1000000L, initialValue, targetValue, initialVelocity);
        float f = this.getValueFromNanos(clampedPlayTimeNanos, (float)var3_3, targetValue, initialVelocity);
        return (f - var1_2) * 1000.0f;
    }

    public FloatTweenSpec() {
        this(0, 0, null, 7, null);
    }
}

