/*
 * Decompiled with CFR 0.152.
 */
package shared.system.runtime;

import java.util.Collection;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import shared.system.install.JvmInstallationKt;
import shared.system.os.DesktopArchitecture;
import shared.system.os.DesktopArchitectureKt;
import shared.system.os.DesktopOS;
import shared.system.os.DesktopOSKt;
import shared.system.process.DesktopSystemKt;

@SourceDebugExtension(value={"SMAP\nJvmRuntime.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmRuntime.kt\nshared/system/runtime/JvmRuntimeKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,35:1\n1755#2,3:36\n*S KotlinDebug\n*F\n+ 1 JvmRuntime.kt\nshared/system/runtime/JvmRuntimeKt\n*L\n32#1:36,3\n*E\n"})
public final class JvmRuntimeKt {
    private static final Lazy currentJvmArchitecture$delegate = LazyKt.lazy(JvmRuntimeKt::currentJvmArchitecture_delegate$lambda$0);
    private static final Lazy currentJvmRuntimeDisplayName$delegate = LazyKt.lazy(JvmRuntimeKt::currentJvmRuntimeDisplayName_delegate$lambda$1);

    public static final DesktopArchitecture getCurrentJvmArchitecture() {
        Lazy lazy = currentJvmArchitecture$delegate;
        return (DesktopArchitecture)((Object)lazy.getValue());
    }

    private static final DesktopArchitecture currentJvmArchitecture_delegate$lambda$0() {
        switch (WhenMappings.$EnumSwitchMapping$0[DesktopOSKt.getCurrentDesktopOS().ordinal()]) {
            case 1: {
                return DesktopArchitectureKt.getCurrentDesktopArchitecture();
            }
            case 2: {
                return DesktopArchitectureKt.getCurrentDesktopArchitecture();
            }
            case 3: {
                String[] stringArray = new String[2];
                String[] stringArray2 = stringArray;
                stringArray[0] = "file";
                stringArray2[1] = JvmInstallationKt.getOwnExecutable().getAbsolutePath();
                return (DesktopArchitecture)((Object)DesktopSystemKt.systemCommandLineOutputOf(stringArray2, JvmRuntimeKt::fromProbingOwnExecutable$lambda$3));
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    private static final String currentJvmRuntimeDisplayName_delegate$lambda$1() {
        return "Java " + System.getProperty("java.version") + "/" + JvmRuntimeKt.getCurrentJvmArchitecture() + " - " + DesktopOSKt.getCurrentDesktopOS() + "/" + DesktopArchitectureKt.getCurrentDesktopArchitecture();
    }

    private static final DesktopArchitecture fromProbingOwnExecutable$lambda$3(String output) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        if (StringsKt.contains((CharSequence)output, (CharSequence)"aarch64", (boolean)true)) {
            return DesktopArchitecture.aarch64;
        }
        Object[] objectArray = new String[3];
        Object object = objectArray;
        objectArray[0] = "x64";
        object[1] = "x86_64";
        object[2] = "amd64";
        Iterable $this$any$iv = CollectionsKt.listOf((Object[])object);
        if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) {
            object = object.iterator();
            while (object.hasNext()) {
                Object e = object.next();
                String it = (String)e;
                if (!StringsKt.contains((CharSequence)output, (CharSequence)((CharSequence)e), (boolean)true)) continue;
                bl = true;
                break;
            }
        } else {
            bl = false;
        }
        if (bl) {
            return DesktopArchitecture.x64;
        }
        return DesktopArchitecture.Unknown;
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DesktopOS.values().length];
            try {
                nArray[DesktopOS.Linux.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[DesktopOS.Windows.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[DesktopOS.Mac.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

