/*
 * Decompiled with CFR 0.152.
 */
package shared.system.process;

import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import shared.system.process.SystemCommandLineException;

public final class DesktopSystemKt {
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(DesktopSystemKt::logger$lambda$0);

    /*
     * WARNING - void declaration
     */
    public static final <T> T systemCommandLineOutputOf(String[] commandLine, Function1<? super String, ? extends T> outputTransform) {
        void var1_1;
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter(outputTransform, (String)"outputTransform");
        return DesktopSystemKt.systemCommandLineOutputOf(ArraysKt.toList((Object[])stringArray), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static final <T> T systemCommandLineOutputOf(List<String> commandLine, Function1<? super String, ? extends T> outputTransform) {
        void var1_5;
        void var2_6;
        int n;
        Intrinsics.checkNotNullParameter(commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter(outputTransform, (String)"outputTransform");
        logger.trace(() -> DesktopSystemKt.systemCommandLineOutputOf$lambda$1(commandLine));
        StringBuilder output = new StringBuilder();
        try {
            Iterator iterator;
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            pb.command(commandLine);
            pb.redirectErrorStream(true);
            Process p = ((ProcessBuilder)((Object)iterator)).start();
            iterator = p.inputReader().lines().iterator();
            while (iterator.hasNext()) {
                String line = (String)iterator.next();
                output.append(line).append('\n');
            }
            p.waitFor();
            n = p.exitValue();
        }
        catch (IllegalArgumentException ex) {
            String string = output.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            throw new SystemCommandLineException(string, null, ex, 2, null);
        }
        catch (IOException ex) {
            String string = output.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            throw new SystemCommandLineException(string, null, ex, 2, null);
        }
        catch (InterruptedException ex) {
            String string = output.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            throw new SystemCommandLineException(string, null, ex, 2, null);
        }
        int exit = n;
        if (exit != 0) {
            void var0_4;
            String string = output.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            throw new SystemCommandLineException(string, (int)var0_4, null, 4, null);
        }
        String string = var2_6.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return (T)var1_5.invoke((Object)((Object)StringsKt.trim((CharSequence)string)).toString());
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object systemCommandLineOutputOf$lambda$1(List $commandLine) {
        return CollectionsKt.joinToString$default((Iterable)$commandLine, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }
}

