/*
 * Decompiled with CFR 0.152.
 */
package shared.system.os;

import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.jvm.internal.Intrinsics;
import shared.system.os.DesktopArchitecture;

public final class DesktopArchitectureKt {
    private static final Lazy currentDesktopArchitecture$delegate = LazyKt.lazy(DesktopArchitectureKt::currentDesktopArchitecture_delegate$lambda$0);

    public static final DesktopArchitecture getCurrentDesktopArchitecture() {
        Lazy lazy = currentDesktopArchitecture$delegate;
        return (DesktopArchitecture)((Object)lazy.getValue());
    }

    private static final DesktopArchitecture currentDesktopArchitecture_delegate$lambda$0() {
        String string = System.getProperty("os.arch");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String string3 = string2;
        int n = -1;
        switch (string2.hashCode()) {
            case -1221096139: {
                if (string3.equals("aarch64")) {
                    n = 1;
                }
                break;
            }
            case -806050265: {
                if (string3.equals("x86_64")) {
                    n = 2;
                }
                break;
            }
            case 117046: {
                if (string3.equals("x64")) {
                    n = 2;
                }
                break;
            }
            case 92926582: {
                if (string3.equals("amd64")) {
                    n = 2;
                }
                break;
            }
        }
        switch (n) {
            case 1: {
                return DesktopArchitecture.aarch64;
            }
            case 2: {
                return DesktopArchitecture.x64;
            }
        }
        return DesktopArchitecture.Unknown;
    }
}

