/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls.cipher;

import io.ktor.network.tls.CipherSuite;
import io.ktor.network.tls.TLSRecord;
import io.ktor.network.tls.cipher.CipherUtilsKt;
import io.ktor.network.tls.cipher.GCMCipherKt;
import io.ktor.network.tls.cipher.TLSCipher;
import io.ktor.utils.io.core.ByteReadPacketKt;
import javax.crypto.Cipher;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.io.Sink;
import kotlinx.io.Source;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\f\u0010\u000bR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\rR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u000eR\u0016\u0010\u0010\u001a\u00020\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\u00020\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0011"}, d2={"Lio/ktor/network/tls/cipher/GCMCipher;", "Lio/ktor/network/tls/cipher/TLSCipher;", "Lio/ktor/network/tls/CipherSuite;", "suite", "", "keyMaterial", "<init>", "(Lio/ktor/network/tls/CipherSuite;[B)V", "Lio/ktor/network/tls/TLSRecord;", "record", "encrypt", "(Lio/ktor/network/tls/TLSRecord;)Lio/ktor/network/tls/TLSRecord;", "decrypt", "Lio/ktor/network/tls/CipherSuite;", "[B", "", "inputCounter", "J", "outputCounter"})
public final class GCMCipher
implements TLSCipher {
    private final CipherSuite suite;
    private final byte[] keyMaterial;
    private long inputCounter;
    private long outputCounter;

    /*
     * WARNING - void declaration
     */
    public GCMCipher(CipherSuite suite, byte[] keyMaterial) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)suite, (String)"suite");
        Intrinsics.checkNotNullParameter((Object)keyMaterial, (String)"keyMaterial");
        this.suite = var1_1;
        this.keyMaterial = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final TLSRecord encrypt(TLSRecord record) {
        void var2_2;
        void var1_1;
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        Cipher cipher = GCMCipherKt.access$gcmEncryptCipher(this.suite, this.keyMaterial, record.getType(), (int)ByteReadPacketKt.getRemaining((Source)record.getPacket()), this.outputCounter, this.outputCounter);
        long packetId = this.outputCounter;
        Source packet = CipherUtilsKt.cipherLoop(record.getPacket(), cipher, (Function1<? super Sink, Unit>)((Function1)arg_0 -> GCMCipher.encrypt$lambda$0((long)var3_3, arg_0)));
        long l = this.outputCounter;
        this.outputCounter = l + 1L;
        return new TLSRecord(var1_1.getType(), null, (Source)var2_2, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final TLSRecord decrypt(TLSRecord record) {
        void var3_4;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        Source packet = record.getPacket();
        long packetSize = ByteReadPacketKt.getRemaining((Source)packet);
        long recordIv = packet.readLong();
        long l = this.inputCounter;
        this.inputCounter = l + 1L;
        Cipher cipher = GCMCipherKt.access$gcmDecryptCipher(this.suite, this.keyMaterial, record.getType(), (int)packetSize, recordIv, l);
        return new TLSRecord(record.getType(), var1_1.getVersion(), CipherUtilsKt.cipherLoop$default((Source)var2_2, (Cipher)var3_4, null, 2, null));
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit encrypt$lambda$0(long $packetId, Sink $this$cipherLoop) {
        long l;
        void var2_1;
        Intrinsics.checkNotNullParameter((Object)$this$cipherLoop, (String)"$this$cipherLoop");
        var2_1.writeLong(l);
        return Unit.INSTANCE;
    }
}

