/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls;

import io.ktor.network.tls.CertificateInfo;
import io.ktor.network.tls.EncryptionInfo;
import io.ktor.network.tls.extensions.HashAndSign;
import io.ktor.network.tls.extensions.NamedCurve;
import io.ktor.network.tls.extensions.SignatureAlgorithmKt;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.Source;
import kotlinx.io.SourcesKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0013\u0010\u0002\u001a\u00020\u0001*\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\n\u001a\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000bH\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000f"}, d2={"Ljava/security/SecureRandom;", "", "generateClientSeed", "(Ljava/security/SecureRandom;)[B", "Lio/ktor/network/tls/extensions/NamedCurve;", "curve", "Ljava/security/spec/ECPoint;", "serverPoint", "Lio/ktor/network/tls/EncryptionInfo;", "generateECKeys", "(Lio/ktor/network/tls/extensions/NamedCurve;Ljava/security/spec/ECPoint;)Lio/ktor/network/tls/EncryptionInfo;", "Lkotlinx/io/Source;", "packet", "Lio/ktor/network/tls/CertificateInfo;", "readClientCertificateRequest", "(Lkotlinx/io/Source;)Lio/ktor/network/tls/CertificateInfo;"})
@SourceDebugExtension(value={"SMAP\nTLSClientHandshake.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TLSClientHandshake.kt\nio/ktor/network/tls/TLSClientHandshakeKt\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,553:1\n37#2,2:554\n*S KotlinDebug\n*F\n+ 1 TLSClientHandshake.kt\nio/ktor/network/tls/TLSClientHandshakeKt\n*L\n549#1:554,2\n*E\n"})
public final class TLSClientHandshakeKt {
    private static final byte[] generateClientSeed(SecureRandom $this$generateClientSeed) {
        Object object;
        byte[] seed = new byte[32];
        ((SecureRandom)object).nextBytes(seed);
        object = seed;
        byte[] it = seed;
        long unixTime = System.currentTimeMillis() / 1000L;
        it[0] = (byte)(unixTime >> 24);
        it[1] = (byte)(unixTime >> 16);
        it[2] = (byte)(unixTime >> 8);
        var1_1[3] = (byte)(unixTime >> 0);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private static final EncryptionInfo generateECKeys(NamedCurve curve, ECPoint serverPoint) {
        void var1_1;
        KeyPair keyPair;
        void var2_3;
        KeyFactory keyFactory;
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC");
        Intrinsics.checkNotNull((Object)keyPairGenerator);
        KeyPairGenerator $this$generateECKeys_u24lambda_u241 = keyPairGenerator;
        keyPairGenerator.initialize(new ECGenParameterSpec(curve.name()));
        KeyPair keyPair2 = ((KeyPairGenerator)((Object)keyFactory)).generateKeyPair();
        Intrinsics.checkNotNull((Object)keyPair2);
        KeyPair clientKeys = keyPair2;
        PublicKey publicKey = keyPair2.getPublic();
        Intrinsics.checkNotNull((Object)publicKey, (String)"null cannot be cast to non-null type java.security.interfaces.ECPublicKey");
        ECPublicKey publicKey2 = (ECPublicKey)publicKey;
        KeyFactory keyFactory2 = KeyFactory.getInstance("EC");
        Intrinsics.checkNotNull((Object)keyFactory2);
        keyFactory = keyFactory2;
        ECParameterSpec eCParameterSpec = var2_3.getParams();
        Intrinsics.checkNotNull((Object)eCParameterSpec);
        PublicKey publicKey3 = keyFactory2.generatePublic(new ECPublicKeySpec(serverPoint, eCParameterSpec));
        Intrinsics.checkNotNull((Object)publicKey3);
        PublicKey serverPublic = publicKey3;
        PublicKey publicKey4 = clientKeys.getPublic();
        Intrinsics.checkNotNullExpressionValue((Object)publicKey4, (String)"getPublic(...)");
        PrivateKey privateKey = keyPair.getPrivate();
        Intrinsics.checkNotNullExpressionValue((Object)privateKey, (String)"getPrivate(...)");
        return new EncryptionInfo((PublicKey)var1_1, publicKey4, privateKey);
    }

    /*
     * WARNING - void declaration
     */
    public static final CertificateInfo readClientCertificateRequest(Source packet) {
        Source source;
        void var1_2;
        void var3_4;
        Collection collection;
        int size;
        Collection collection2;
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        int typeCount = packet.readByte() & 0xFF;
        byte[] types = SourcesKt.readByteArray((Source)packet, (int)typeCount);
        int hashAndSignCount = packet.readShort() & 0xFFFF;
        List hashAndSign = new ArrayList();
        hashAndSignCount /= 2;
        for (int i = 0; i < hashAndSignCount; ++i) {
            byte hash = packet.readByte();
            byte sign = packet.readByte();
            collection2 = hashAndSign;
            HashAndSign hashAndSign2 = SignatureAlgorithmKt.byCode(HashAndSign.Companion, hash, sign);
            if (hashAndSign2 == null) continue;
            collection2.add(hashAndSign2);
        }
        int authoritiesSize = packet.readShort() & 0xFFFF;
        Set authorities = new LinkedHashSet();
        for (int position = 0; position < authoritiesSize; position += size + 2) {
            size = packet.readShort() & 0xFFFF;
            byte[] authority = SourcesKt.readByteArray((Source)packet, (int)size);
            ((Collection)authorities).add(new X500Principal(authority));
        }
        collection2 = collection = (Collection)var3_4;
        Object certificateInfo = new CertificateInfo((byte[])var1_2, collection.toArray(new HashAndSign[0]), authorities);
        if (!source.exhausted()) {
            certificateInfo = "Check failed.";
            throw new IllegalStateException(certificateInfo.toString());
        }
        return certificateInfo;
    }

    public static final /* synthetic */ byte[] access$generateClientSeed(SecureRandom $receiver) {
        return TLSClientHandshakeKt.generateClientSeed($receiver);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ EncryptionInfo access$generateECKeys(NamedCurve curve, ECPoint serverPoint) {
        void var1_1;
        return TLSClientHandshakeKt.generateECKeys(curve, (ECPoint)var1_1);
    }
}

