/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.internal.debugmeta;

import io.sentry.ILogger;
import io.sentry.SentryLevel;
import io.sentry.internal.debugmeta.IDebugMetaLoader;
import io.sentry.util.ClassLoaderUtils;
import io.sentry.util.DebugMetaPropertiesApplier;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

public final class ResourcesDebugMetaLoader
implements IDebugMetaLoader {
    private final ILogger logger;
    private final ClassLoader classLoader;

    /*
     * WARNING - void declaration
     */
    public ResourcesDebugMetaLoader(ILogger logger) {
        this((ILogger)var1_1, ResourcesDebugMetaLoader.class.getClassLoader());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private ResourcesDebugMetaLoader(ILogger logger, ClassLoader classLoader) {
        void var2_2;
        void var1_1;
        this.logger = var1_1;
        this.classLoader = ClassLoaderUtils.classLoaderOrDefault((ClassLoader)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final List<Properties> loadDebugMeta() {
        void var1_1;
        ArrayList<Properties> debugPropertyList = new ArrayList<Properties>();
        try {
            Enumeration<URL> resourceUrls = this.classLoader.getResources(DebugMetaPropertiesApplier.DEBUG_META_PROPERTIES_FILENAME);
            while (resourceUrls.hasMoreElements()) {
                URL currentUrl = resourceUrls.nextElement();
                try {
                    InputStream is = currentUrl.openStream();
                    try {
                        Properties currentProperties = new Properties();
                        currentProperties.load(is);
                        debugPropertyList.add(currentProperties);
                        this.logger.log(SentryLevel.INFO, "Debug Meta Data Properties loaded from %s", currentUrl);
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
                catch (RuntimeException e) {
                    void var3_4;
                    this.logger.log(SentryLevel.ERROR, e, "%s file is malformed.", var3_4);
                }
            }
        }
        catch (IOException e) {
            void var2_3;
            this.logger.log(SentryLevel.ERROR, (Throwable)var2_3, "Failed to load %s", DebugMetaPropertiesApplier.DEBUG_META_PROPERTIES_FILENAME);
        }
        if (debugPropertyList.isEmpty()) {
            this.logger.log(SentryLevel.INFO, "No %s file was found.", DebugMetaPropertiesApplier.DEBUG_META_PROPERTIES_FILENAME);
            return null;
        }
        return var1_1;
    }
}

