/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.config;

import io.sentry.config.PropertiesProvider;
import io.sentry.util.StringUtils;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

final class EnvironmentVariablePropertiesProvider
implements PropertiesProvider {
    EnvironmentVariablePropertiesProvider() {
    }

    @Override
    public final String getProperty(String property) {
        return StringUtils.removeSurrounding(System.getenv(EnvironmentVariablePropertiesProvider.propertyToEnvironmentVariableName(property)), "\"");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Map<String, String> getMap(String property) {
        void var2_2;
        String prefix = EnvironmentVariablePropertiesProvider.propertyToEnvironmentVariableName(property) + "_";
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            String value;
            String key = entry.getKey();
            if (!key.startsWith(prefix) || (value = StringUtils.removeSurrounding(entry.getValue(), "\"")) == null) continue;
            result.put(key.substring(prefix.length()).toLowerCase(Locale.ROOT), value);
        }
        return var2_2;
    }

    private static String propertyToEnvironmentVariableName(String property) {
        String string;
        return "SENTRY_" + string.replace(".", "_").replace("-", "_").toUpperCase(Locale.ROOT);
    }
}

