/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.config;

import io.sentry.ILogger;
import io.sentry.SentryLevel;
import io.sentry.SystemOutLogger;
import io.sentry.util.ClassLoaderUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

final class ClasspathPropertiesLoader {
    private final String fileName;
    private final ClassLoader classLoader;
    private final ILogger logger;

    /*
     * WARNING - void declaration
     */
    private ClasspathPropertiesLoader(String fileName, ClassLoader classLoader, ILogger logger) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.fileName = var1_1;
        this.classLoader = ClassLoaderUtils.classLoaderOrDefault((ClassLoader)var2_2);
        this.logger = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public ClasspathPropertiesLoader(SystemOutLogger logger) {
        this("sentry.properties", ClasspathPropertiesLoader.class.getClassLoader(), (ILogger)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive exception aggregation
     */
    public final Properties load() {
        block13: {
            try (InputStream inputStream = this.classLoader.getResourceAsStream(this.fileName);){
                void var4_8;
                if (inputStream == null) break block13;
                BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                try {
                    void var3_5;
                    Properties properties = new Properties();
                    properties.load(bufferedInputStream);
                    var4_8 = var3_5;
                }
                catch (Throwable throwable) {
                    try {
                        void var2_3;
                        var2_3.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                bufferedInputStream.close();
                return var4_8;
            }
            catch (IOException e) {
                void var1_2;
                this.logger.log(SentryLevel.ERROR, (Throwable)var1_2, "Failed to load Sentry configuration from classpath resource: %s", this.fileName);
                return null;
            }
        }
        return null;
    }
}

