/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.backpressure;

import io.sentry.HubAdapter;
import io.sentry.IHub;
import io.sentry.ISentryExecutorService;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.backpressure.IBackpressureMonitor;

public final class BackpressureMonitor
implements IBackpressureMonitor,
Runnable {
    private final SentryOptions sentryOptions;
    private final IHub hub;
    private int downsampleFactor = 0;

    /*
     * WARNING - void declaration
     */
    public BackpressureMonitor(SentryOptions sentryOptions, HubAdapter hub) {
        void var2_2;
        void var1_1;
        this.sentryOptions = var1_1;
        this.hub = var2_2;
    }

    @Override
    public final void start() {
        this.reschedule(500);
    }

    @Override
    public final void run() {
        BackpressureMonitor backpressureMonitor;
        BackpressureMonitor backpressureMonitor2 = backpressureMonitor = this;
        if (backpressureMonitor.hub.isHealthy()) {
            if (backpressureMonitor.downsampleFactor > 0) {
                backpressureMonitor.sentryOptions.getLogger().log(SentryLevel.DEBUG, "Health check positive, reverting to normal sampling.", new Object[0]);
            }
            backpressureMonitor.downsampleFactor = 0;
        } else if (backpressureMonitor.downsampleFactor < 10) {
            ++backpressureMonitor.downsampleFactor;
            backpressureMonitor.sentryOptions.getLogger().log(SentryLevel.DEBUG, "Health check negative, downsampling with a factor of %d", backpressureMonitor.downsampleFactor);
        }
        this.reschedule(10000);
    }

    @Override
    public final int getDownsampleFactor() {
        return this.downsampleFactor;
    }

    /*
     * WARNING - void declaration
     */
    private void reschedule(int delay) {
        ISentryExecutorService executorService = this.sentryOptions.getExecutorService();
        if (!executorService.isClosed()) {
            void var1_1;
            void var2_2;
            var2_2.schedule(this, (long)var1_1);
        }
    }
}

