/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.HubAdapter;
import io.sentry.ILogger;
import io.sentry.ISentryExecutorService;
import io.sentry.Integration;
import io.sentry.NoOpLogger;
import io.sentry.NoOpSentryExecutorService;
import io.sentry.SentryEnvelope;
import io.sentry.SentryExecutorService;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.util.Platform;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLConnection;
import java.util.concurrent.RejectedExecutionException;
import java.util.zip.GZIPOutputStream;

public final class SpotlightIntegration
implements Integration,
SentryOptions.BeforeEnvelopeCallback,
Closeable {
    private SentryOptions options;
    private ILogger logger = NoOpLogger.getInstance();
    private ISentryExecutorService executorService = NoOpSentryExecutorService.getInstance$6fecc271();

    /*
     * WARNING - void declaration
     */
    @Override
    public final void register$32abd998(HubAdapter hub, SentryOptions options) {
        this.options = options;
        this.logger = options.getLogger();
        if (options.getBeforeEnvelopeCallback() == null && options.isEnableSpotlight()) {
            void var2_2;
            this.executorService = new SentryExecutorService();
            var2_2.setBeforeEnvelopeCallback$19b2053c(this);
            this.logger.log(SentryLevel.DEBUG, "SpotlightIntegration enabled.", new Object[0]);
            return;
        }
        this.logger.log(SentryLevel.DEBUG, "SpotlightIntegration is not enabled. BeforeEnvelopeCallback is already set or spotlight is not enabled.", new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void execute$74b70ef(SentryEnvelope envelope) {
        try {
            this.executorService.submit(() -> {
                block19: {
                    SpotlightIntegration spotlightIntegration;
                    void var2_2 = spotlightIntegration;
                    spotlightIntegration = this;
                    try {
                        if (spotlightIntegration.options == null) {
                            throw new IllegalArgumentException("SentryOptions are required to send envelopes.");
                        }
                        Object object = spotlightIntegration;
                        String string = ((SpotlightIntegration)object).options != null && ((SpotlightIntegration)object).options.getSpotlightConnectionUrl() != null ? ((SpotlightIntegration)object).options.getSpotlightConnectionUrl() : (Platform.isAndroid() ? "http://10.0.2.2:8969/stream" : "http://localhost:8969/stream");
                        object = string;
                        object = string;
                        object = (HttpURLConnection)URI.create(string).toURL().openConnection();
                        ((URLConnection)object).setReadTimeout(1000);
                        ((URLConnection)object).setConnectTimeout(1000);
                        ((HttpURLConnection)object).setRequestMethod("POST");
                        ((URLConnection)object).setDoOutput(true);
                        ((URLConnection)object).setRequestProperty("Content-Encoding", "gzip");
                        ((URLConnection)object).setRequestProperty("Content-Type", "application/x-sentry-envelope");
                        ((URLConnection)object).setRequestProperty("Accept", "application/json");
                        ((URLConnection)object).setRequestProperty("Connection", "close");
                        ((URLConnection)object).connect();
                        try (OutputStream outputStream = ((URLConnection)object).getOutputStream();
                             GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(outputStream);){
                            spotlightIntegration.options.getSerializer().serialize((SentryEnvelope)var2_2, gZIPOutputStream);
                        }
                        catch (Throwable throwable) {
                            try {
                                spotlightIntegration.logger.log(SentryLevel.ERROR, "An exception occurred while submitting the envelope to the Sentry server.", throwable);
                            }
                            catch (Throwable throwable2) {
                                int n = ((HttpURLConnection)object).getResponseCode();
                                spotlightIntegration.logger.log(SentryLevel.DEBUG, "Envelope sent to spotlight: %d", n);
                                SpotlightIntegration.closeAndDisconnect((HttpURLConnection)object);
                                throw throwable2;
                            }
                            int n = ((HttpURLConnection)object).getResponseCode();
                            spotlightIntegration.logger.log(SentryLevel.DEBUG, "Envelope sent to spotlight: %d", n);
                            SpotlightIntegration.closeAndDisconnect((HttpURLConnection)object);
                            break block19;
                        }
                        int n = ((HttpURLConnection)object).getResponseCode();
                        spotlightIntegration.logger.log(SentryLevel.DEBUG, "Envelope sent to spotlight: %d", n);
                        SpotlightIntegration.closeAndDisconnect((HttpURLConnection)object);
                    }
                    catch (Exception exception) {
                        spotlightIntegration.logger.log(SentryLevel.ERROR, "An exception occurred while creating the connection to spotlight.", exception);
                    }
                }
            });
            return;
        }
        catch (RejectedExecutionException e) {
            void var1_2;
            this.logger.log(SentryLevel.WARNING, "Spotlight envelope submission rejected.", (Throwable)var1_2);
            return;
        }
    }

    private static void closeAndDisconnect(HttpURLConnection connection) {
        try {
            connection.getInputStream().close();
            connection.disconnect();
            return;
        }
        catch (IOException iOException) {
            connection.disconnect();
            return;
        }
        catch (Throwable throwable) {
            HttpURLConnection httpURLConnection;
            httpURLConnection.disconnect();
            throw throwable;
        }
    }

    @Override
    public final void close() throws IOException {
        this.executorService.close(0L);
        if (this.options != null && this.options.getBeforeEnvelopeCallback() == this) {
            this.options.setBeforeEnvelopeCallback$19b2053c(null);
        }
    }
}

