/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.SentryOptions;
import io.sentry.protocol.SentryStackFrame;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class SentryStackTraceFactory {
    private final SentryOptions options;

    /*
     * WARNING - void declaration
     */
    public SentryStackTraceFactory(SentryOptions options) {
        void var1_1;
        this.options = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final List<SentryStackFrame> getStackFrames(StackTraceElement[] elements, boolean includeSentryFrames) {
        void var3_3;
        ArrayList<SentryStackFrame> sentryStackFrames = null;
        if (elements != null && elements.length > 0) {
            void var1_1;
            sentryStackFrames = new ArrayList<SentryStackFrame>();
            for (void item : var1_1) {
                if (item == null) continue;
                String className = item.getClassName();
                if (!includeSentryFrames && className.startsWith("io.sentry.") && !className.startsWith("io.sentry.samples.") && !className.startsWith("io.sentry.mobile.")) continue;
                SentryStackFrame sentryStackFrame = new SentryStackFrame();
                sentryStackFrame.setInApp(this.isInApp(className));
                sentryStackFrame.setModule(className);
                sentryStackFrame.setFunction(item.getMethodName());
                sentryStackFrame.setFilename(item.getFileName());
                if (item.getLineNumber() >= 0) {
                    sentryStackFrame.setLineno(item.getLineNumber());
                }
                sentryStackFrame.setNative(item.isNativeMethod());
                sentryStackFrames.add(sentryStackFrame);
                if (sentryStackFrames.size() >= 100) break;
            }
            Collections.reverse(sentryStackFrames);
        }
        return var3_3;
    }

    private Boolean isInApp(String className) {
        if (className == null || className.isEmpty()) {
            return Boolean.TRUE;
        }
        List<String> list = this.options.getInAppIncludes();
        for (String include : list) {
            Iterator<String> iterator;
            if (!className.startsWith((String)((Object)iterator))) continue;
            return Boolean.TRUE;
        }
        list = this.options.getInAppExcludes();
        for (String exclude : list) {
            if (!className.startsWith((String)((Object)list))) continue;
            return Boolean.FALSE;
        }
        return null;
    }
}

