/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public final class SentryReplayOptions {
    private Double onErrorSampleRate;
    private Set<String> maskViewClasses = new CopyOnWriteArraySet<String>();
    private Set<String> unmaskViewClasses = new CopyOnWriteArraySet<String>();
    private SentryReplayQuality quality = SentryReplayQuality.MEDIUM;
    private int frameRate = 1;
    private long errorReplayDuration = 30000L;
    private long sessionSegmentDuration = 5000L;
    private long sessionDuration = 3600000L;

    public SentryReplayOptions(boolean empty) {
        boolean bl;
        if (!bl) {
            bl = true;
            SentryReplayOptions sentryReplayOptions = this;
            sentryReplayOptions.addMaskViewClass("android.widget.TextView");
            sentryReplayOptions.unmaskViewClasses.remove("android.widget.TextView");
            boolean bl2 = true;
            SentryReplayOptions sentryReplayOptions2 = this;
            sentryReplayOptions2.addMaskViewClass("android.widget.ImageView");
            sentryReplayOptions2.unmaskViewClasses.remove("android.widget.ImageView");
            this.maskViewClasses.add("android.webkit.WebView");
            this.maskViewClasses.add("android.widget.VideoView");
            this.maskViewClasses.add("androidx.media3.ui.PlayerView");
            this.maskViewClasses.add("com.google.android.exoplayer2.ui.PlayerView");
            this.maskViewClasses.add("com.google.android.exoplayer2.ui.StyledPlayerView");
        }
    }

    public final Double getOnErrorSampleRate() {
        return this.onErrorSampleRate;
    }

    /*
     * WARNING - void declaration
     */
    private void addMaskViewClass(String className) {
        void var1_1;
        this.maskViewClasses.add((String)var1_1);
    }

    public static enum SentryReplayQuality {
        LOW(0.8f, 50000),
        MEDIUM(1.0f, 75000),
        HIGH(1.0f, 100000);

        public final float sizeScale;
        public final int bitRate;

        /*
         * WARNING - void declaration
         */
        private SentryReplayQuality(float sizeScale, int bitRate) {
            void var3_3;
            this.sizeScale = var3_3;
            this.bitRate = bitRate;
        }
    }
}

