/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.DateUtils;
import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonSerializable;
import io.sentry.ObjectWriter;
import io.sentry.SentryBaseEvent;
import io.sentry.protocol.SentryId;
import io.sentry.util.Objects;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public final class SentryReplayEvent
extends SentryBaseEvent
implements JsonSerializable {
    private String type = "replay_event";
    private ReplayType replayType;
    private SentryId replayId = new SentryId();
    private int segmentId;
    private Date timestamp;
    private Date replayStartTimestamp;
    private List<String> urls;
    private List<String> errorIds;
    private List<String> traceIds;
    private Map<String, Object> unknown;

    public SentryReplayEvent() {
        this.replayType = ReplayType.SESSION;
        this.errorIds = new ArrayList<String>();
        this.traceIds = new ArrayList<String>();
        this.urls = new ArrayList<String>();
        this.timestamp = DateUtils.getCurrentDateTime();
    }

    /*
     * WARNING - void declaration
     */
    public final void setType(String type) {
        void var1_1;
        this.type = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setReplayId(SentryId replayId) {
        void var1_1;
        this.replayId = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setSegmentId(int segmentId) {
        void var1_1;
        this.segmentId = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setTimestamp(Date timestamp) {
        void var1_1;
        this.timestamp = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setReplayStartTimestamp(Date replayStartTimestamp) {
        void var1_1;
        this.replayStartTimestamp = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setUrls(List<String> urls) {
        void var1_1;
        this.urls = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setErrorIds(List<String> errorIds) {
        void var1_1;
        this.errorIds = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setTraceIds(List<String> traceIds) {
        void var1_1;
        this.traceIds = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setReplayType(ReplayType replayType) {
        void var1_1;
        this.replayType = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SentryReplayEvent that = (SentryReplayEvent)o;
        return this.segmentId == that.segmentId && Objects.equals(this.type, that.type) && this.replayType == that.replayType && Objects.equals(this.replayId, that.replayId) && Objects.equals(this.urls, that.urls) && Objects.equals(this.errorIds, that.errorIds) && Objects.equals(this.traceIds, var1_1.traceIds);
    }

    public final int hashCode() {
        Object[] objectArray = new Object[]{this.type, this.replayType, this.replayId, this.segmentId, this.urls, this.errorIds, this.traceIds};
        return Arrays.hashCode(objectArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void serialize(ObjectWriter writer, ILogger logger) throws IOException {
        void var1_1;
        writer.beginObject$4f1a06e9();
        writer.name$7c2ed8b3("type").value$7c2ed8b3(this.type);
        writer.name$7c2ed8b3("replay_type").value$74e4a76(logger, this.replayType);
        writer.name$7c2ed8b3("segment_id").value$1b925ea3(this.segmentId);
        writer.name$7c2ed8b3("timestamp").value$74e4a76(logger, this.timestamp);
        if (this.replayId != null) {
            writer.name$7c2ed8b3("replay_id").value$74e4a76(logger, this.replayId);
        }
        if (this.replayStartTimestamp != null) {
            writer.name$7c2ed8b3("replay_start_timestamp").value$74e4a76(logger, this.replayStartTimestamp);
        }
        if (this.urls != null) {
            writer.name$7c2ed8b3("urls").value$74e4a76(logger, this.urls);
        }
        if (this.errorIds != null) {
            writer.name$7c2ed8b3("error_ids").value$74e4a76(logger, this.errorIds);
        }
        if (this.traceIds != null) {
            writer.name$7c2ed8b3("trace_ids").value$74e4a76(logger, this.traceIds);
        }
        new SentryBaseEvent.Serializer();
        SentryBaseEvent.Serializer.serialize(this, writer, logger);
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value = this.unknown.get(key);
                writer.name$7c2ed8b3(key).value$74e4a76(logger, value);
            }
        }
        var1_1.endObject$4f1a06e9();
    }

    /*
     * WARNING - void declaration
     */
    public final void setUnknown(Map<String, Object> unknown) {
        void var1_1;
        this.unknown = var1_1;
    }

    public static enum ReplayType implements JsonSerializable
    {
        SESSION,
        BUFFER;


        @Override
        public final void serialize(ObjectWriter writer, ILogger logger) throws IOException {
            writer.value$7c2ed8b3(this.name().toLowerCase(Locale.ROOT));
        }

        public static final class Deserializer
        implements JsonDeserializer<ReplayType> {
        }
    }

    public static final class Deserializer
    implements JsonDeserializer<SentryReplayEvent> {
    }
}

