/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.DateUtils;
import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonSerializable;
import io.sentry.ObjectWriter;
import io.sentry.SentryBaseEvent;
import io.sentry.SentryLevel;
import io.sentry.SentryValues;
import io.sentry.protocol.Message;
import io.sentry.protocol.SentryException;
import io.sentry.protocol.SentryId;
import io.sentry.protocol.SentryThread;
import io.sentry.util.CollectionUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public final class SentryEvent
extends SentryBaseEvent
implements JsonSerializable {
    private Date timestamp;
    private Message message;
    private String logger;
    private SentryValues<SentryThread> threads;
    private SentryValues<SentryException> exception;
    private SentryLevel level;
    private String transaction;
    private List<String> fingerprint;
    private Map<String, Object> unknown;
    private Map<String, String> modules;

    /*
     * WARNING - void declaration
     */
    private SentryEvent(SentryId eventId, Date timestamp) {
        super((SentryId)var1_1);
        void var2_2;
        void var1_1;
        this.timestamp = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public SentryEvent(Throwable throwable) {
        this();
        void var1_1;
        this.throwable = var1_1;
    }

    public SentryEvent() {
        this(new SentryId(), DateUtils.getCurrentDateTime());
    }

    public final Message getMessage() {
        return this.message;
    }

    /*
     * WARNING - void declaration
     */
    public final void setMessage(Message message) {
        void var1_1;
        this.message = var1_1;
    }

    public final String getLogger() {
        return this.logger;
    }

    /*
     * WARNING - void declaration
     */
    public final void setLogger(String logger) {
        void var1_1;
        this.logger = var1_1;
    }

    public final List<SentryThread> getThreads() {
        if (this.threads != null) {
            return this.threads.getValues();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final void setThreads(List<SentryThread> threads) {
        void var1_1;
        this.threads = new SentryValues(var1_1);
    }

    public final List<SentryException> getExceptions() {
        if (this.exception == null) {
            return null;
        }
        return this.exception.getValues();
    }

    /*
     * WARNING - void declaration
     */
    public final void setExceptions(List<SentryException> exception) {
        void var1_1;
        this.exception = new SentryValues(var1_1);
    }

    public final SentryLevel getLevel() {
        return this.level;
    }

    /*
     * WARNING - void declaration
     */
    public final void setLevel(SentryLevel level) {
        void var1_1;
        this.level = var1_1;
    }

    public final String getTransaction() {
        return this.transaction;
    }

    /*
     * WARNING - void declaration
     */
    public final void setTransaction(String transaction) {
        void var1_1;
        this.transaction = var1_1;
    }

    public final List<String> getFingerprints() {
        return this.fingerprint;
    }

    /*
     * WARNING - void declaration
     */
    public final void setFingerprints(List<String> fingerprint) {
        void var1_1;
        this.fingerprint = fingerprint != null ? new ArrayList(var1_1) : null;
    }

    final Map<String, String> getModules() {
        return this.modules;
    }

    /*
     * WARNING - void declaration
     */
    public final void setModules(Map<String, String> modules) {
        void var1_1;
        this.modules = CollectionUtils.newHashMap(var1_1);
    }

    public final boolean isCrashed() {
        return this.getUnhandledException() != null;
    }

    /*
     * WARNING - void declaration
     */
    private SentryException getUnhandledException() {
        if (this.exception != null) {
            for (SentryException e : this.exception.getValues()) {
                void var2_2;
                if (e.getMechanism() == null || e.getMechanism().isHandled() == null || e.getMechanism().isHandled().booleanValue()) continue;
                return var2_2;
            }
        }
        return null;
    }

    public final boolean isErrored() {
        return this.exception != null && !this.exception.getValues().isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void serialize(ObjectWriter writer, ILogger logger) throws IOException {
        void var1_1;
        writer.beginObject$4f1a06e9();
        writer.name$7c2ed8b3("timestamp").value$74e4a76(logger, this.timestamp);
        if (this.message != null) {
            writer.name$7c2ed8b3("message").value$74e4a76(logger, this.message);
        }
        if (this.logger != null) {
            writer.name$7c2ed8b3("logger").value$7c2ed8b3(this.logger);
        }
        if (this.threads != null && !this.threads.getValues().isEmpty()) {
            writer.name$7c2ed8b3("threads");
            writer.beginObject$4f1a06e9();
            writer.name$7c2ed8b3("values").value$74e4a76(logger, this.threads.getValues());
            writer.endObject$4f1a06e9();
        }
        if (this.exception != null && !this.exception.getValues().isEmpty()) {
            writer.name$7c2ed8b3("exception");
            writer.beginObject$4f1a06e9();
            writer.name$7c2ed8b3("values").value$74e4a76(logger, this.exception.getValues());
            writer.endObject$4f1a06e9();
        }
        if (this.level != null) {
            writer.name$7c2ed8b3("level").value$74e4a76(logger, this.level);
        }
        if (this.transaction != null) {
            writer.name$7c2ed8b3("transaction").value$7c2ed8b3(this.transaction);
        }
        if (this.fingerprint != null) {
            writer.name$7c2ed8b3("fingerprint").value$74e4a76(logger, this.fingerprint);
        }
        if (this.modules != null) {
            writer.name$7c2ed8b3("modules").value$74e4a76(logger, this.modules);
        }
        new SentryBaseEvent.Serializer();
        SentryBaseEvent.Serializer.serialize(this, writer, logger);
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value = this.unknown.get(key);
                writer.name$7c2ed8b3(key);
                writer.value$74e4a76(logger, value);
            }
        }
        var1_1.endObject$4f1a06e9();
    }

    /*
     * WARNING - void declaration
     */
    public final void setUnknown(Map<String, Object> unknown) {
        void var1_1;
        this.unknown = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Date access$002(SentryEvent x0, Date x1) {
        void var1_1;
        x0.timestamp = var1_1;
        return x0.timestamp;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Message access$102(SentryEvent x0, Message x1) {
        void var1_1;
        x0.message = var1_1;
        return x0.message;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$202(SentryEvent x0, String x1) {
        void var1_1;
        x0.logger = var1_1;
        return x0.logger;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ SentryValues access$302(SentryEvent x0, SentryValues x1) {
        void var1_1;
        x0.threads = var1_1;
        return x0.threads;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ SentryValues access$402(SentryEvent x0, SentryValues x1) {
        void var1_1;
        x0.exception = var1_1;
        return x0.exception;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ SentryLevel access$502(SentryEvent x0, SentryLevel x1) {
        void var1_1;
        x0.level = var1_1;
        return x0.level;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$602(SentryEvent x0, String x1) {
        void var1_1;
        x0.transaction = var1_1;
        return x0.transaction;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ List access$702(SentryEvent x0, List x1) {
        void var1_1;
        x0.fingerprint = var1_1;
        return x0.fingerprint;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Map access$802(SentryEvent x0, Map x1) {
        void var1_1;
        x0.modules = var1_1;
        return x0.modules;
    }

    public static final class Deserializer
    implements JsonDeserializer<SentryEvent> {
    }
}

