/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonSerializable;
import io.sentry.ObjectWriter;
import io.sentry.SentryOptions;
import io.sentry.TracesSamplingDecision;
import java.io.IOException;
import java.util.Map;

public final class SentryAppStartProfilingOptions
implements JsonSerializable {
    boolean profileSampled;
    Double profileSampleRate;
    boolean traceSampled;
    Double traceSampleRate;
    String profilingTracesDirPath;
    boolean isProfilingEnabled;
    int profilingTracesHz;
    private Map<String, Object> unknown;

    public SentryAppStartProfilingOptions() {
        this.traceSampled = false;
        this.traceSampleRate = null;
        this.profileSampled = false;
        this.profileSampleRate = null;
        this.profilingTracesDirPath = null;
        this.isProfilingEnabled = false;
        this.profilingTracesHz = 0;
    }

    /*
     * WARNING - void declaration
     */
    SentryAppStartProfilingOptions(SentryOptions options, TracesSamplingDecision samplingDecision) {
        void var1_1;
        void var2_2;
        this.traceSampled = samplingDecision.getSampled();
        this.traceSampleRate = samplingDecision.getSampleRate();
        this.profileSampled = samplingDecision.getProfileSampled();
        this.profileSampleRate = var2_2.getProfileSampleRate();
        this.profilingTracesDirPath = options.getProfilingTracesDirPath();
        this.isProfilingEnabled = options.isProfilingEnabled();
        this.profilingTracesHz = var1_1.getProfilingTracesHz();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void serialize(ObjectWriter writer, ILogger logger) throws IOException {
        void var1_1;
        writer.beginObject$4f1a06e9();
        writer.name$7c2ed8b3("profile_sampled").value$74e4a76(logger, this.profileSampled);
        writer.name$7c2ed8b3("profile_sample_rate").value$74e4a76(logger, this.profileSampleRate);
        writer.name$7c2ed8b3("trace_sampled").value$74e4a76(logger, this.traceSampled);
        writer.name$7c2ed8b3("trace_sample_rate").value$74e4a76(logger, this.traceSampleRate);
        writer.name$7c2ed8b3("profiling_traces_dir_path").value$74e4a76(logger, this.profilingTracesDirPath);
        writer.name$7c2ed8b3("is_profiling_enabled").value$74e4a76(logger, this.isProfilingEnabled);
        writer.name$7c2ed8b3("profiling_traces_hz").value$74e4a76(logger, this.profilingTracesHz);
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value = this.unknown.get(key);
                writer.name$7c2ed8b3(key);
                writer.value$74e4a76(logger, value);
            }
        }
        var1_1.endObject$4f1a06e9();
    }

    /*
     * WARNING - void declaration
     */
    public final void setUnknown(Map<String, Object> unknown) {
        void var1_1;
        this.unknown = var1_1;
    }

    public static final class Deserializer
    implements JsonDeserializer<SentryAppStartProfilingOptions> {
    }
}

