/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonSerializable;
import io.sentry.NoOpTransaction;
import io.sentry.ObjectWriter;
import io.sentry.util.Objects;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;

public final class ProfilingTransactionData
implements JsonSerializable {
    private String id;
    private String traceId;
    private String name;
    private Long relativeStartNs;
    private Long relativeEndNs;
    private Long relativeStartCpuMs;
    private Long relativeEndCpuMs;
    private Map<String, Object> unknown;

    public ProfilingTransactionData() {
        this(NoOpTransaction.getInstance(), 0L, 0L);
    }

    /*
     * WARNING - void declaration
     */
    private ProfilingTransactionData(NoOpTransaction transaction, Long startNs, Long startCpuMs) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.id = transaction.getEventId().toString();
        this.traceId = transaction.getSpanContext().getTraceId().toString();
        this.name = transaction.getName().isEmpty() ? "unknown" : var1_1.getName();
        this.relativeStartNs = var2_2;
        this.relativeStartCpuMs = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProfilingTransactionData that = (ProfilingTransactionData)o;
        return this.id.equals(that.id) && this.traceId.equals(that.traceId) && this.name.equals(that.name) && this.relativeStartNs.equals(that.relativeStartNs) && this.relativeStartCpuMs.equals(that.relativeStartCpuMs) && Objects.equals(this.relativeEndCpuMs, that.relativeEndCpuMs) && Objects.equals(this.relativeEndNs, that.relativeEndNs) && Objects.equals(this.unknown, var1_1.unknown);
    }

    public final int hashCode() {
        Object[] objectArray = new Object[]{this.id, this.traceId, this.name, this.relativeStartNs, this.relativeEndNs, this.relativeStartCpuMs, this.relativeEndCpuMs, this.unknown};
        return Arrays.hashCode(objectArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void serialize(ObjectWriter writer, ILogger logger) throws IOException {
        void var1_1;
        writer.beginObject$4f1a06e9();
        writer.name$7c2ed8b3("id").value$74e4a76(logger, this.id);
        writer.name$7c2ed8b3("trace_id").value$74e4a76(logger, this.traceId);
        writer.name$7c2ed8b3("name").value$74e4a76(logger, this.name);
        writer.name$7c2ed8b3("relative_start_ns").value$74e4a76(logger, this.relativeStartNs);
        writer.name$7c2ed8b3("relative_end_ns").value$74e4a76(logger, this.relativeEndNs);
        writer.name$7c2ed8b3("relative_cpu_start_ms").value$74e4a76(logger, this.relativeStartCpuMs);
        writer.name$7c2ed8b3("relative_cpu_end_ms").value$74e4a76(logger, this.relativeEndCpuMs);
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value = this.unknown.get(key);
                writer.name$7c2ed8b3(key);
                writer.value$74e4a76(logger, value);
            }
        }
        var1_1.endObject$4f1a06e9();
    }

    /*
     * WARNING - void declaration
     */
    public final void setUnknown(Map<String, Object> unknown) {
        void var1_1;
        this.unknown = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$002(ProfilingTransactionData x0, String x1) {
        void var1_1;
        x0.id = var1_1;
        return x0.id;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$102(ProfilingTransactionData x0, String x1) {
        void var1_1;
        x0.traceId = var1_1;
        return x0.traceId;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$202(ProfilingTransactionData x0, String x1) {
        void var1_1;
        x0.name = var1_1;
        return x0.name;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Long access$302(ProfilingTransactionData x0, Long x1) {
        void var1_1;
        x0.relativeStartNs = var1_1;
        return x0.relativeStartNs;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Long access$402(ProfilingTransactionData x0, Long x1) {
        void var1_1;
        x0.relativeEndNs = var1_1;
        return x0.relativeEndNs;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Long access$502(ProfilingTransactionData x0, Long x1) {
        void var1_1;
        x0.relativeStartCpuMs = var1_1;
        return x0.relativeStartCpuMs;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Long access$602(ProfilingTransactionData x0, Long x1) {
        void var1_1;
        x0.relativeEndCpuMs = var1_1;
        return x0.relativeEndCpuMs;
    }

    public static final class Deserializer
    implements JsonDeserializer<ProfilingTransactionData> {
    }
}

