/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.DateUtils;
import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.SentryLevel;
import io.sentry.protocol.MetricSummary;
import io.sentry.vendor.gson.stream.JsonToken;
import java.io.Closeable;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public interface ObjectReader
extends Closeable {
    /*
     * WARNING - void declaration
     */
    public static Date dateOrNull(String dateString, ILogger logger) {
        if (dateString == null) {
            return null;
        }
        try {
            return DateUtils.getDateTime(dateString);
        }
        catch (Exception exception) {
            try {
                return DateUtils.getDateTimeWithMillisPrecision(dateString);
            }
            catch (Exception e) {
                void var0_1;
                void var1_2;
                var1_2.log(SentryLevel.ERROR, "Error when deserializing millis timestamp format.", (Throwable)var0_1);
                return null;
            }
        }
    }

    public void nextUnknown(ILogger var1, Map<String, Object> var2, String var3);

    public <T> List<T> nextListOrNull(ILogger var1, JsonDeserializer<T> var2) throws IOException;

    public <T> Map<String, T> nextMapOrNull(ILogger var1, JsonDeserializer<T> var2) throws IOException;

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public Map nextMapOfListOrNull$6cb976c4(ILogger var1, MetricSummary.Deserializer var2) throws IOException;

    public <T> T nextOrNull(ILogger var1, JsonDeserializer<T> var2) throws Exception;

    public Date nextDateOrNull(ILogger var1) throws IOException;

    public TimeZone nextTimeZoneOrNull(ILogger var1) throws IOException;

    public Object nextObjectOrNull() throws IOException;

    public JsonToken peek() throws IOException;

    public String nextName() throws IOException;

    public void beginObject() throws IOException;

    public void endObject() throws IOException;

    public int nextInt() throws IOException;

    public Integer nextIntegerOrNull() throws IOException;

    public long nextLong() throws IOException;

    public Long nextLongOrNull() throws IOException;

    public String nextString() throws IOException;

    public String nextStringOrNull() throws IOException;

    public Boolean nextBooleanOrNull() throws IOException;

    public double nextDouble() throws IOException;

    public Double nextDoubleOrNull() throws IOException;

    public float nextFloat() throws IOException;

    public Float nextFloatOrNull() throws IOException;

    public void setLenient(boolean var1);

    public void skipValue() throws IOException;
}

