/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.Hint;
import io.sentry.IHub;
import io.sentry.ITransaction;
import io.sentry.SentryEnvelope;
import io.sentry.SentryEvent;
import io.sentry.SentryOptions;
import io.sentry.metrics.MetricsApi;
import io.sentry.metrics.NoopMetricsAggregator;
import io.sentry.protocol.SentryId;

public final class NoOpHub
implements IHub {
    private static final NoOpHub instance = new NoOpHub();
    private final SentryOptions emptyOptions = SentryOptions.empty();
    private final MetricsApi metricsApi = new MetricsApi(NoopMetricsAggregator.getInstance());

    private NoOpHub() {
    }

    public static NoOpHub getInstance() {
        return instance;
    }

    @Override
    public final boolean isEnabled() {
        return false;
    }

    @Override
    public final SentryId captureEvent(SentryEvent event, Hint hint) {
        return SentryId.EMPTY_ID;
    }

    @Override
    public final SentryId captureEnvelope(SentryEnvelope envelope, Hint hint) {
        return SentryId.EMPTY_ID;
    }

    @Override
    public final SentryId captureException(Throwable throwable, Hint hint) {
        return SentryId.EMPTY_ID;
    }

    @Override
    public final void close(boolean isRestarting) {
    }

    @Override
    public final boolean isHealthy() {
        return true;
    }

    @Override
    public final void flush(long timeoutMillis) {
    }

    @Override
    public final IHub clone() {
        return instance;
    }

    @Override
    public final ITransaction getTransaction() {
        return null;
    }
}

