/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.ILogger;
import io.sentry.IMetricsAggregator;
import io.sentry.ISentryExecutorService;
import io.sentry.NoOpSentryExecutorService;
import io.sentry.SentryClient;
import io.sentry.SentryDateProvider;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.metrics.EncodedMetrics;
import io.sentry.metrics.IMetricsClient;
import io.sentry.metrics.Metric;
import io.sentry.metrics.MetricsHelper;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class MetricsAggregator
implements IMetricsAggregator,
Closeable,
Runnable {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private final ILogger logger;
    private final IMetricsClient client;
    private final SentryDateProvider dateProvider;
    private final SentryOptions.BeforeEmitMetricCallback beforeEmitCallback;
    private volatile ISentryExecutorService executorService;
    private volatile boolean isClosed = false;
    private volatile boolean flushScheduled = false;
    private final NavigableMap<Long, Map<String, Metric>> buckets = new ConcurrentSkipListMap<Long, Map<String, Metric>>();
    private final AtomicInteger totalBucketsWeight = new AtomicInteger();
    private final int maxWeight;

    /*
     * WARNING - void declaration
     */
    public MetricsAggregator(SentryOptions options, SentryClient client) {
        this((IMetricsClient)var2_2, options.getLogger(), options.getDateProvider(), 100000, var1_1.getBeforeEmitMetricCallback(), NoOpSentryExecutorService.getInstance$6fecc271());
        void var1_1;
        void var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private MetricsAggregator(IMetricsClient client, ILogger logger, SentryDateProvider dateProvider, int maxWeight, SentryOptions.BeforeEmitMetricCallback beforeEmitCallback, ISentryExecutorService executorService) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.client = var1_1;
        this.logger = var2_2;
        this.dateProvider = var3_3;
        this.maxWeight = 100000;
        this.beforeEmitCallback = beforeEmitCallback;
        this.executorService = executorService;
    }

    /*
     * WARNING - void declaration
     */
    private void flush(boolean force2) {
        void var2_11;
        void var3_12;
        Iterator iterator;
        Set flushableBuckets;
        Set set;
        int n;
        Object object;
        if (force2 == 0) {
            object = this;
            n = ((MetricsAggregator)object).buckets.size() + ((MetricsAggregator)object).totalBucketsWeight.get();
            if (n >= ((MetricsAggregator)object).maxWeight) {
                this.logger.log(SentryLevel.INFO, "Metrics: total weight exceeded, flushing all buckets", new Object[0]);
                force2 = 1;
            }
        }
        this.flushScheduled = false;
        n = force2;
        object = this;
        if (n != 0) {
            set = ((MetricsAggregator)object).buckets.keySet();
        } else {
            MetricsAggregator force2 = object;
            long l = MetricsHelper.getCutoffTimestampMs(TimeUnit.NANOSECONDS.toMillis(force2.dateProvider.now().nanoTimestamp()));
            long l2 = MetricsHelper.getTimeBucketKey(l);
            set = flushableBuckets = ((MetricsAggregator)object).buckets.headMap(l2, true).keySet();
        }
        if (set.isEmpty()) {
            this.logger.log(SentryLevel.DEBUG, "Metrics: nothing to flush", new Object[0]);
            return;
        }
        this.logger.log(SentryLevel.DEBUG, "Metrics: flushing " + flushableBuckets.size() + " buckets", new Object[0]);
        HashMap<Long, Map> snapshot = new HashMap<Long, Map>();
        int numMetrics = 0;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            long bucketKey = (Long)iterator.next();
            Map bucket = (Map)this.buckets.remove(bucketKey);
            if (bucket == null) continue;
            Map map = bucket;
            synchronized (map) {
                object = bucket;
                n = 0;
                Iterator iterator2 = object.values().iterator();
                if (iterator2.hasNext()) {
                    Metric metric = (Metric)iterator2.next();
                    int n2 = n;
                    Metric metric2 = metric;
                    throw null;
                }
                int weight = n;
                this.totalBucketsWeight.addAndGet(-weight);
                numMetrics += bucket.size();
                snapshot.put(bucketKey, bucket);
            }
        }
        if (var3_12 == false) {
            this.logger.log(SentryLevel.DEBUG, "Metrics: only empty buckets found", new Object[0]);
            return;
        }
        this.logger.log(SentryLevel.DEBUG, "Metrics: capturing metrics", new Object[0]);
        this.client.captureMetrics(new EncodedMetrics((Map<Long, Map<String, Metric>>)var2_11));
    }

    @Override
    public final void close() throws IOException {
        MetricsAggregator metricsAggregator = this;
        synchronized (metricsAggregator) {
            this.isClosed = true;
            this.executorService.close(0L);
        }
        this.flush(true);
    }

    @Override
    public final void run() {
        this.flush(false);
        MetricsAggregator metricsAggregator = this;
        synchronized (metricsAggregator) {
            if (!this.isClosed && !this.buckets.isEmpty()) {
                this.executorService.schedule(this, 5000L);
            }
            return;
        }
    }
}

