/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.Hint;
import io.sentry.IHub;
import io.sentry.IScope;
import io.sentry.ISentryExecutorService;
import io.sentry.ISpan;
import io.sentry.ITransaction;
import io.sentry.Integration;
import io.sentry.Scope;
import io.sentry.ScopeCallback;
import io.sentry.SentryClient;
import io.sentry.SentryEnvelope;
import io.sentry.SentryEvent;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.Stack;
import io.sentry.TracesSampler;
import io.sentry.TransactionPerformanceCollector;
import io.sentry.metrics.MetricsApi;
import io.sentry.protocol.SentryId;
import io.sentry.util.ExceptionUtils;
import io.sentry.util.Objects;
import io.sentry.util.Pair;
import java.io.Closeable;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;

public final class Hub
implements IHub,
MetricsApi.IMetricsInterface {
    private volatile SentryId lastEventId;
    private final SentryOptions options;
    private volatile boolean isEnabled;
    private final Stack stack;
    private final TracesSampler tracesSampler;
    private final Map<Throwable, Pair<WeakReference<ISpan>, String>> throwableToSpan;
    private final TransactionPerformanceCollector transactionPerformanceCollector;
    private final MetricsApi metricsApi;

    /*
     * WARNING - void declaration
     */
    public Hub(SentryOptions options) {
        void var1_1;
        Hub.validateOptions((SentryOptions)var1_1);
        Scope scope = new Scope((SentryOptions)var1_1);
        SentryClient sentryClient = new SentryClient((SentryOptions)var1_1);
        this((SentryOptions)var1_1, new Stack.StackItem((SentryOptions)var1_1, sentryClient, scope));
    }

    /*
     * WARNING - void declaration
     */
    private Hub(SentryOptions options, Stack stack) {
        void var1_1;
        void var2_2;
        this.throwableToSpan = Collections.synchronizedMap(new WeakHashMap());
        Hub.validateOptions(options);
        this.options = options;
        this.tracesSampler = new TracesSampler(options);
        this.stack = var2_2;
        this.lastEventId = SentryId.EMPTY_ID;
        this.transactionPerformanceCollector = var1_1.getTransactionPerformanceCollector();
        this.isEnabled = true;
        this.metricsApi = new MetricsApi(this);
    }

    /*
     * WARNING - void declaration
     */
    private Hub(SentryOptions options, Stack.StackItem rootStackItem) {
        this(options, new Stack(var1_1.getLogger(), (Stack.StackItem)var2_2));
        void var2_2;
        void var1_1;
    }

    private static void validateOptions(SentryOptions options) {
        SentryOptions sentryOptions;
        Objects.requireNonNull(options, "SentryOptions is required.");
        if (options.getDsn() == null || sentryOptions.getDsn().isEmpty()) {
            throw new IllegalArgumentException("Hub requires a DSN to be instantiated. Considering using the NoOpHub if no DSN is available.");
        }
    }

    @Override
    public final boolean isEnabled() {
        return this.isEnabled;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final SentryId captureEvent(SentryEvent event, Hint hint) {
        void var2_2;
        void var1_1;
        return this.captureEventInternal((SentryEvent)var1_1, (Hint)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    private SentryId captureEventInternal(SentryEvent event, Hint hint, ScopeCallback scopeCallback) {
        void var3_3;
        SentryId sentryId = SentryId.EMPTY_ID;
        Hub hub = this;
        if (!hub.isEnabled) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'captureEvent' call is a no-op.", new Object[0]);
        } else if (event == null) {
            this.options.getLogger().log(SentryLevel.WARNING, "captureEvent called with null parameter.", new Object[0]);
        } else {
            try {
                void var2_2;
                this.assignTraceContext(event);
                Stack.StackItem item = this.stack.peek();
                IScope scope = this.buildLocalScope(item.getScope(), null);
                this.lastEventId = sentryId = item.getClient().captureEvent(event, scope, (Hint)var2_2);
            }
            catch (Throwable e) {
                void var1_1;
                this.options.getLogger().log(SentryLevel.ERROR, "Error while capturing event with id: " + var1_1.getEventId(), e);
            }
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final SentryId captureEnvelope(SentryEnvelope envelope, Hint hint) {
        void var3_4;
        Objects.requireNonNull(envelope, "SentryEnvelope is required.");
        SentryId sentryId = SentryId.EMPTY_ID;
        Hub hub = this;
        if (!hub.isEnabled) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'captureEnvelope' call is a no-op.", new Object[0]);
        } else {
            try {
                void var2_3;
                SentryId capturedEnvelopeId = this.stack.peek().getClient().captureEnvelope(envelope, (Hint)var2_3);
                if (capturedEnvelopeId != null) {
                    sentryId = capturedEnvelopeId;
                }
            }
            catch (Throwable e) {
                void var1_2;
                this.options.getLogger().log(SentryLevel.ERROR, "Error while capturing envelope.", (Throwable)var1_2);
            }
        }
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final SentryId captureException(Throwable throwable, Hint hint) {
        void var2_2;
        void var1_1;
        return this.captureExceptionInternal((Throwable)var1_1, (Hint)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    private SentryId captureExceptionInternal(Throwable throwable, Hint hint, ScopeCallback scopeCallback) {
        void var3_3;
        SentryId sentryId = SentryId.EMPTY_ID;
        Hub hub = this;
        if (!hub.isEnabled) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'captureException' call is a no-op.", new Object[0]);
        } else if (throwable == null) {
            this.options.getLogger().log(SentryLevel.WARNING, "captureException called with null parameter.", new Object[0]);
        } else {
            try {
                void var2_2;
                Stack.StackItem item = this.stack.peek();
                SentryEvent event = new SentryEvent(throwable);
                this.assignTraceContext(event);
                IScope scope = this.buildLocalScope(item.getScope(), null);
                sentryId = item.getClient().captureEvent(event, scope, (Hint)var2_2);
            }
            catch (Throwable e) {
                void var1_1;
                this.options.getLogger().log(SentryLevel.ERROR, "Error while capturing exception: " + var1_1.getMessage(), e);
            }
        }
        this.lastEventId = sentryId;
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private void assignTraceContext(SentryEvent event) {
        Pair<WeakReference<ISpan>, String> pair;
        if (this.options.isTracingEnabled() && event.getThrowable() != null && (pair = this.throwableToSpan.get(ExceptionUtils.findRootCause(event.getThrowable()))) != null) {
            void var2_2;
            ISpan span;
            WeakReference<ISpan> spanWeakRef = pair.getFirst();
            if (event.getContexts().getTrace() == null && spanWeakRef != null && (span = (ISpan)spanWeakRef.get()) != null) {
                event.getContexts().setTrace(span.getSpanContext());
            }
            String transactionName = (String)var2_2.getSecond();
            if (event.getTransaction() == null && transactionName != null) {
                void var3_3;
                void var1_1;
                var1_1.setTransaction((String)var3_3);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void close(boolean isRestarting) {
        Hub hub = this;
        if (!hub.isEnabled) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'close' call is a no-op.", new Object[0]);
            return;
        }
        try {
            void var1_1;
            Stack.StackItem stackItem;
            for (Integration integration : this.options.getIntegrations()) {
                if (!(integration instanceof Closeable)) continue;
                try {
                    ((Closeable)((Object)integration)).close();
                }
                catch (IOException e) {
                    this.options.getLogger().log(SentryLevel.WARNING, "Failed to close the integration {}.", stackItem, e);
                }
            }
            this.configureScope(scope -> scope.clear());
            this.options.getTransactionProfiler();
            this.options.getTransactionPerformanceCollector();
            ISentryExecutorService executorService = this.options.getExecutorService();
            if (isRestarting) {
                executorService.submit(() -> executorService.close(this.options.getShutdownTimeoutMillis()));
            } else {
                executorService.close(this.options.getShutdownTimeoutMillis());
            }
            stackItem = this.stack.peek();
            stackItem.getClient().close((boolean)var1_1);
        }
        catch (Throwable e) {
            void var2_3;
            this.options.getLogger().log(SentryLevel.ERROR, "Error while closing the Hub.", (Throwable)var2_3);
        }
        this.isEnabled = false;
    }

    /*
     * WARNING - void declaration
     */
    public final void configureScope(ScopeCallback callback) {
        Hub hub = this;
        if (!hub.isEnabled) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'configureScope' call is a no-op.", new Object[0]);
            return;
        }
        try {
            callback.run(this.stack.peek().getScope());
            return;
        }
        catch (Throwable e) {
            void var1_2;
            this.options.getLogger().log(SentryLevel.ERROR, "Error in the 'configureScope' callback.", (Throwable)var1_2);
            return;
        }
    }

    @Override
    public final boolean isHealthy() {
        return this.stack.peek().getClient().isHealthy();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void flush(long timeoutMillis) {
        Hub hub = this;
        if (!hub.isEnabled) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'flush' call is a no-op.", new Object[0]);
            return;
        }
        try {
            this.stack.peek().getClient().flush(timeoutMillis);
            return;
        }
        catch (Throwable e) {
            void var1_2;
            this.options.getLogger().log(SentryLevel.ERROR, "Error in the 'client.flush'.", (Throwable)var1_2);
            return;
        }
    }

    @Override
    public final IHub clone() {
        Hub hub = this;
        if (!hub.isEnabled) {
            this.options.getLogger().log(SentryLevel.WARNING, "Disabled Hub cloned.", new Object[0]);
        }
        return new Hub(this.options, new Stack(this.stack));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ITransaction getTransaction() {
        void var1_1;
        ITransaction span = null;
        Hub hub = this;
        if (!hub.isEnabled) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'getTransaction' call is a no-op.", new Object[0]);
        } else {
            span = this.stack.peek().getScope().getTransaction();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private IScope buildLocalScope(IScope scope, ScopeCallback callback) {
        void var1_1;
        if (callback != null) {
            try {
                void var2_2;
                Scope localScope = scope.clone$314c5022();
                var2_2.run(localScope);
                return localScope;
            }
            catch (Throwable t) {
                void var3_4;
                this.options.getLogger().log(SentryLevel.ERROR, "Error in the 'ScopeCallback' callback.", (Throwable)var3_4);
            }
        }
        return var1_1;
    }
}

